/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database.creator;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.factory.AbstractOwlProjectCreator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public abstract class AbstractOwlDatabaseCreator
extends AbstractOwlProjectCreator {
    private String driver;
    private String table;
    private String username;
    private String password;
    private String url;
    protected Project project;

    protected AbstractOwlDatabaseCreator(OWLDatabaseKnowledgeBaseFactory oWLDatabaseKnowledgeBaseFactory) {
        super(oWLDatabaseKnowledgeBaseFactory);
    }

    public void create(Collection collection) throws OntologyLoadException {
        this.project = Project.createBuildProject((KnowledgeBaseFactory)this.factory, (Collection)collection);
        this.initializeSources(this.project.getSources());
        this.project.createDomainKnowledgeBase((KnowledgeBaseFactory)this.factory, collection, true);
        this.insertRepositoriesIntoOwlModel((OWLModel)this.project.getKnowledgeBase());
    }

    public OWLDatabaseModel getOwlModel() {
        if (this.project != null) {
            return (OWLDatabaseModel)this.project.getKnowledgeBase();
        }
        return null;
    }

    public Project getProject() {
        return this.project;
    }

    protected void initializeSources(PropertyList propertyList) {
        DatabaseKnowledgeBaseFactory.setSources((PropertyList)propertyList, (String)this.driver, (String)this.url, (String)this.table, (String)this.username, (String)this.password);
    }

    protected void initializeTable(Collection collection) throws IOException {
        JenaKnowledgeBaseFactory.useStandalone = false;
        Project project = Project.createNewProject((KnowledgeBaseFactory)this.factory, (Collection)collection);
        this.initializeSources(project.getSources());
        File file = File.createTempFile("protege", "temp");
        project.setProjectFilePath(file.getPath());
        project.save(collection);
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setTable(String string) {
        this.table = string;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getTable() {
        return this.table;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }
}

