/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DatabasePlugin;
import edu.stanford.smi.protege.storage.database.DatabaseProperty;
import edu.stanford.smi.protege.storage.database.DatabaseWizardPage;
import edu.stanford.smi.protege.storage.database.DefaultDatabaseFrameDb;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protegex.owl.database.DatabaseFactoryUtils;
import edu.stanford.smi.protegex.owl.database.OWLDatabasePlugin;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLDatabaseWizardPage
extends DatabaseWizardPage {
    private static final long serialVersionUID = 251501005887139194L;
    private static transient Logger log = Log.getLogger(OWLDatabaseWizardPage.class);
    private OWLDatabasePlugin plugin;
    private JTextField ontologyName;

    public OWLDatabaseWizardPage(Wizard wizard, OWLDatabasePlugin oWLDatabasePlugin) {
        super(wizard, (DatabasePlugin)oWLDatabasePlugin);
        this.plugin = oWLDatabasePlugin;
    }

    protected Class<? extends DatabaseFrameDb> getDatabaseFrameDbClass() {
        return DefaultDatabaseFrameDb.class;
    }

    protected void layoutComponents(Box box) {
        if (!this.getFromExistingSources()) {
            this.ontologyName = ComponentFactory.createTextField((String)FactoryUtils.generateOntologyURIBase());
            this.ontologyName.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    OWLDatabaseWizardPage.this.updateSetPageComplete();
                }
            });
            box.add((Component)new LabeledComponent("Ontology Name", (Component)this.ontologyName));
        }
        super.layoutComponents(box);
    }

    protected boolean isComplete() {
        if (this.getFromExistingSources()) {
            return super.isComplete();
        }
        return super.isComplete() && this.isValidURL();
    }

    private boolean isValidURL() {
        try {
            new URL(this.ontologyName.getText());
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorText("Need valid URL for ontology name: " + malformedURLException);
            return false;
        }
    }

    public void onFinish() {
        if (!this.getFromExistingSources()) {
            this.plugin.setOntologyName(this.ontologyName.getText());
        }
        if (!this.okToCreateDatabase()) {
            throw new ProtegeIOException("Database already exists! and the user denied overwrite");
        }
        super.onFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean okToCreateDatabase() {
        Connection connection = null;
        try {
            try {
                Class.forName(this.getFieldText(DatabaseProperty.DRIVER_PROPERTY));
                connection = DriverManager.getConnection(this.getFieldText(DatabaseProperty.URL_PROPERTY), this.getFieldText(DatabaseProperty.USERNAME_PROPERTY), this.getFieldText(DatabaseProperty.PASSWORD_PROPERTY));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ProtegeIOException((Throwable)classNotFoundException);
            }
            catch (SQLException sQLException) {
                throw new ProtegeIOException((Throwable)sQLException);
            }
            boolean bl = this.okToCreateDatabase(connection);
            return bl;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                log.log(Level.WARNING, "Exception caught trying to close connections during database existence check.", sQLException);
            }
        }
    }

    private boolean okToCreateDatabase(Connection connection) {
        String string;
        if (!this.databaseExists(connection)) {
            return true;
        }
        try {
            string = DatabaseFactoryUtils.getOntologyFromTable(this.getDatabaseFrameDbClass(), this.getFieldText(DatabaseProperty.DRIVER_PROPERTY), this.getFieldText(DatabaseProperty.URL_PROPERTY), this.getFieldText(DatabaseProperty.USERNAME_PROPERTY), this.getFieldText(DatabaseProperty.PASSWORD_PROPERTY), this.getFieldText(DatabaseProperty.TABLENAME_PROPERTY));
        }
        catch (SQLException sQLException) {
            string = null;
        }
        if (this.getFromExistingSources() && !this.isFileToDatabase() && string != null) {
            return true;
        }
        String string2 = this.getFromExistingSources() && !this.isFileToDatabase() ? "Database already exists but is in the wrong format for an OWL Database Project.\nOverwrite with blank owl project?" : (string != null ? "Database table already exists and holds an ontology named\n" + string + ".\nOverwrite?" : "Database table already exists.  Overwrite?");
        int n = ModalDialog.showMessageDialog((Component)((Object)this), (String)string2, (String)"Overwrite Table?", (int)11);
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean databaseExists(Connection connection) {
        Statement statement;
        try {
            statement = connection.createStatement();
        }
        catch (SQLException sQLException) {
            throw new ProtegeIOException((Throwable)sQLException);
        }
        try {
            statement.execute("select count(*) from " + this.getFieldText(DatabaseProperty.TABLENAME_PROPERTY));
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "This exception should indicate that the table doesn't exist", sQLException);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                log.log(Level.WARNING, "Unexpected exception caught trying to check the  existence of a database table", sQLException);
            }
        }
    }

    public boolean getFromExistingSources() {
        return false;
    }

    public boolean isFileToDatabase() {
        return false;
    }
}

