/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.OntModelProvider;
import edu.stanford.smi.protegex.owl.jena.creator.JenaCreator;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import java.util.logging.Logger;

public class OWLDatabaseModel
extends AbstractOWLModel
implements OntModelProvider {
    private static transient Logger log = Log.getLogger(OWLDatabaseModel.class);
    static int idCounter = 0;
    private OWLOntology defaultDBOWLOntology;

    public OWLDatabaseModel(KnowledgeBaseFactory knowledgeBaseFactory) {
        super(knowledgeBaseFactory);
    }

    public OntModel getOntModel() {
        long l = System.currentTimeMillis();
        JenaCreator jenaCreator = new JenaCreator(this, false, null, new ModalProgressBarManager("Converting Ontology"));
        OntModel ontModel = jenaCreator.createOntModel();
        long l2 = System.currentTimeMillis();
        Log.getLogger().info("[OWLDatabaseModel.getOntModel] Duration " + (l2 - l));
        return ontModel;
    }

    public OntModel getOWLDLOntModel() {
        long l = System.currentTimeMillis();
        JenaCreator jenaCreator = new JenaCreator(this, true, null, new ModalProgressBarManager("Preparing Ontology"));
        OntModel ontModel = jenaCreator.createOntModel();
        long l2 = System.currentTimeMillis();
        log.info("[OWLDatabaseModel.getOWLDLOntModel] Duration " + (l2 - l));
        return ontModel;
    }

    public int getOWLSpecies() {
        OntModel ontModel = this.getOntModel();
        return Jena.getOWLSpecies(ontModel);
    }

    public OntModel getReasonerOntModel(String string) {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://foo.de#foo");
        model.add(resource, ReasonerVocabulary.EXT_REASONER_URL, string);
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", resource);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner((Reasoner)dIGReasoner);
        OntModel ontModel = Jena.cloneOntModel(this.getOntModel(), ontModelSpec);
        return ontModel;
    }

    public void initDefaultNamespaces() {
        NamespaceManager namespaceManager = this.getNamespaceManager();
        namespaceManager.setPrefix(OWL.getURI(), "owl");
        namespaceManager.setPrefix(RDF.getURI(), "rdf");
        namespaceManager.setPrefix(RDFS.getURI(), "rdfs");
        namespaceManager.setPrefix("http://www.w3.org/2001/XMLSchema#", "xsd");
        namespaceManager.setModifiable("owl", false);
        namespaceManager.setModifiable("rdf", false);
        namespaceManager.setModifiable("rdfs", false);
        namespaceManager.setModifiable("xsd", false);
    }
}

