/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protegex.owl.database.DatabaseFactoryUtils;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import edu.stanford.smi.protegex.owl.storage.OWLKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.ui.menu.OWLBackwardsCompatibilityProjectFixups;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OWLDatabaseKnowledgeBaseFactory
extends DatabaseKnowledgeBaseFactory
implements OWLKnowledgeBaseFactory {
    private static Logger log = Log.getLogger(OWLDatabaseKnowledgeBaseFactory.class);
    public static final String NAMESPACE_PREFIX_SEPARATOR = ":";

    public OWLDatabaseKnowledgeBaseFactory() {
        this.setOwlMode(true);
    }

    public KnowledgeBase createKnowledgeBase(Collection collection) {
        ResourceSelectionAction.setActivated(false);
        OWLDatabaseModel oWLDatabaseModel = new OWLDatabaseModel(this);
        return oWLDatabaseModel;
    }

    private void dump(Cls cls, String string) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(string + cls);
            for (Cls cls2 : cls.getDirectSubclasses()) {
                if (cls2.isEditable()) continue;
                try {
                    this.dump(cls2, string + "  ");
                }
                catch (Exception exception) {
                    log.fine("ERROR at " + cls + " / " + cls2);
                    for (Object e : cls2.getDirectSubclasses()) {
                        log.fine("- " + e + " = " + (e instanceof Slot) + " " + ((Instance)e).getDirectType());
                    }
                    Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                }
            }
        }
    }

    public String getProjectFilePath() {
        return "OWL.pprj";
    }

    public String getDescription() {
        return "OWL / RDF Database";
    }

    public void loadKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        OWLModel oWLModel = (OWLModel)knowledgeBase;
        super.loadKnowledgeBase(knowledgeBase, propertyList, collection);
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
        tripleStoreModel.setTopTripleStore(tripleStore);
        if (DatabaseFactoryUtils.readOWLOntologyFromDatabase(oWLModel, tripleStore)) {
            FactoryUtils.loadEncodedNamespaceFromModel(oWLModel, tripleStore, collection);
            FactoryUtils.addPrefixesToModelListener(oWLModel, tripleStore);
            oWLModel.resetOntologyCache();
            RepositoryFileManager.loadProjectRepositories(oWLModel);
            DatabaseFactoryUtils.loadImports(oWLModel, collection);
            try {
                ProtegeOWLParser.doFinalPostProcessing(oWLModel);
            }
            catch (OntologyLoadException ontologyLoadException) {
                Log.getLogger().log(Level.SEVERE, "Errors at loading knowledge base", ontologyLoadException);
                collection.add(new MessageError((Throwable)ontologyLoadException, "Errors at loading knowledge base"));
            }
        }
    }

    protected void initializeKB(KnowledgeBase knowledgeBase, String string, String string2, String string3, String string4, String string5, boolean bl) {
        AbstractOWLModel abstractOWLModel = (AbstractOWLModel)knowledgeBase;
        DatabaseFrameDb databaseFrameDb = OWLDatabaseKnowledgeBaseFactory.getDatabaseFrameDb((KnowledgeBase)abstractOWLModel);
        databaseFrameDb.initialize(abstractOWLModel.getFrameFactory(), string, string2, string3, string4, string5, bl);
        knowledgeBase.flushCache();
    }

    public void saveKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        if (knowledgeBase instanceof OWLModel) {
            OWLModel oWLModel = (OWLModel)knowledgeBase;
            TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
            OWLBackwardsCompatibilityProjectFixups.insertVersionData(propertyList);
            if (oWLModel instanceof JenaOWLModel) {
                TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
                DatabaseFactoryUtils.writeOWLOntologyToDatabase(oWLModel, tripleStore);
                FactoryUtils.encodeNamespaceIntoModel(oWLModel, tripleStore);
            }
            if (oWLModel instanceof JenaOWLModel) {
                knowledgeBase.removeFrameStore((FrameStore)oWLModel.getOWLFrameStore());
            }
            super.saveKnowledgeBase(knowledgeBase, propertyList, collection);
            RepositoryFileManager.saveProjectRepositories(oWLModel);
            if (oWLModel instanceof JenaOWLModel) {
                knowledgeBase.insertFrameStore((FrameStore)oWLModel.getOWLFrameStore(), 0);
            }
        } else {
            String string = "You can only save OWL projects to OWL Database format.";
            collection.add(new MessageError(string));
            Log.getLogger().severe(string);
        }
    }
}

