/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import edu.stanford.smi.protege.exception.AmalgamatedLoadException;
import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDbFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.swrl.SWRLSystemFrames;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseFactoryUtils {
    public static final transient Logger log = Log.getLogger(DatabaseFactoryUtils.class);

    public static boolean readOWLOntologyFromDatabase(OWLModel oWLModel, TripleStore tripleStore) {
        NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
        SWRLSystemFrames sWRLSystemFrames = oWLModel.getSystemFrames();
        RDFProperty rDFProperty = sWRLSystemFrames.getOwlOntologyPointerProperty();
        RDFIndividual rDFIndividual = DatabaseFactoryUtils.getOwlOntologyPointerInstance(oWLModel, narrowFrameStore);
        if (rDFIndividual != null) {
            OWLOntology oWLOntology = DatabaseFactoryUtils.getOwlOntology(narrowFrameStore, rDFIndividual, rDFProperty);
            tripleStore.setName(oWLOntology.getName());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOWLOntologyToDatabase(OWLModel oWLModel, TripleStore tripleStore) {
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        TripleStore tripleStore2 = tripleStoreModel.getActiveTripleStore();
        try {
            tripleStoreModel.setActiveTripleStore(tripleStore);
            NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
            SWRLSystemFrames sWRLSystemFrames = oWLModel.getSystemFrames();
            RDFProperty rDFProperty = sWRLSystemFrames.getOwlOntologyPointerProperty();
            RDFIndividual rDFIndividual = DatabaseFactoryUtils.getOwlOntologyPointerInstance(oWLModel, narrowFrameStore);
            if (rDFIndividual == null) {
                rDFIndividual = (RDFIndividual)sWRLSystemFrames.getOwlOntologyPointerClass().createInstance(null);
            }
            rDFIndividual.setPropertyValue(rDFProperty, tripleStore.getOWLOntology());
        }
        finally {
            tripleStoreModel.setActiveTripleStore(tripleStore2);
        }
    }

    private static RDFIndividual getOwlOntologyPointerInstance(OWLModel oWLModel, NarrowFrameStore narrowFrameStore) {
        SWRLSystemFrames sWRLSystemFrames = oWLModel.getSystemFrames();
        RDFSNamedClass rDFSNamedClass = sWRLSystemFrames.getOwlOntologyPointerClass();
        Iterator iterator = narrowFrameStore.getValues((Frame)rDFSNamedClass, sWRLSystemFrames.getDirectInstancesSlot(), null, false).iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            return (RDFIndividual)e;
        }
        return null;
    }

    private static OWLOntology getOwlOntology(NarrowFrameStore narrowFrameStore, RDFIndividual rDFIndividual, RDFProperty rDFProperty) {
        List list = narrowFrameStore.getValues((Frame)rDFIndividual, (Slot)rDFProperty, null, false);
        if (list.size() > 1) {
            log.severe("Found more than one ontology name in database! Please check that the database table is not corrupted. Values: " + list);
        }
        return list != null && list.size() > 0 ? list.iterator().next() : null;
    }

    public static void loadImports(OWLModel oWLModel, Collection collection) {
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
        OWLOntology oWLOntology = tripleStore.getOWLOntology();
        for (String string : oWLOntology.getImports()) {
            try {
                ((AbstractOWLModel)oWLModel).loadImportedAssertions(URIUtilities.createURI((String)string));
            }
            catch (AmalgamatedLoadException amalgamatedLoadException) {
                collection.addAll(amalgamatedLoadException.getErrorList());
            }
            catch (OntologyLoadException ontologyLoadException) {
                collection.add(ontologyLoadException);
            }
        }
    }

    public static String getOntologyFromTable(Class<? extends DatabaseFrameDb> clazz, String string, String string2, String string3, String string4, String string5) throws SQLException {
        Object object;
        DatabaseFrameDb databaseFrameDb = null;
        try {
            OWLJavaFactory oWLJavaFactory = new OWLJavaFactory(null);
            databaseFrameDb = DatabaseFrameDbFactory.createDatabaseFrameDb(clazz);
            databaseFrameDb.initialize((FrameFactory)oWLJavaFactory, string, string2, string3, string4, string5, false);
            object = new DefaultRDFSNamedClass(null, new FrameID(OWLNames.Cls.OWL_ONTOLOGY_POINTER_CLASS));
            DefaultSlot defaultSlot = new DefaultSlot(null, Model.SlotID.DIRECT_INSTANCES);
            DefaultRDFProperty defaultRDFProperty = new DefaultRDFProperty(null, new FrameID(OWLNames.Slot.OWL_ONTOLOGY_POINTER_PROPERTY));
            List list = databaseFrameDb.getValues((Frame)object, (Slot)defaultSlot, null, false);
            for (Object e : list) {
                if (!(e instanceof Frame)) continue;
                Frame frame = (Frame)e;
                List list2 = databaseFrameDb.getValues(frame, (Slot)defaultRDFProperty, null, false);
                for (Object e2 : list2) {
                    if (!(e2 instanceof OWLOntology)) continue;
                    String string6 = ((OWLOntology)e2).getName();
                    return string6;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException.getCause();
            if (object != null && object instanceof SQLException) {
                throw (SQLException)object;
            }
            throw runtimeException;
        }
        finally {
            if (databaseFrameDb != null) {
                databaseFrameDb.close();
            }
        }
        return null;
    }
}

