/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.database.OWLDatabasePlugin;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseWizardPage;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseWizardPageExistingSources;
import edu.stanford.smi.protegex.owl.database.creator.OwlDatabaseCreator;
import java.util.ArrayList;
import java.util.logging.Logger;

public class CreateOWLDatabaseProjectPlugin
extends AbstractCreateProjectPlugin
implements OWLDatabasePlugin {
    private static transient Logger log = Log.getLogger(CreateOWLDatabaseProjectPlugin.class);
    private String driver;
    private String table;
    private String username;
    private String password;
    private String url;
    private String ontologyName;

    public CreateOWLDatabaseProjectPlugin() {
        this("OWL Database");
    }

    public CreateOWLDatabaseProjectPlugin(String string) {
        super(string);
    }

    protected Project createNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        return this.makeProject(knowledgeBaseFactory, true);
    }

    protected Project buildNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        return this.makeProject(knowledgeBaseFactory, false);
    }

    private Project makeProject(KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        OwlDatabaseCreator owlDatabaseCreator = new OwlDatabaseCreator((OWLDatabaseKnowledgeBaseFactory)knowledgeBaseFactory, bl);
        owlDatabaseCreator.setDriver(this.driver);
        owlDatabaseCreator.setURL(this.url);
        owlDatabaseCreator.setTable(this.table);
        owlDatabaseCreator.setUsername(this.username);
        owlDatabaseCreator.setPassword(this.password);
        owlDatabaseCreator.setOntologyName(this.ontologyName);
        ArrayList<OntologyLoadException> arrayList = new ArrayList<OntologyLoadException>();
        try {
            owlDatabaseCreator.create(arrayList);
        }
        catch (OntologyLoadException ontologyLoadException) {
            arrayList.add(ontologyLoadException);
        }
        this.handleErrors(arrayList);
        return owlDatabaseCreator.getProject();
    }

    public boolean canCreateProject(KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        return knowledgeBaseFactory.getClass() == OWLDatabaseKnowledgeBaseFactory.class;
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard createProjectWizard, boolean bl) {
        return bl ? new OWLDatabaseWizardPageExistingSources((Wizard)createProjectWizard, this) : new OWLDatabaseWizardPage((Wizard)createProjectWizard, this);
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setTable(String string) {
        this.table = string;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setOntologyName(String string) {
        this.ontologyName = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getTable() {
        return this.table;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOntologyName() {
        return this.ontologyName;
    }
}

