/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.database.CreateOWLDatabaseProjectPlugin;
import edu.stanford.smi.protegex.owl.database.InitOWLDatabaseFromFileWizardPage;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.database.creator.OwlDatabaseFromFileCreator;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import java.net.URI;
import java.util.ArrayList;

public class CreateOWLDatabaseFromFileProjectPlugin
extends CreateOWLDatabaseProjectPlugin {
    private static String MERGE_MODE_PROP = "protege.owl.parser.convert.db.merge.mode";
    protected URI ontologyInputSource;
    private boolean isMergeImportMode = ApplicationProperties.getBooleanProperty((String)MERGE_MODE_PROP, (boolean)false);

    public CreateOWLDatabaseFromFileProjectPlugin() {
        super("OWL File (.owl or .rdf)");
    }

    protected Project buildNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        JenaKnowledgeBaseFactory.useStandalone = false;
        ArrayList<OntologyLoadException> arrayList = new ArrayList<OntologyLoadException>();
        OwlDatabaseFromFileCreator owlDatabaseFromFileCreator = new OwlDatabaseFromFileCreator((OWLDatabaseKnowledgeBaseFactory)knowledgeBaseFactory);
        owlDatabaseFromFileCreator.setDriver(this.getDriver());
        owlDatabaseFromFileCreator.setURL(this.getUrl());
        owlDatabaseFromFileCreator.setTable(this.getTable());
        owlDatabaseFromFileCreator.setUsername(this.getUsername());
        owlDatabaseFromFileCreator.setPassword(this.getPassword());
        owlDatabaseFromFileCreator.setOntologySource(this.getOntologyInputSource().toString());
        owlDatabaseFromFileCreator.setMergeImportMode(this.isMergeImportMode);
        try {
            owlDatabaseFromFileCreator.create(arrayList);
        }
        catch (OntologyLoadException ontologyLoadException) {
            arrayList.add(ontologyLoadException);
        }
        this.handleErrors(arrayList);
        return owlDatabaseFromFileCreator.getProject();
    }

    public boolean canCreateProject(KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        return super.canCreateProject(knowledgeBaseFactory, bl) && bl;
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard createProjectWizard, boolean bl) {
        return new InitOWLDatabaseFromFileWizardPage((Wizard)createProjectWizard, this);
    }

    public void setOntologyInputSource(URI uRI) {
        this.ontologyInputSource = uRI;
    }

    @Deprecated
    public void setOntologyFileURI(String string) {
        URI uRI = URIUtilities.createURI((String)string);
        if (uRI == null) {
            throw new RuntimeException("Invalid uri " + string);
        }
        this.setOntologyInputSource(uRI);
    }

    public URI getOntologyInputSource() {
        return this.ontologyInputSource;
    }

    public boolean isMergeImportMode() {
        return this.isMergeImportMode;
    }

    public void setMergeImportMode(boolean bl) {
        this.isMergeImportMode = bl;
    }
}

