/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.creator.NewOwlProjectCreator;
import edu.stanford.smi.protegex.owl.jena.creator.OwlProjectFromReaderCreator;
import edu.stanford.smi.protegex.owl.jena.creator.OwlProjectFromStreamCreator;
import edu.stanford.smi.protegex.owl.jena.creator.OwlProjectFromUriCreator;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public class ProtegeOWL {
    public static String PLUGIN_FOLDER = "edu.stanford.smi.protegex.owl";
    private static File customPluginFolder = null;

    public static JenaOWLModel createJenaOWLModel() throws OntologyLoadException {
        ArrayList arrayList = new ArrayList();
        NewOwlProjectCreator newOwlProjectCreator = new NewOwlProjectCreator();
        newOwlProjectCreator.setOntologyName(FactoryUtils.generateOntologyURIBase());
        newOwlProjectCreator.create(arrayList);
        ProtegeOWL.handleErrors(arrayList);
        return newOwlProjectCreator.getOwlModel();
    }

    public static JenaOWLModel createJenaOWLModelFromInputStream(InputStream inputStream) throws OntologyLoadException {
        ArrayList arrayList = new ArrayList();
        OwlProjectFromStreamCreator owlProjectFromStreamCreator = new OwlProjectFromStreamCreator();
        owlProjectFromStreamCreator.setStream(inputStream);
        owlProjectFromStreamCreator.create(arrayList);
        JenaOWLModel jenaOWLModel = owlProjectFromStreamCreator.getOwlModel();
        ProtegeOWL.handleErrors(arrayList);
        return jenaOWLModel;
    }

    public static JenaOWLModel createJenaOWLModelFromReader(Reader reader) throws OntologyLoadException {
        ArrayList arrayList = new ArrayList();
        OwlProjectFromReaderCreator owlProjectFromReaderCreator = new OwlProjectFromReaderCreator();
        owlProjectFromReaderCreator.setReader(reader);
        owlProjectFromReaderCreator.create(arrayList);
        JenaOWLModel jenaOWLModel = owlProjectFromReaderCreator.getOwlModel();
        ProtegeOWL.handleErrors(arrayList);
        return jenaOWLModel;
    }

    public static JenaOWLModel createJenaOWLModelFromURI(String string) throws OntologyLoadException {
        ArrayList arrayList = new ArrayList();
        OwlProjectFromUriCreator owlProjectFromUriCreator = new OwlProjectFromUriCreator();
        owlProjectFromUriCreator.setOntologyUri(string);
        owlProjectFromUriCreator.create(arrayList);
        JenaOWLModel jenaOWLModel = owlProjectFromUriCreator.getOwlModel();
        ProtegeOWL.handleErrors(arrayList);
        return jenaOWLModel;
    }

    public static File getPluginFolder() {
        if (customPluginFolder == null) {
            return new File(new File(ApplicationProperties.getApplicationDirectory(), "plugins"), PLUGIN_FOLDER);
        }
        return customPluginFolder;
    }

    public static void setPluginFolder(File file) {
        customPluginFolder = file;
    }

    public static void initProject(Project project, String string, String string2) {
        JenaKnowledgeBaseFactory.setOWLFileLanguage(project.getSources(), string2);
        JenaKnowledgeBaseFactory.setOWLFileName(project.getSources(), string);
    }

    private static void handleErrors(Collection collection) throws OntologyLoadException {
        for (Object e : collection) {
            Throwable throwable;
            if (e instanceof Throwable) {
                throwable = (Throwable)e;
                Log.getLogger().log(Level.WARNING, "Exception caught ", (Throwable)e);
                throw throwable instanceof OntologyLoadException ? (OntologyLoadException)throwable : new OntologyLoadException(throwable, throwable.getMessage());
            }
            if (e instanceof MessageError) {
                throwable = (MessageError)e;
                if (throwable.getSeverity() == MessageError.Severity.FATAL && throwable.getException() != null) {
                    Throwable throwable2 = throwable.getException();
                    throw throwable2 instanceof OntologyLoadException ? (OntologyLoadException)throwable2 : new OntologyLoadException(throwable2, throwable2.getMessage());
                }
                Log.getLogger().warning("Error found " + e);
                continue;
            }
            Log.getLogger().warning("Error found " + e);
        }
    }

    public static void main(String[] stringArray) {
        Application.main((String[])stringArray);
    }
}

