/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.xml;

import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterNamespaceManager;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterPreferences;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class DefaultXMLWriter
implements XMLWriter {
    private Stack elementStack;
    private Writer writer;
    private String encoding;
    private String xmlBase;
    private XMLWriterNamespaceManager xmlWriterNamespaceManager;
    private Map entities;
    private static final int TEXT_CONTENT_WRAP_LIMIT = 15;

    public DefaultXMLWriter(Writer writer, XMLWriterNamespaceManager xMLWriterNamespaceManager) {
        this(writer, xMLWriterNamespaceManager, "");
    }

    public DefaultXMLWriter(Writer writer, XMLWriterNamespaceManager xMLWriterNamespaceManager, String string) {
        this.writer = writer;
        this.xmlWriterNamespaceManager = xMLWriterNamespaceManager;
        this.xmlBase = string;
        this.encoding = "";
        this.elementStack = new Stack();
        this.setupEntities();
    }

    private void setupEntities() {
        ArrayList arrayList = new ArrayList(this.xmlWriterNamespaceManager.getNamespaces());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).length() - ((String)object2).length();
            }
        });
        this.entities = new LinkedHashMap();
        for (String string : arrayList) {
            String string2 = this.xmlWriterNamespaceManager.getPrefixForNamespace(string);
            this.entities.put(string, "&" + string2 + ";");
        }
    }

    private String swapForEntity(String string) {
        for (String string2 : this.entities.keySet()) {
            String string3;
            String string4 = (String)this.entities.get(string2);
            if (string.length() <= string2.length() || (string3 = StringUtils.replaceOnce((String)string, (String)string2, (String)string4)).length() >= string.length()) continue;
            return string3;
        }
        return string;
    }

    public String getDefaultNamespace() {
        return this.xmlWriterNamespaceManager.getDefaultNamespace();
    }

    public String getXMLBase() {
        return this.xmlBase;
    }

    public XMLWriterNamespaceManager getNamespacePrefixes() {
        return this.xmlWriterNamespaceManager;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setWrapAttributes(boolean bl) {
        if (this.elementStack.size() > 0) {
            XMLElement xMLElement = (XMLElement)this.elementStack.peek();
            xMLElement.setWrapAttributes(bl);
        }
    }

    public void writeStartElement(String string) throws IOException {
        XMLElement xMLElement;
        XMLElement xMLElement2 = new XMLElement(string, this.elementStack.size());
        if (this.elementStack.size() > 0 && (xMLElement = (XMLElement)this.elementStack.peek()) != null) {
            xMLElement.writeElementStart(false);
        }
        this.elementStack.push(xMLElement2);
    }

    public void writeEndElement() throws IOException {
        if (this.elementStack.size() > 0) {
            XMLElement xMLElement = (XMLElement)this.elementStack.pop();
            xMLElement.writeElementEnd();
        }
    }

    public void writeAttribute(String string, String string2) {
        XMLElement xMLElement = (XMLElement)this.elementStack.peek();
        xMLElement.setAttribute(string, string2);
    }

    public void writeTextContent(String string) {
        XMLElement xMLElement = (XMLElement)this.elementStack.peek();
        xMLElement.setText(string);
    }

    private void writeEntities(String string) throws IOException {
        this.writer.write("\n\n<!DOCTYPE " + string + " [\n");
        for (String string2 : this.entities.keySet()) {
            String string3 = (String)this.entities.get(string2);
            string3 = string3.substring(1, string3.length() - 1);
            this.writer.write("    <!ENTITY ");
            this.writer.write(string3);
            this.writer.write(" \"");
            this.writer.write(string2);
            this.writer.write("\" >\n");
        }
        this.writer.write("]>\n\n\n");
    }

    public void startDocument(String string) throws IOException {
        String string2 = "";
        if (this.encoding.length() > 0) {
            string2 = " encoding=\"" + this.encoding + "\"";
        }
        this.writer.write("<?xml version=\"1.0\"" + string2 + "?>\n");
        if (XMLWriterPreferences.getInstance().isUseNamespaceEntities()) {
            this.writeEntities(string);
        }
        this.writeStartElement(string);
        this.setWrapAttributes(true);
        this.writeAttribute("xmlns", this.xmlWriterNamespaceManager.getDefaultNamespace());
        if (!this.xmlBase.equals("")) {
            this.writeAttribute("xml:base", this.xmlBase);
        }
        for (String string3 : this.xmlWriterNamespaceManager.getPrefixes()) {
            this.writeAttribute("xmlns:" + string3, this.xmlWriterNamespaceManager.getNamespaceForPrefix(string3));
        }
    }

    public void endDocument() throws IOException {
        while (this.elementStack.size() > 0) {
            this.writeEndElement();
        }
    }

    public class XMLElement {
        private String name;
        private Map attributes;
        String textContent;
        private boolean startWritten;
        private int indentation;
        private boolean wrapAttributes;

        public XMLElement(String string) {
            this(string, 0);
            this.wrapAttributes = false;
        }

        public XMLElement(String string, int n) {
            this.name = string;
            this.attributes = new LinkedHashMap();
            this.indentation = n;
            this.textContent = null;
            this.startWritten = false;
        }

        public void setWrapAttributes(boolean bl) {
            this.wrapAttributes = true;
        }

        public void setAttribute(String string, String string2) {
            this.attributes.put(string, string2);
        }

        public void setText(String string) {
            this.textContent = string;
        }

        public void writeElementStart(boolean bl) throws IOException {
            if (!this.startWritten) {
                this.startWritten = true;
                this.insertIndentation();
                DefaultXMLWriter.this.writer.write(60);
                DefaultXMLWriter.this.writer.write(this.name);
                this.writeAttributes();
                if (this.textContent != null) {
                    boolean bl2;
                    boolean bl3 = bl2 = this.textContent.length() > 15;
                    if (bl2) {
                        this.writeNewLine();
                        ++this.indentation;
                        this.insertIndentation();
                    }
                    DefaultXMLWriter.this.writer.write(62);
                    this.writeTextContent();
                    if (bl2) {
                        --this.indentation;
                    }
                }
                if (bl) {
                    if (this.textContent != null) {
                        this.writeElementEnd();
                    } else {
                        DefaultXMLWriter.this.writer.write("/>");
                        this.writeNewLine();
                    }
                } else if (this.textContent == null) {
                    DefaultXMLWriter.this.writer.write(62);
                    this.writeNewLine();
                }
            }
        }

        public void writeElementEnd() throws IOException {
            if (!this.startWritten) {
                this.writeElementStart(true);
            } else {
                if (this.textContent == null) {
                    this.insertIndentation();
                }
                DefaultXMLWriter.this.writer.write("</");
                DefaultXMLWriter.this.writer.write(this.name);
                DefaultXMLWriter.this.writer.write(">");
                this.writeNewLine();
            }
        }

        private void writeAttribute(String string, String string2) throws IOException {
            DefaultXMLWriter.this.writer.write(string);
            DefaultXMLWriter.this.writer.write(61);
            DefaultXMLWriter.this.writer.write(34);
            if (XMLWriterPreferences.getInstance().isUseNamespaceEntities()) {
                DefaultXMLWriter.this.writer.write(DefaultXMLWriter.this.swapForEntity(StringEscapeUtils.escapeXml((String)string2)));
            } else {
                DefaultXMLWriter.this.writer.write(StringEscapeUtils.escapeXml((String)string2));
            }
            DefaultXMLWriter.this.writer.write(34);
        }

        private void writeAttributes() throws IOException {
            Iterator iterator = this.attributes.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this.attributes.get(string);
                DefaultXMLWriter.this.writer.write(32);
                this.writeAttribute(string, string2);
                if (!iterator.hasNext() || !this.wrapAttributes) continue;
                DefaultXMLWriter.this.writer.write("\n");
                ++this.indentation;
                this.insertIndentation();
                --this.indentation;
            }
        }

        private void writeTextContent() throws IOException {
            if (this.textContent != null) {
                DefaultXMLWriter.this.writer.write(StringEscapeUtils.escapeXml((String)this.textContent));
            }
        }

        private void insertIndentation() throws IOException {
            if (XMLWriterPreferences.getInstance().isIndenting()) {
                for (int i = 0; i < this.indentation * XMLWriterPreferences.getInstance().getIndentSize(); ++i) {
                    DefaultXMLWriter.this.writer.write(32);
                }
            }
        }

        private void writeNewLine() throws IOException {
            DefaultXMLWriter.this.writer.write(10);
        }
    }
}

