/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.BooleanListWidget;
import edu.stanford.smi.protege.widget.CheckBoxWidget;
import edu.stanford.smi.protege.widget.DefaultWidgetMapper;
import edu.stanford.smi.protege.widget.DirectInstancesWidget;
import edu.stanford.smi.protege.widget.FloatFieldWidget;
import edu.stanford.smi.protege.widget.FloatListWidget;
import edu.stanford.smi.protege.widget.InstanceFieldWidget;
import edu.stanford.smi.protege.widget.InstanceListWidget;
import edu.stanford.smi.protege.widget.IntegerFieldWidget;
import edu.stanford.smi.protege.widget.IntegerListWidget;
import edu.stanford.smi.protege.widget.StringListWidget;
import edu.stanford.smi.protege.widget.TextAreaWidget;
import edu.stanford.smi.protege.widget.TextFieldWidget;
import edu.stanford.smi.protege.widget.UniqueStringWidget;
import edu.stanford.smi.protege.widget.YellowStickyWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.widget.DataRangeFieldWidget;
import edu.stanford.smi.protegex.owl.ui.widget.MultiLiteralWidget;
import edu.stanford.smi.protegex.owl.ui.widget.MultiResourceWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLDateTimeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLDateWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLTimeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMetadata;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetUtil;
import edu.stanford.smi.protegex.owl.ui.widget.RDFListWidget;
import edu.stanford.smi.protegex.owl.ui.widget.ResourceListWidget;
import edu.stanford.smi.protegex.owl.ui.widget.SingleLiteralWidget;
import edu.stanford.smi.protegex.owl.ui.widget.SingleResourceWidget;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class OWLWidgetMapper
extends DefaultWidgetMapper {
    private static Logger log = Log.getLogger(OWLWidgetMapper.class);
    private static Map className2Metadata;
    private static final String[] incompatibleWidgetClassNames;

    public OWLWidgetMapper(OWLModel oWLModel) {
        super(oWLModel.getProject().getInternalProjectKnowledgeBase());
    }

    public String getDefaultWidgetClassName(Cls cls, Slot slot, Facet facet) {
        return this.getDefaultWidgetClassName(cls, slot, facet, false);
    }

    public String getDefaultWidgetClassName(Cls cls, Slot slot, Facet facet, boolean bl) {
        if (slot instanceof RDFProperty && cls instanceof RDFSNamedClass) {
            Object object3;
            Iterator<Object> iterator;
            Object object2;
            if (!cls.hasTemplateSlot(slot)) {
                return null;
            }
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)cls;
            RDFProperty rDFProperty = (RDFProperty)slot;
            if (rDFProperty.isAnnotationProperty()) {
                return null;
            }
            if (!(rDFProperty.isDomainDefined(true) || OWLWidgetUtil.isRestrictedProperty(rDFSNamedClass, rDFProperty) || bl)) {
                return null;
            }
            String string = PluginUtilities.getDefaultWidgetClassName((Slot)rDFProperty);
            if (string != null) {
                return string;
            }
            if (rDFSNamedClass instanceof OWLNamedClass) {
                OWLNamedClass oWLNamedClass = (OWLNamedClass)rDFSNamedClass;
                object2 = new ArrayList<RDFProperty>();
                object2.add(rDFProperty);
                object2.addAll(rDFProperty.getSuperproperties(true));
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object3 = (RDFProperty)iterator.next();
                    if (oWLNamedClass.getMaxCardinality((RDFProperty)object3) != 0) continue;
                    return null;
                }
            }
            OWLWidgetMapper.initWidgetMetadata();
            int n = 0;
            object2 = null;
            for (Object object3 : className2Metadata.keySet()) {
                int n2;
                OWLWidgetMetadata oWLWidgetMetadata = (OWLWidgetMetadata)className2Metadata.get(object3);
                if (oWLWidgetMetadata == null || (n2 = oWLWidgetMetadata.getSuitability(rDFSNamedClass, rDFProperty)) <= n) continue;
                object2 = object3;
                n = n2;
            }
            if (object2 != null && n > 1) {
                return object2;
            }
            iterator = new Class[]{DataRangeFieldWidget.class, OWLDateWidget.class, OWLTimeWidget.class, OWLDateTimeWidget.class, RDFListWidget.class, MultiResourceWidget.class, SingleResourceWidget.class, BooleanListWidget.class, MultiLiteralWidget.class, SingleLiteralWidget.class};
            object3 = new Object[]{cls, slot, facet};
            for (int i = 0; i < ((Iterator<Object>)iterator).length; ++i) {
                Iterator<Object> iterator2 = iterator[i];
                if (OWLWidgetMapper.isSuitable(iterator2, cls, slot)) {
                    return ((Class)((Object)iterator2)).getName();
                }
                try {
                    Method method = ((Class)((Object)iterator2)).getMethod("isSuitable", Cls.class, Slot.class, Facet.class);
                    if (Boolean.TRUE.equals(method.invoke(null, object3))) {
                        return ((Class)((Object)iterator2)).getName();
                    }
                    continue;
                }
                catch (Exception exception) {
                    Log.emptyCatchBlock((Throwable)exception);
                }
            }
        }
        return super.getDefaultWidgetClassName(cls, slot, facet);
    }

    public static OWLWidgetMetadata getOWLWidgetMetadata(String string) {
        OWLWidgetMapper.initWidgetMetadata();
        return (OWLWidgetMetadata)className2Metadata.get(string);
    }

    public Collection getSuitableWidgetClassNames(Cls cls, Slot slot, Facet facet) {
        ArrayList arrayList = new ArrayList(super.getSuitableWidgetClassNames(cls, slot, facet));
        for (int i = 0; i < incompatibleWidgetClassNames.length; ++i) {
            String string = incompatibleWidgetClassNames[i];
            arrayList.remove(string);
        }
        return arrayList;
    }

    private static void initWidgetMetadata() {
        if (className2Metadata == null) {
            className2Metadata = new HashMap();
            Collection collection = PluginUtilities.getAvailableSlotWidgetClassNames();
            for (String string : collection) {
                String string2 = string + "Metadata";
                try {
                    Class clazz = PluginUtilities.forName((String)string2, (boolean)true);
                    if (clazz == null) continue;
                    Object t = clazz.newInstance();
                    className2Metadata.put(string, t);
                }
                catch (Exception exception) {
                    Log.emptyCatchBlock((Throwable)exception);
                }
            }
        }
    }

    public static boolean isIncompatibleWidgetName(String string) {
        for (int i = 0; i < incompatibleWidgetClassNames.length; ++i) {
            String string2 = incompatibleWidgetClassNames[i];
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSuitable(Class clazz, Cls cls, Slot slot) {
        if (slot instanceof RDFProperty && cls instanceof RDFSNamedClass) {
            RDFProperty rDFProperty = (RDFProperty)slot;
            String string = clazz.getName();
            OWLWidgetMetadata oWLWidgetMetadata = OWLWidgetMapper.getOWLWidgetMetadata(string);
            if (oWLWidgetMetadata != null) {
                RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)cls;
                return oWLWidgetMetadata.getSuitability(rDFSNamedClass, rDFProperty) > 0;
            }
        }
        return false;
    }

    static {
        incompatibleWidgetClassNames = new String[]{CheckBoxWidget.class.getName(), DirectInstancesWidget.class.getName(), FloatFieldWidget.class.getName(), FloatListWidget.class.getName(), InstanceFieldWidget.class.getName(), InstanceListWidget.class.getName(), IntegerFieldWidget.class.getName(), IntegerListWidget.class.getName(), ResourceListWidget.class.getName(), StringListWidget.class.getName(), TextAreaWidget.class.getName(), TextFieldWidget.class.getName(), UniqueStringWidget.class.getName(), YellowStickyWidget.class.getName(), "edu.stanford.smi.protegex.widget.contains.ContainsWidget", "edu.stanford.smi.protegex.widget.instancetable.InstanceRowWidget"};
    }
}

