/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public abstract class MultiWidgetPropertyWidget
extends AbstractPropertyWidget {
    private boolean allMode = false;
    private JPanel allPanel = new JPanel(new GridLayout(2, 1));
    protected FrameListener valueListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            Slot slot = frameEvent.getSlot();
            for (AbstractSlotWidget abstractSlotWidget : MultiWidgetPropertyWidget.this.widgets) {
                if (!slot.equals(abstractSlotWidget.getSlot())) continue;
                abstractSlotWidget.loadValues();
            }
        }
    };
    protected Instance instance;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private List widgets = new ArrayList();
    private Hashtable widgetContainers = new Hashtable();

    public MultiWidgetPropertyWidget() {
        this.createNestedWidgets();
    }

    public void addNestedWidget(SlotWidget slotWidget, String string, String string2, String string3) {
        this.widgets.add(slotWidget);
        WidgetHolder widgetHolder = new WidgetHolder();
        this.tabbedPane.add(string2, (Component)slotWidget);
        widgetHolder.tabName = string2;
        widgetHolder.widgetName = string3;
        widgetHolder.slotName = string;
        this.widgetContainers.put(slotWidget, widgetHolder);
    }

    protected abstract void createNestedWidgets();

    protected WidgetDescriptor createWidgetDescriptor(SlotWidget slotWidget, Cls cls, Slot slot) {
        WidgetHolder widgetHolder = (WidgetHolder)this.widgetContainers.get(slotWidget);
        WidgetDescriptor widgetDescriptor = this.getPropertyList().createWidgetDescriptor(slot.getName());
        if (widgetHolder != null && widgetHolder.widgetName != null) {
            widgetDescriptor.setLabel(widgetHolder.widgetName);
        }
        return widgetDescriptor;
    }

    public void dispose() {
        super.dispose();
        for (SlotWidget slotWidget : this.widgets) {
            slotWidget.dispose();
        }
        this.widgetContainers = null;
        if (this.instance != null) {
            this.instance.removeFrameListener(this.valueListener);
        }
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        return new MultiWidgetConfigurationPanel(this);
    }

    public RDFResource getEditedResource() {
        return (RDFResource)this.instance;
    }

    protected JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private WidgetHolder getWidgetHolder(SlotWidget slotWidget) {
        return (WidgetHolder)this.widgetContainers.get(slotWidget);
    }

    protected void initAllPanel(JPanel jPanel, List list) {
        jPanel.setLayout(new GridLayout(list.size(), 1));
        for (int i = list.size() - 1; i >= 0; --i) {
            Component component = (Component)list.get(i);
            jPanel.add(component);
        }
    }

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.tabbedPane);
        for (SlotWidget slotWidget : this.widgets) {
            slotWidget.initialize();
        }
    }

    public Iterator listWidgets() {
        return this.widgets.iterator();
    }

    public void setAllMode(boolean bl) {
        if (bl != this.allMode) {
            this.allMode = bl;
            if (bl) {
                this.reinitAllPanel();
                this.add("Center", this.allPanel);
            } else {
                for (SlotWidget slotWidget : this.widgets) {
                    WidgetHolder widgetHolder = (WidgetHolder)this.widgetContainers.get(slotWidget);
                    this.tabbedPane.addTab(widgetHolder.tabName, (Component)slotWidget);
                }
                this.add("Center", this.tabbedPane);
            }
        }
    }

    public void reinitAllPanel() {
        this.allPanel.removeAll();
        this.initAllPanel(this.allPanel, this.widgets);
    }

    public void setAssociatedCls(Cls cls) {
        super.setAssociatedCls(cls);
        for (SlotWidget slotWidget : this.widgets) {
            if (!(slotWidget instanceof AbstractSlotWidget)) continue;
            slotWidget.setAssociatedCls(cls);
        }
    }

    public void setBorder(Border border) {
        if (border instanceof EmptyBorder) {
            super.setBorder(null);
        } else {
            super.setBorder(border);
        }
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        for (SlotWidget slotWidget : this.widgets) {
            if (!(slotWidget instanceof AbstractSlotWidget)) continue;
            ((AbstractSlotWidget)slotWidget).setEditable(bl);
        }
    }

    public void setInstance(Instance instance) {
        if (this.instance != null) {
            this.instance.removeFrameListener(this.valueListener);
        }
        for (SlotWidget slotWidget : this.widgets) {
            slotWidget.setInstance(instance);
        }
        this.instance = instance;
        if (this.instance != null) {
            this.instance.addFrameListener(this.valueListener);
        }
    }

    protected void setSelectedTab(Component component) {
        this.tabbedPane.setSelectedComponent(component);
    }

    public void setup(WidgetDescriptor widgetDescriptor, boolean bl, Project project, Cls cls, Slot slot) {
        super.setup(widgetDescriptor, bl, project, cls, slot);
        this.setupSubWidgets(slot, cls, bl, project);
    }

    protected void setupSubWidgets(Slot slot, Cls cls, boolean bl, Project project) {
        for (SlotWidget slotWidget : this.widgets) {
            WidgetHolder widgetHolder = (WidgetHolder)this.widgetContainers.get(slotWidget);
            String string = widgetHolder.slotName;
            Slot slot2 = string == null ? slot : this.getKnowledgeBase().getSlot(string);
            WidgetDescriptor widgetDescriptor = this.getPropertyList().getWidgetDescriptor(string);
            if (widgetDescriptor == null) {
                widgetDescriptor = this.createWidgetDescriptor(slotWidget, cls, slot2);
            }
            slotWidget.setup(widgetDescriptor, bl, project, cls, slot2);
        }
    }

    public Instance getMultiWidgetInstance() {
        return this.instance;
    }

    private class MultiWidgetConfigurationPanel
    extends WidgetConfigurationPanel {
        private List panels;

        MultiWidgetConfigurationPanel(MultiWidgetPropertyWidget multiWidgetPropertyWidget2) {
            super((SlotWidget)multiWidgetPropertyWidget2);
            this.panels = new ArrayList();
            this.getTabbedPane().removeAll();
            for (SlotWidget slotWidget : MultiWidgetPropertyWidget.this.widgets) {
                WidgetConfigurationPanel widgetConfigurationPanel;
                if (!(slotWidget instanceof AbstractSlotWidget) || (widgetConfigurationPanel = ((AbstractSlotWidget)slotWidget).createWidgetConfigurationPanel()) == null) continue;
                this.panels.add(widgetConfigurationPanel);
                WidgetHolder widgetHolder = MultiWidgetPropertyWidget.this.getWidgetHolder(slotWidget);
                this.getTabbedPane().addTab(widgetHolder.tabName, (Component)widgetConfigurationPanel);
            }
        }
    }

    private class WidgetHolder {
        String slotName;
        String tabName;
        String widgetName;

        private WidgetHolder() {
        }
    }
}

