/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import com.hexidec.ekit.EkitCore;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.ComponentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HTMLEditorPanel
extends JPanel {
    private EkitCore ekitCore;
    private JComboBox languageComboBox;

    public HTMLEditorPanel(OWLModel oWLModel, RDFSLiteral rDFSLiteral) {
        this(oWLModel, rDFSLiteral.getString(), rDFSLiteral.getLanguage());
    }

    public HTMLEditorPanel(String string) {
        this(null, string, null);
    }

    public HTMLEditorPanel(OWLModel oWLModel, String string, String string2) {
        this.setLayout(new BorderLayout());
        this.ekitCore = new EkitCore(null, null, null, null, false, true, true, null, null, false, false);
        this.ekitCore.setDocumentText(string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(this.ekitCore.getMenuBar());
        jPanel.add(this.ekitCore.getToolBar(true));
        if (oWLModel != null) {
            this.languageComboBox = ComponentUtil.createLanguageComboBox(oWLModel, string2);
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Language: "));
            box.add(this.languageComboBox);
            this.add("South", box);
        }
        this.add("North", jPanel);
        this.add("Center", (Component)this.ekitCore);
    }

    public String getFullText() {
        return this.ekitCore.getDocumentText().trim();
    }

    public RDFSLiteral getRDFSLiteral(OWLModel oWLModel) {
        String string = this.getText();
        if (string != null) {
            String string2 = null;
            Object object = this.languageComboBox.getSelectedItem();
            if (object instanceof String && ((String)object).trim().length() > 0) {
                string2 = ((String)object).trim();
            }
            return oWLModel.createRDFSLiteral(string, string2);
        }
        return null;
    }

    public String getText() {
        return this.ekitCore.getDocumentBody().trim();
    }

    public static String show(Component component, String string, String string2) {
        return HTMLEditorPanel.show(component, string, string2, false);
    }

    public static String show(Component component, String string, String string2, boolean bl) {
        HTMLEditorPanel hTMLEditorPanel = new HTMLEditorPanel(string);
        if (ProtegeUI.getModalDialogFactory().showDialog(component, hTMLEditorPanel, string2, 11) == 1) {
            return bl ? hTMLEditorPanel.getFullText() : hTMLEditorPanel.getText();
        }
        return null;
    }

    public static RDFSLiteral show(Component component, RDFSLiteral rDFSLiteral, String string, OWLModel oWLModel) {
        HTMLEditorPanel hTMLEditorPanel = new HTMLEditorPanel(oWLModel, rDFSLiteral);
        if (ProtegeUI.getModalDialogFactory().showDialog(component, hTMLEditorPanel, string, 11) == 1) {
            return hTMLEditorPanel.getRDFSLiteral(oWLModel);
        }
        return null;
    }
}

