/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.triplestore;

import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.triplestore.CreateTripleStorePanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;

public class SplitClassesIntoImportedTripleStorePanel
extends CreateTripleStorePanel {
    private static final String HELP_TITLE = "How to split an ontology?";
    private static final String HELP_TEXT = "<P>It is a common design pattern to have a schema/ontology file (consisting of classes and properties) and one of more individuals files, which instantiate the ontology.  The instance file(s) will import the classes file.  This function will extract all classes and properties from your project into an imported ontology file.</P><P><strong>Ontology URI</strong>: Specifies the address of the new classes ontology.</P><P><strong>Local File</strong>: Specified the file to where the classes will be written into.</P><P><strong>Prefix</strong>: The prefix of the classes when used as import.</P>";

    public SplitClassesIntoImportedTripleStorePanel(OWLModel oWLModel) {
        super(oWLModel);
    }

    protected TripleStore performAction() {
        TripleStoreModel tripleStoreModel = this.getOWLModel().getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
        TripleStore tripleStore2 = super.performAction();
        TripleStoreUtil.switchTripleStore(this.getOWLModel(), tripleStore);
        if (tripleStore2 != null) {
            Object object;
            ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
            TripleStore tripleStore3 = tripleStoreModel.getActiveTripleStore();
            Iterator<RDFResource> iterator = tripleStore3.listHomeResources();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof RDFSClass) && !(object instanceof RDFProperty) && !(object instanceof OWLDataRange) && !(object instanceof RDFList)) continue;
                arrayList.add((RDFResource)object);
            }
            TripleStoreUtil.moveResources(arrayList, tripleStore3, tripleStore2);
            tripleStoreModel.setActiveTripleStore(tripleStore2);
            object = this.getPrefix();
            for (RDFResource rDFResource : arrayList) {
                if (rDFResource.isAnonymous() || rDFResource.getName().indexOf(58) >= 0) continue;
                String string = (String)object + ":" + rDFResource.getName();
                if (this.getOWLModel().getRDFResource(string) != null) continue;
                rDFResource.setName(string);
            }
            tripleStoreModel.setActiveTripleStore(tripleStore);
            tripleStoreModel.updateEditableResourceState();
            ProtegeUI.reloadUI(this.getOWLModel().getProject());
        }
        return tripleStore2;
    }

    public static void showDialog(OWLModel oWLModel) {
        SplitClassesIntoImportedTripleStorePanel splitClassesIntoImportedTripleStorePanel = new SplitClassesIntoImportedTripleStorePanel(oWLModel);
        JComponent jComponent = OWLUI.createHelpPanel(HELP_TEXT, HELP_TITLE);
        splitClassesIntoImportedTripleStorePanel.add("South", jComponent);
        jComponent.setPreferredSize(new Dimension(600, 150));
        if (ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(oWLModel.getProject()), splitClassesIntoImportedTripleStorePanel, "Move Classes into Imported Sub-Ontology", 11) == 1) {
            splitClassesIntoImportedTripleStorePanel.performAction();
        }
    }
}

