/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.triplestore;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.URIField;
import edu.stanford.smi.protege.util.Validatable;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.net.URI;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AddTripleStorePanel
extends JPanel
implements Validatable {
    private OWLModel owlModel;
    private JTextField prefixField;
    protected URIField uriField;

    protected AddTripleStorePanel(OWLModel oWLModel) {
        this(oWLModel, "Prefix");
    }

    protected AddTripleStorePanel(OWLModel oWLModel, String string) {
        this.owlModel = oWLModel;
        try {
            URI uRI = new URI("http://www.owl-ontologies.com/submodel.owl");
            this.uriField = new URIField("Ontology name (URI)", uRI, ".owl", "");
            this.prefixField = new JTextField("submodel");
            JPanel jPanel = new JPanel(new GridLayout(3, 1));
            jPanel.add((Component)this.uriField);
            jPanel.add((Component)new LabeledComponent(string, (Component)this.prefixField));
            this.setLayout(new BorderLayout(0, 16));
            this.add("Center", jPanel);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
    }

    protected String getNamespaceFromURI(URI uRI) {
        String string = uRI.toString();
        return Jena.getNamespaceFromURI(string);
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    protected String getPrefix() {
        return this.prefixField.getText();
    }

    protected URI getURI() {
        return this.uriField.getAbsoluteURI();
    }

    public void saveContents() {
    }

    protected void setPrefix(String string) {
        this.prefixField.setText(string);
    }

    public boolean validateContents() {
        URI uRI = this.getURI();
        if (uRI != null) {
            String string = uRI.toString();
            TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
            if (tripleStoreModel.getTripleStore(string) == null) {
                String string2 = this.getPrefix();
                if (string2 != null) {
                    String string3 = this.owlModel.getNamespaceManager().getNamespaceForPrefix(string2);
                    String string4 = this.getNamespaceFromURI(uRI);
                    if (string3 == null || string3.equals(string4)) {
                        return true;
                    }
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Prefix \"" + string2 + "\" is already used.");
                } else {
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Invalid Prefix.");
                }
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Model with this URI already exists:\n" + string);
            }
        } else {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Invalid URI.");
        }
        return false;
    }
}

