/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestLibrary;
import edu.stanford.smi.protegex.owl.testing.OWLTestManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class OWLTestSettingsTableModel
extends AbstractTableModel {
    public static final int COL_ACTIVATED = 0;
    public static final int COL_NAME = 1;
    public static final int COL_COUNT = 2;
    private List testClasses = new ArrayList();
    private OWLTestManager testManager;

    public OWLTestSettingsTableModel(OWLTestManager oWLTestManager) {
        this.testManager = oWLTestManager;
        Class[] classArray = OWLTestLibrary.getOWLTestClasses();
        Arrays.sort(classArray, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                String string;
                Class clazz = (Class)object;
                OWLTest oWLTest = OWLTestLibrary.getOWLTest(clazz);
                Class clazz2 = (Class)object2;
                OWLTest oWLTest2 = OWLTestLibrary.getOWLTest(clazz2);
                String string2 = oWLTest.getGroup();
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = oWLTest2.getGroup()) == null) {
                    string = "";
                }
                if ((n = string2.compareTo(string)) == 0) {
                    return oWLTest.getName().compareTo(oWLTest2.getName());
                }
                return n;
            }
        });
        String string = null;
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            OWLTest oWLTest = OWLTestLibrary.getOWLTest(clazz);
            String string2 = oWLTest.getGroup();
            if (string2 != null && !string2.equals(string)) {
                this.testClasses.add(string2);
                string = string2;
            }
            this.testClasses.add(clazz);
        }
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return Boolean.class;
        }
        if (n == 1) {
            return String.class;
        }
        return null;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Activated";
        }
        if (n == 1) {
            return "Test Class Name";
        }
        return null;
    }

    public OWLTest getOWLTest(Class clazz) {
        OWLTest[] oWLTestArray = this.testManager.getOWLTests();
        for (int i = 0; i < oWLTestArray.length; ++i) {
            OWLTest oWLTest = oWLTestArray[i];
            if (!oWLTest.getClass().equals(clazz)) continue;
            return oWLTest;
        }
        return null;
    }

    public Class getOWLTestClass(int n) {
        return (Class)this.testClasses.get(n);
    }

    public String getOWLTestClassName(int n) {
        OWLTest oWLTest = this.getOWLTest(this.getOWLTestClass(n));
        return oWLTest.getName();
    }

    public int getRowCount() {
        return this.testClasses.size();
    }

    public Object getValueAt(int n, int n2) {
        if (this.isSeparator(n)) {
            if (n2 == 0) {
                String string = (String)this.testClasses.get(n);
                return this.testManager.isOWLTestGroupEnabled(string);
            }
            if (n2 == 1) {
                return (String)this.testClasses.get(n);
            }
        } else {
            if (n2 == 0) {
                return new Boolean(this.isTestActivated(n));
            }
            if (n2 == 1) {
                Class clazz = this.getOWLTestClass(n);
                OWLTest oWLTest = OWLTestLibrary.getOWLTest(clazz);
                String string = oWLTest.getGroup() == null ? "" : "      ";
                return string + oWLTest.getName();
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public boolean isSeparator(int n) {
        return this.testClasses.get(n) instanceof String;
    }

    private boolean isTestActivated(int n) {
        return this.getOWLTest(this.getOWLTestClass(n)) != null;
    }

    private void setTestActivated(int n, boolean bl) {
        Class clazz = this.getOWLTestClass(n);
        if (bl) {
            OWLTest oWLTest = OWLTestLibrary.getOWLTest(clazz);
            if (oWLTest != null) {
                this.testManager.addOWLTest(oWLTest);
            }
        } else {
            OWLTest oWLTest = this.getOWLTest(clazz);
            if (oWLTest != null) {
                this.testManager.removeOWLTest(oWLTest);
            }
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            boolean bl = (Boolean)object;
            if (this.isSeparator(n)) {
                String string = this.getGroupName(n);
                this.testManager.setOWLTestGroupEnabled(string, bl);
                this.fireTableDataChanged();
            } else {
                this.setTestActivated(n, bl);
            }
        }
    }

    private String getGroupName(int n) {
        return (String)this.testClasses.get(n);
    }
}

