/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.subsumption.ChangedClassItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ChangedClassesTableModel
extends AbstractTableModel
implements Disposable {
    public static final int COL_CLS = 0;
    public static final int COL_TEXT = 1;
    public static final int COL_COUNT = 2;
    private List items = new ArrayList();
    private Hashtable itemsByCls = new Hashtable();
    private ModelListener modelListener = new ModelAdapter(){

        public void classDeleted(RDFSClass rDFSClass) {
            ChangedClassesTableModel.this.refill();
        }
    };
    private OWLModel owlModel;

    public ChangedClassesTableModel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.refill();
        oWLModel.addModelListener(this.modelListener);
    }

    void assertChange(OWLNamedClass oWLNamedClass) {
        ChangedClassItem changedClassItem = this.getOrCreateItem(oWLNamedClass);
        this.assertChange(changedClassItem);
    }

    private void assertChange(ChangedClassItem changedClassItem) {
        changedClassItem.assertChange();
        int n = this.items.indexOf(changedClassItem);
        this.items.remove(n);
        this.itemsByCls.remove(changedClassItem.getCls());
        this.fireTableRowsDeleted(n, n);
    }

    void assertChanges(int[] nArray) {
        ArrayList<ChangedClassItem> arrayList = new ArrayList<ChangedClassItem>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            ChangedClassItem changedClassItem = (ChangedClassItem)this.items.get(n);
            OWLNamedClass oWLNamedClass = changedClassItem.getCls();
            if (OWLUtil.isInconsistent(oWLNamedClass) || !oWLNamedClass.isEditable()) continue;
            arrayList.add(changedClassItem);
        }
        this.assertChanges(arrayList);
    }

    private void assertChanges(Collection collection) {
        try {
            this.owlModel.beginTransaction("Assert classification changes");
            for (ChangedClassItem changedClassItem : collection) {
                this.assertChange(changedClassItem);
            }
            this.owlModel.commitTransaction();
        }
        catch (Exception exception) {
            this.owlModel.rollbackTransaction();
            RuntimeException runtimeException = new RuntimeException(exception.getMessage());
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    public boolean contains(Cls cls) {
        return this.itemsByCls.containsKey(cls);
    }

    public void dispose() {
        this.owlModel.removeModelListener(this.modelListener);
    }

    private void fillItems(Collection collection, Collection collection2, Cls cls) {
        ChangedClassItem changedClassItem;
        this.removeDuplicates(collection, collection2);
        for (OWLNamedClass oWLNamedClass : collection) {
            if (oWLNamedClass.isMetaclass()) continue;
            changedClassItem = this.getOrCreateItem(oWLNamedClass);
            changedClassItem.addRemovedSuperCls(cls);
        }
        for (OWLNamedClass oWLNamedClass : collection2) {
            if (oWLNamedClass.isMetaclass()) continue;
            changedClassItem = this.getOrCreateItem(oWLNamedClass);
            changedClassItem.addAddedSuperCls(cls);
        }
    }

    public String getChangeText(Cls cls) {
        ChangedClassItem changedClassItem = (ChangedClassItem)this.itemsByCls.get(cls);
        if (changedClassItem != null) {
            return changedClassItem.toString();
        }
        return null;
    }

    public Cls getCls(int n) {
        return (Cls)this.getValueAt(n, 0);
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return Frame.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Class";
        }
        return "Changed direct superclasses";
    }

    private ChangedClassItem getOrCreateItem(OWLNamedClass oWLNamedClass) {
        ChangedClassItem changedClassItem = (ChangedClassItem)this.itemsByCls.get(oWLNamedClass);
        if (changedClassItem == null) {
            changedClassItem = new ChangedClassItem(oWLNamedClass);
            this.items.add(changedClassItem);
            this.itemsByCls.put(oWLNamedClass, changedClassItem);
        }
        return changedClassItem;
    }

    public int getRowCount() {
        return this.items.size();
    }

    public Object getValueAt(int n, int n2) {
        ChangedClassItem changedClassItem = (ChangedClassItem)this.items.get(n);
        if (n2 == 0) {
            return changedClassItem.getCls();
        }
        return changedClassItem.toString();
    }

    public void refill() {
        this.items = new ArrayList();
        this.itemsByCls = new Hashtable();
        for (OWLNamedClass oWLNamedClass : this.owlModel.getChangedInferredClasses()) {
            ChangedClassItem changedClassItem = this.getOrCreateItem(oWLNamedClass);
            ArrayList arrayList = new ArrayList(oWLNamedClass.getNamedSuperclasses());
            ArrayList arrayList2 = new ArrayList(oWLNamedClass.getInferredSuperclasses());
            this.removeDuplicates(arrayList, arrayList2);
            for (RDFSNamedClass rDFSNamedClass : arrayList) {
                if (rDFSNamedClass.isMetaclass()) continue;
                changedClassItem.addRemovedSuperCls(rDFSNamedClass);
            }
            for (RDFSNamedClass rDFSNamedClass : arrayList2) {
                if (rDFSNamedClass.isMetaclass()) continue;
                changedClassItem.addAddedSuperCls(rDFSNamedClass);
            }
        }
        for (OWLNamedClass oWLNamedClass : this.owlModel.getInconsistentClasses()) {
            this.getOrCreateItem(oWLNamedClass);
        }
        Collections.sort(this.items);
        this.fireTableDataChanged();
    }

    private void removeDuplicates(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList(collection);
        collection.removeAll(collection2);
        collection2.removeAll(arrayList);
    }
}

