/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResult;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFind
implements Find {
    private static final int MAX_MATCHES = -1;
    OWLModel owlModel;
    private Map<RDFResource, FindResult> results = new HashMap<RDFResource, FindResult>();
    private String string;
    private int searchType;
    private List<SearchListener> listeners;
    private boolean running = false;
    private Object lock;

    public BasicFind(OWLModel oWLModel, int n) {
        this.owlModel = oWLModel;
        this.searchType = n;
        this.lock = oWLModel;
    }

    @Override
    public void startSearch(String string) {
        this.startSearch(string, this.searchType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startSearch(String string, int n) {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.aborted()) return;
                this.string = string;
                this.searchType = n;
                this.results.clear();
                this.running = true;
            }
            this.notifySearchStarted();
            if (string != null && string.length() > 0) {
                Object object2;
                Object object3;
                object = this.getSearchProperties();
                Object object4 = object.iterator();
                while (object4.hasNext() && !this.aborted()) {
                    object3 = this.searchOnSlot((Slot)object4.next(), string, null, n);
                    object2 = this.lock;
                    synchronized (object2) {
                        this.results.putAll((Map<RDFResource, FindResult>)object3);
                    }
                    this.notifyResultsUpdated();
                }
                object4 = this.owlModel.getDefaultLanguage();
                if (object4 != null) {
                    object3 = object.iterator();
                    while (object3.hasNext() && !this.aborted()) {
                        object2 = (Slot)object3.next();
                        if (object2.equals(this.owlModel.getNameSlot())) continue;
                        Map<RDFResource, FindResult> map = this.searchOnSlot((Slot)object2, string, (String)object4, n);
                        Object object5 = this.lock;
                        synchronized (object5) {
                            this.results.putAll(map);
                        }
                        this.notifyResultsUpdated();
                    }
                }
            }
            if (!this.aborted()) {
                this.notifySearchComplete();
                return;
            }
            this.notifySearchCancelled();
            return;
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.running = false;
            }
        }
    }

    @Override
    public void cancelSearch() {
        throw new UnsupportedOperationException("Can't abort non-threaded search");
    }

    protected boolean aborted() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.running;
        }
    }

    protected Map<RDFResource, FindResult> searchOnSlot(Slot slot, String string, String string2, int n) {
        HashMap<RDFResource, FindResult> hashMap = new HashMap<RDFResource, FindResult>();
        Collection collection = null;
        String string3 = string;
        switch (n) {
            case 0: {
                string3 = string3 + "*";
            }
            case 3: {
                if (string2 == null) break;
                string3 = "~#" + string2 + " " + string3;
                break;
            }
            case 1: {
                string3 = string3 + "*";
            }
            case 2: {
                string3 = "*" + string3;
            }
        }
        collection = this.owlModel.getMatchingFrames(slot, null, false, string3, -1);
        if (collection != null) {
            for (Frame frame : collection) {
                RDFResource rDFResource;
                FindResult findResult;
                if (!this.isValidFrameToSearch(frame) || (findResult = FindResult.createFindResult(rDFResource = (RDFResource)frame, slot, string)) == null) continue;
                hashMap.put(rDFResource, findResult);
            }
        }
        return hashMap;
    }

    protected List getSearchProperties() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        Collection collection = this.owlModel.getSearchSynonymProperties();
        arrayList.addAll(collection);
        arrayList.add(this.owlModel.getNameSlot());
        Slot slot = this.owlModel.getOWLNamedClassClass().getBrowserSlotPattern().getFirstSlot();
        if (!slot.equals(this.owlModel.getNameSlot()) && !collection.contains(slot)) {
            arrayList.add(slot);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<RDFResource, FindResult> getResults() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<RDFResource, FindResult>(this.results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getResultResources() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<RDFResource>(this.results.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.results.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSummaryText() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning()) {
                return "Searching for \"" + this.string + "\" : (" + this.results.size() + " matches)";
            }
            return "Results for \"" + this.string + "\" : (" + this.results.size() + " matches)";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLastSearch() {
        Object object = this.lock;
        synchronized (object) {
            return this.string;
        }
    }

    @Override
    public String getDescription() {
        return "Find Resource";
    }

    @Override
    public OWLModel getModel() {
        return this.owlModel;
    }

    @Override
    public int getNumSearchProperties() {
        return this.getSearchProperties().size();
    }

    protected boolean isValidFrameToSearch(Frame frame) {
        Class<?> clazz = frame.getClass();
        return OWLNamedClass.class.isAssignableFrom(clazz) || OWLProperty.class.isAssignableFrom(clazz) || OWLIndividual.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSearchType() {
        Object object = this.lock;
        synchronized (object) {
            return this.searchType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySearchStarted() {
        Object object = this.lock;
        synchronized (object) {
            for (SearchListener searchListener : this.listeners) {
                searchListener.searchStartedEvent(this);
                searchListener.searchEvent(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResultsUpdated() {
        Object object = this.lock;
        synchronized (object) {
            for (SearchListener searchListener : this.listeners) {
                searchListener.resultsUpdatedEvent(this.results.size(), this);
                searchListener.searchEvent(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySearchComplete() {
        Object object = this.lock;
        synchronized (object) {
            for (SearchListener searchListener : this.listeners) {
                searchListener.searchCompleteEvent(this.results.size(), this);
                searchListener.searchEvent(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySearchCancelled() {
        Object object = this.lock;
        synchronized (object) {
            for (SearchListener searchListener : this.listeners) {
                searchListener.searchCancelledEvent(this);
                searchListener.searchEvent(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResultListener(SearchListener searchListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<SearchListener>();
            }
            this.listeners.add(searchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeResultListener(SearchListener searchListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners != null) {
                return this.listeners.remove(searchListener);
            }
            return false;
        }
    }
}

