/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InstanceNameEditor
extends JTextField {
    private DocumentChangedListener documentListener = new DocumentChangedListener(){

        public void insertUpdate(DocumentEvent documentEvent) {
            if (InstanceNameEditor.this.getText().indexOf(32) > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        InstanceNameEditor.this.replaceSpaces();
                    }
                });
            } else {
                InstanceNameEditor.this.onTextChange();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            InstanceNameEditor.this.onTextChange();
        }
    };
    private FrameListener frameListener = new FrameAdapter(){

        public void nameChanged(FrameEvent frameEvent) {
            InstanceNameEditor.this.updateAll();
        }

        public void deleted(FrameEvent frameEvent) {
            InstanceNameEditor.this.instance = null;
            InstanceNameEditor.this.updateAll();
        }
    };
    private Instance instance;

    public InstanceNameEditor() {
        OWLUI.addCopyPastePopup(this);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                InstanceNameEditor.this.attemptCommit();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        InstanceNameEditor.this.attemptCommit();
                        break;
                    }
                    case 27: {
                        InstanceNameEditor.this.updateAll();
                    }
                }
            }
        });
        this.getDocument().addDocumentListener((DocumentListener)this.documentListener);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 130, dimension.height);
    }

    public void addNotify() {
        super.addNotify();
        if (this.needsNameChange()) {
            this.selectAll();
        }
    }

    protected void attemptCommit() {
        String string;
        String string2;
        if (this.instance != null && !this.instance.isBeingDeleted() && this.isValidName(string2 = this.getText()) && !(string = this.instance.getName()).equals(string2)) {
            try {
                this.instance.setName(string2);
            }
            catch (Exception exception) {
                OWLUI.handleError((OWLModel)this.instance.getKnowledgeBase(), exception);
            }
        }
    }

    public void dispose() {
        this.removeListener();
    }

    protected Instance getInstance() {
        return this.instance;
    }

    protected String getInvalidTextDescription(String string) {
        String string2 = null;
        if (string == null || !this.isValidName(string)) {
            string2 = "Invalid name";
        }
        return string2;
    }

    public boolean isValidName(String string) {
        Instance instance = this.getInstance();
        if (instance != null) {
            Frame frame = instance.getKnowledgeBase().getFrame(string);
            boolean bl = frame != null && !frame.equals(instance);
            boolean bl2 = instance.getKnowledgeBase().isValidFrameName(string, (Frame)instance);
            return bl2 && !bl && string.length() > 0;
        }
        return true;
    }

    private boolean needsNameChange() {
        String string;
        boolean bl = false;
        Instance instance = this.getInstance();
        if (instance != null && instance.isEditable() && (string = instance.getName()) != null) {
            int n = string.lastIndexOf(95);
            String string2 = string.substring(n + 1);
            try {
                Integer.parseInt(string2);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private void onTextChange() {
        this.validateText(this.getText());
    }

    private void removeListener() {
        if (this.instance != null) {
            this.instance.removeFrameListener(this.frameListener);
        }
    }

    private void replaceSpaces() {
        String string = this.getText();
        string = string.replace(' ', '_');
        int n = this.getCaretPosition();
        this.setText(string);
        this.setCaretPosition(n);
        this.onTextChange();
    }

    public void selectAll() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstanceNameEditor.super.selectAll();
                InstanceNameEditor.this.requestFocus();
            }
        });
    }

    public void setInstance(Instance instance) {
        this.attemptCommit();
        this.removeListener();
        this.instance = instance;
        if (instance != null) {
            instance.addFrameListener(this.frameListener);
        }
        this.updateAll();
    }

    public void setText(String string) {
        this.documentListener.disable();
        super.setText(string == null ? "" : string);
        this.documentListener.enable();
        this.validateText(string);
    }

    private void updateAll() {
        if (this.instance != null) {
            String string = this.instance.getName();
            this.setText(string);
            this.setEditable(this.instance.isEditable());
            this.onTextChange();
            if (this.needsNameChange()) {
                this.selectAll();
            }
        } else {
            this.setText("");
            this.setEditable(false);
        }
    }

    protected boolean validateText(String string) {
        String string2;
        String string3 = string2 = string == null ? null : this.getInvalidTextDescription(string);
        if (string2 == null) {
            this.setForeground(Color.black);
            this.setToolTipText(null);
        } else {
            this.setForeground(Color.red);
            this.setToolTipText(string2);
        }
        return string2 == null;
    }
}

