/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository.wizard;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.AbstractRepositoryWizardPage;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryCreatorWizardPlugin;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SelectRepositoryTypeWizardPage
extends AbstractRepositoryWizardPage {
    private ButtonGroup buttonGroup;
    private OWLModel owlModel;
    private RepositoryCreatorWizardPlugin selectedPlugin;

    public SelectRepositoryTypeWizardPage(RepositoryWizard repositoryWizard, OWLModel oWLModel) {
        super("Select repository type", repositoryWizard);
        this.owlModel = oWLModel;
        Box box = new Box(1);
        JPanel jPanel = new JPanel(new BorderLayout(7, 7));
        jPanel.add((Component)new JLabel("Please select the type of repository that you would like to create"), "North");
        jPanel.add((Component)box, "Center");
        this.buttonGroup = new ButtonGroup();
        String string = "";
        for (RepositoryCreatorWizardPlugin repositoryCreatorWizardPlugin : repositoryWizard.getPlugins()) {
            JRadioButton jRadioButton = new JRadioButton(new PluginSelectedAction(repositoryCreatorWizardPlugin));
            jRadioButton.setToolTipText(repositoryCreatorWizardPlugin.getDescription());
            jRadioButton.setEnabled(repositoryCreatorWizardPlugin.isSuitable(this.owlModel));
            box.add(jRadioButton);
            this.buttonGroup.add(jRadioButton);
            string = string + "<p>";
            string = string + "<b>" + repositoryCreatorWizardPlugin.getName() + "</b><font size=\"-2\"> " + repositoryCreatorWizardPlugin.getDescription();
            string = string + "</font></p>";
        }
        box.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.getContentComponent().add((Component)jPanel, "North");
        this.setHelpText("Please select the type of repository that you would like to add:", string);
    }

    public void nextPressed() {
        this.getRepositoryWizard().setSelectedPlugin(this.selectedPlugin);
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    private class PluginSelectedAction
    extends AbstractAction {
        private RepositoryCreatorWizardPlugin plugin;

        public PluginSelectedAction(RepositoryCreatorWizardPlugin repositoryCreatorWizardPlugin) {
            super(repositoryCreatorWizardPlugin.getName());
            this.plugin = repositoryCreatorWizardPlugin;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SelectRepositoryTypeWizardPage.this.selectedPlugin = this.plugin;
        }
    }
}

