/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.impl.OperationImpl;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.properties.range.OWLRangeWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OWLDataRangeComponent
extends JComponent {
    private Action createAction = new AbstractAction("Create value...", OWLIcons.getAddIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLDataRangeComponent.this.createValue();
        }

        public boolean isEnabled() {
            return OWLDataRangeComponent.this.datatype != null;
        }
    };
    private RDFSDatatype datatype;
    private Action deleteAction = new AbstractAction("Delete selected value...", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLDataRangeComponent.this.deleteSelectedValue();
        }
    };
    private JList list;
    private DefaultListModel listModel;
    private OWLRangeWidget rangeWidget;

    public OWLDataRangeComponent(OWLRangeWidget oWLRangeWidget) {
        this.rangeWidget = oWLRangeWidget;
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.setLayout(new BorderLayout());
        LabeledComponent labeledComponent = new LabeledComponent("Allowed values", new JScrollPane(this.list));
        labeledComponent.addHeaderButton(this.createAction);
        labeledComponent.addHeaderButton(this.deleteAction);
        this.add("Center", (Component)labeledComponent);
        this.deleteAction.setEnabled(false);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                OWLDataRangeComponent.this.updateActions(true);
            }
        });
    }

    private void createValue() {
        if (this.datatype == null) {
            return;
        }
        String string = ProtegeUI.getModalDialogFactory().showInputDialog(this, "Enter a new " + this.datatype.getBrowserText() + " literal", null);
        if (string != null) {
            RDFProperty rDFProperty = this.rangeWidget.getEditedProperty();
            if ((string = string.trim()).length() > 0) {
                OWLModel oWLModel = rDFProperty.getOWLModel();
                OWLDataRange oWLDataRange = null;
                RDFSLiteral rDFSLiteral = oWLModel.createRDFSLiteral(string, this.datatype);
                if (rDFProperty.getRange() instanceof OWLDataRange) {
                    OWLDataRange oWLDataRange2 = (OWLDataRange)rDFProperty.getRange();
                    List list = oWLDataRange2.getOneOfValueLiterals();
                    RDFSLiteral[] rDFSLiteralArray = new RDFSLiteral[list.size() + 1];
                    Iterator iterator = list.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        RDFSLiteral rDFSLiteral2 = (RDFSLiteral)iterator.next();
                        if (rDFSLiteral.equals(rDFSLiteral2)) {
                            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "The value " + string + " is already among the values.");
                            return;
                        }
                        rDFSLiteralArray[n] = rDFSLiteral2;
                        ++n;
                    }
                    rDFSLiteralArray[rDFSLiteralArray.length - 1] = rDFSLiteral;
                    oWLDataRange = oWLModel.createOWLDataRange(rDFSLiteralArray);
                } else {
                    oWLDataRange = oWLModel.createOWLDataRange(new RDFSLiteral[]{rDFSLiteral});
                }
                rDFProperty.setRange(oWLDataRange);
            }
        }
    }

    private void deleteSelectedValue() {
        int n = this.list.getSelectedIndex();
        if (n >= 0) {
            RDFProperty rDFProperty = this.rangeWidget.getEditedProperty();
            OWLModel oWLModel = rDFProperty.getOWLModel();
            OWLDataRange oWLDataRange = (OWLDataRange)rDFProperty.getRange();
            List list = oWLDataRange.getOneOfValueLiterals();
            if (list.size() == 1) {
                rDFProperty.setRange(null);
            } else {
                list.remove(n);
                RDFSLiteral[] rDFSLiteralArray = list.toArray(new RDFSLiteral[0]);
                rDFProperty.setRange(oWLModel.createOWLDataRange(rDFSLiteralArray));
            }
        }
    }

    public void refill() {
        RDFResource rDFResource;
        this.listModel.clear();
        RDFProperty rDFProperty = this.rangeWidget.getEditedProperty();
        if (rDFProperty != null && (rDFResource = rDFProperty.getRange()) instanceof OWLDataRange) {
            OWLDataRange oWLDataRange = (OWLDataRange)rDFResource;
            List list = oWLDataRange.getOneOfValueLiterals();
            for (RDFSLiteral rDFSLiteral : list) {
                this.listModel.addElement(rDFSLiteral);
            }
        }
    }

    public void setDatatype(RDFSDatatype rDFSDatatype) {
        this.datatype = rDFSDatatype;
        this.listModel.clear();
    }

    public void setEditable(boolean bl) {
        this.list.setEnabled(bl);
        this.updateActions(bl);
    }

    private void updateActions(boolean bl) {
        bl = bl && RemoteClientFrameStore.isOperationAllowed((KnowledgeBase)this.rangeWidget.getOWLModel(), (Operation)OperationImpl.PROPERTY_TAB_WRITE);
        this.createAction.setEnabled(bl);
        this.deleteAction.setEnabled(bl && this.list.getSelectedValue() != null);
    }

    public void setEnabled(boolean bl) {
        bl = bl && RemoteClientFrameStore.isOperationAllowed((KnowledgeBase)this.rangeWidget.getOWLModel(), (Operation)OperationImpl.PROPERTY_TAB_WRITE);
        this.createAction.setEnabled(bl);
        this.deleteAction.setEnabled(bl);
        this.setEditable(bl);
        super.setEnabled(bl);
    }
}

