/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSDatatype;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.properties.range.ExInclusiveToggleAction;
import edu.stanford.smi.protegex.owl.ui.properties.range.FacetsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.OWLRangeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.AssigningTextField;
import java.awt.Component;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class NumericFacetsPanel
extends FacetsPanel
implements ExInclusiveToggleAction.Callback {
    private ExInclusiveToggleAction maxAction;
    private JTextField maxTextField = new AssigningTextField(new AssigningTextField.Assign(){

        public void assign(String string) {
            NumericFacetsPanel.this.assignInterval(false);
        }
    });
    private ExInclusiveToggleAction minAction;
    private JTextField minTextField = new AssigningTextField(new AssigningTextField.Assign(){

        public void assign(String string) {
            NumericFacetsPanel.this.assignInterval(false);
        }
    });

    public NumericFacetsPanel(OWLRangeWidget oWLRangeWidget) {
        super(oWLRangeWidget);
        this.maxTextField.setHorizontalAlignment(4);
        this.minTextField.setHorizontalAlignment(4);
        JToolBar jToolBar = ComponentFactory.createToolBar();
        this.maxAction = new ExInclusiveToggleAction("Toggle between ] and ), which mean <= or <", "XSDMaxExclusive", "XSDMaxInclusive", this);
        this.minAction = new ExInclusiveToggleAction("Toggle between [ and (, which mean >= or >", "XSDMinExclusive", "XSDMinInclusive", this);
        ComponentFactory.addToolBarButton((JToolBar)jToolBar, (Action)this.minAction);
        jToolBar.add(this.minTextField);
        jToolBar.add(new JLabel("  "));
        jToolBar.add(this.maxTextField);
        ComponentFactory.addToolBarButton((JToolBar)jToolBar, (Action)this.maxAction);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Range Interval (Min/Max)", jToolBar);
        this.add("Center", (Component)((Object)oWLLabeledComponent));
    }

    public void assignInterval() {
        this.assignInterval(true);
    }

    public void assignInterval(boolean bl) {
        RDFResource rDFResource = this.rangeWidget.getEditedProperty().getRange();
        if (rDFResource instanceof RDFSDatatype) {
            RDFSDatatype rDFSDatatype = (RDFSDatatype)rDFResource;
            String string = this.minTextField.getText();
            String string2 = this.maxTextField.getText();
            if (bl || !string2.equals(this.getMaxText(rDFSDatatype)) || !string.equals(this.getMinText(rDFSDatatype))) {
                String string3 = (this.minAction.isExclusive() ? "(" : "[") + string + "," + string2 + (this.maxAction.isExclusive() ? ")" : "]");
                if (rDFSDatatype.isAnonymous()) {
                    rDFSDatatype = rDFSDatatype.getBaseDatatype();
                }
                string3 = rDFSDatatype.getName() + string3;
                OWLModel oWLModel = this.rangeWidget.getOWLModel();
                Map map = DefaultRDFSDatatype.parse(oWLModel, string3);
                if (map.size() > 0) {
                    String string4 = oWLModel.getNextAnonymousResourceName();
                    RDFSDatatype rDFSDatatype2 = oWLModel.createRDFSDatatype(string4);
                    for (RDFProperty rDFProperty : map.keySet()) {
                        Object v = map.get(rDFProperty);
                        rDFSDatatype2.setPropertyValue(rDFProperty, v);
                    }
                    this.rangeWidget.setRange(rDFSDatatype2);
                } else {
                    this.rangeWidget.setRange(rDFSDatatype);
                }
            }
        }
    }

    private String getMinText(RDFSDatatype rDFSDatatype) {
        RDFSLiteral rDFSLiteral = rDFSDatatype.getMinInclusive();
        if (rDFSLiteral == null) {
            rDFSLiteral = rDFSDatatype.getMinExclusive();
        }
        return rDFSLiteral == null ? "" : rDFSLiteral.toString();
    }

    private String getMaxText(RDFSDatatype rDFSDatatype) {
        RDFSLiteral rDFSLiteral = rDFSDatatype.getMaxInclusive();
        if (rDFSLiteral == null) {
            rDFSLiteral = rDFSDatatype.getMaxExclusive();
        }
        return rDFSLiteral == null ? "" : rDFSLiteral.toString();
    }

    public void setEditable(boolean bl) {
        this.minAction.setEnabled(bl);
        this.maxAction.setEnabled(bl);
        this.minTextField.setEditable(bl);
        this.maxTextField.setEditable(bl);
    }

    public void update(RDFSDatatype rDFSDatatype) {
        if (rDFSDatatype.isAnonymous()) {
            String string = this.getMaxText(rDFSDatatype);
            this.maxTextField.setText(string);
            String string2 = this.getMinText(rDFSDatatype);
            this.minTextField.setText(string2);
            this.minAction.setExclusive(rDFSDatatype.getMinExclusive() != null);
            this.maxAction.setExclusive(rDFSDatatype.getMaxExclusive() != null);
        } else {
            this.minTextField.setText("");
            this.maxTextField.setText("");
        }
    }
}

