/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.impl.OperationImpl;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.properties.OWLAnnotationPropertySubpropertyPane;
import edu.stanford.smi.protegex.owl.ui.properties.OWLDatatypePropertySubpropertyPane;
import edu.stanford.smi.protegex.owl.ui.properties.OWLObjectPropertySubpropertyPane;
import edu.stanford.smi.protegex.owl.ui.properties.OWLPropertyHierarchyPanel;
import edu.stanford.smi.protegex.owl.ui.properties.OWLSubpropertyPane;
import edu.stanford.smi.protegex.owl.ui.properties.OWLSuperpropertiesPanel;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OWLPropertyHierarchiesPanel
extends JPanel
implements Selectable,
HostResourceDisplay {
    private OWLModel owlModel;
    private JTabbedPane tabbedPane;
    private OWLPropertyHierarchyPanel objectPropertyHierarchy;
    private OWLPropertyHierarchyPanel datatypePropertyHierarchy;
    private OWLPropertyHierarchyPanel annotationPropertyHierarchy;
    private OWLPropertyHierarchyPanel allPropertiesHierarchy;
    ArrayList listeners;

    public OWLPropertyHierarchiesPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.listeners = new ArrayList();
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.objectPropertyHierarchy = this.createPanel(new OWLObjectPropertySubpropertyPane(this.owlModel), "OWLObjectProperty");
        this.tabbedPane.add("Object", this.objectPropertyHierarchy);
        this.datatypePropertyHierarchy = this.createPanel(new OWLDatatypePropertySubpropertyPane(this.owlModel), "OWLDatatypeProperty");
        this.tabbedPane.add("Datatype", this.datatypePropertyHierarchy);
        this.annotationPropertyHierarchy = this.createPanel(new OWLAnnotationPropertySubpropertyPane(this.owlModel), "OWLDatatypeProperty");
        this.tabbedPane.add("Annotation", this.annotationPropertyHierarchy);
        this.allPropertiesHierarchy = this.createPanel(new OWLSubpropertyPane(this.owlModel), "OWLObjectProperty");
        this.tabbedPane.add("All", this.allPropertiesHierarchy);
        this.add(this.tabbedPane);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (OWLPropertyHierarchiesPanel.this.isShowing()) {
                    OWLPropertyHierarchiesPanel.this.notifySelectionListeners();
                }
            }
        });
        JLabel jLabel = ComponentFactory.createLabel((Icon)Icons.getProjectIcon());
        jLabel.setText(this.owlModel.getProject().getName());
        String string = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        HeaderComponent headerComponent = new HeaderComponent("Property Browser", string, (JComponent)jLabel);
        headerComponent.setColor(Colors.getSlotColor());
        this.add((Component)headerComponent, "North");
    }

    private OWLPropertyHierarchyPanel createPanel(OWLSubpropertyPane oWLSubpropertyPane, String string) {
        oWLSubpropertyPane.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                OWLPropertyHierarchiesPanel.this.notifySelectionListeners();
            }
        });
        OWLSuperpropertiesPanel oWLSuperpropertiesPanel = new OWLSuperpropertiesPanel(oWLSubpropertyPane, this.owlModel);
        oWLSuperpropertiesPanel.setAddActionIconBase(string);
        oWLSuperpropertiesPanel.setRemoveActionIconBase(string);
        return new OWLPropertyHierarchyPanel(oWLSubpropertyPane, oWLSuperpropertiesPanel);
    }

    public Collection getSelection() {
        OWLPropertyHierarchyPanel oWLPropertyHierarchyPanel = (OWLPropertyHierarchyPanel)this.tabbedPane.getSelectedComponent();
        if (oWLPropertyHierarchyPanel != null) {
            return oWLPropertyHierarchyPanel.getSubpropertyPane().getSelection();
        }
        return Collections.EMPTY_LIST;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.listeners.add(selectionListener);
    }

    public void clearSelection() {
    }

    public void notifySelectionListeners() {
        for (SelectionListener selectionListener : new ArrayList(this.listeners)) {
            SelectionEvent selectionEvent = new SelectionEvent((Selectable)this, 1);
            selectionListener.selectionChanged(selectionEvent);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.listeners.remove(selectionListener);
    }

    public static void main(String[] stringArray) {
        try {
            JenaOWLModel jenaOWLModel = ProtegeOWL.createJenaOWLModel();
            jenaOWLModel.createOWLObjectProperty("A");
            OWLPropertyHierarchiesPanel oWLPropertyHierarchiesPanel = new OWLPropertyHierarchiesPanel(jenaOWLModel);
            JFrame jFrame = new JFrame();
            jFrame.setSize(300, 700);
            jFrame.setDefaultCloseOperation(3);
            jFrame.setContentPane(oWLPropertyHierarchiesPanel);
            jFrame.show();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
    }

    public boolean displayHostResource(RDFResource rDFResource) {
        boolean bl = false;
        if (rDFResource instanceof RDFProperty) {
            RDFProperty rDFProperty = (RDFProperty)rDFResource;
            OWLPropertyHierarchyPanel oWLPropertyHierarchyPanel = this.allPropertiesHierarchy;
            oWLPropertyHierarchyPanel = rDFProperty.isAnnotationProperty() ? this.annotationPropertyHierarchy : (rDFProperty instanceof OWLObjectProperty ? this.objectPropertyHierarchy : this.datatypePropertyHierarchy);
            this.tabbedPane.setSelectedComponent(oWLPropertyHierarchyPanel);
            bl = oWLPropertyHierarchyPanel.getSubpropertyPane().displayHostResource(rDFProperty);
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        bl = bl && RemoteClientFrameStore.isOperationAllowed((KnowledgeBase)this.owlModel, (Operation)OperationImpl.PROPERTY_TAB_WRITE);
        this.objectPropertyHierarchy.setEnabled(bl);
        this.datatypePropertyHierarchy.setEnabled(bl);
        this.annotationPropertyHierarchy.setEnabled(bl);
        this.allPropertiesHierarchy.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setHierarchyTreeRenderer(FrameRenderer frameRenderer) {
        this.objectPropertyHierarchy.setRenderer(frameRenderer);
        this.datatypePropertyHierarchy.setRenderer(frameRenderer);
        this.annotationPropertyHierarchy.setRenderer(frameRenderer);
        this.allPropertiesHierarchy.setRenderer(frameRenderer);
    }
}

