/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.code;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.emf.EditableEMFGeneratorOptions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EMFPanel
extends JPanel {
    private JFileChooser fileChooser = new JFileChooser(".");
    private EditableEMFGeneratorOptions options;
    private JCheckBox overwriteCheckBox;
    private JTextField packageTextField;
    private JTextField rootFolderTextField;

    public EMFPanel(EditableEMFGeneratorOptions editableEMFGeneratorOptions) {
        this.options = editableEMFGeneratorOptions;
        this.packageTextField = new JTextField();
        if (editableEMFGeneratorOptions.getPackage() != null) {
            this.packageTextField.setText(editableEMFGeneratorOptions.getPackage());
        }
        this.rootFolderTextField = new JTextField();
        if (editableEMFGeneratorOptions.getOutputFolder() != null) {
            this.rootFolderTextField.setText(editableEMFGeneratorOptions.getOutputFolder().getAbsolutePath());
        }
        this.fileChooser.setDialogTitle("Select output folder");
        this.fileChooser.setFileSelectionMode(1);
        this.overwriteCheckBox = new JCheckBox("Overwrite all files");
        this.setLayout(new BoxLayout(this, 1));
        LabeledComponent labeledComponent = new LabeledComponent("Root output folder", (Component)this.rootFolderTextField);
        labeledComponent.addHeaderButton((Action)new AbstractAction("Select folder...", Icons.getAddIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                EMFPanel.this.selectFolder();
            }
        });
        this.add((Component)labeledComponent);
        this.add(Box.createVerticalStrut(8));
        this.add((Component)new LabeledComponent("Java package", (Component)this.packageTextField));
        this.add(Box.createVerticalStrut(8));
        this.overwriteCheckBox.setPreferredSize(new Dimension(400, 24));
        this.add(this.overwriteCheckBox);
    }

    public boolean isOverwriteMode() {
        return this.overwriteCheckBox.isSelected();
    }

    public void ok() {
        File file = null;
        String string = this.rootFolderTextField.getText().trim();
        if (string.length() > 0) {
            file = new File(string);
        }
        this.options.setOutputFolder(file);
        String string2 = this.packageTextField.getText().trim();
        this.options.setPackage(string2.length() > 0 ? string2 : null);
    }

    private void selectFolder() {
        if (this.fileChooser.showDialog(this, "Select") == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.rootFolderTextField.setText(file.toString());
        }
    }

    public void setOverwriteMode(boolean bl) {
        this.overwriteCheckBox.setSelected(bl);
    }
}

