/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.cls;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ClassMatrixPanel;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ExistentialMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.SubclassesMatrixFilter;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;

public class ExistentialMatrixAction
extends ResourceAction {
    public ExistentialMatrixAction() {
        super("Show existential matrix of subclasses...", Icons.getBlankIcon(), "Search and View/");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLModel oWLModel = this.getOWLModel();
        RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.getResource();
        final Collection collection = this.selectProperties(rDFSNamedClass);
        if (!collection.isEmpty()) {
            SubclassesMatrixFilter subclassesMatrixFilter = new SubclassesMatrixFilter(rDFSNamedClass);
            MatrixTableModel matrixTableModel = new MatrixTableModel(oWLModel, subclassesMatrixFilter){

                protected void addDefaultColumns() {
                    super.addDefaultColumns();
                    for (RDFProperty rDFProperty : collection) {
                        this.addColumn(new ExistentialMatrixColumn(rDFProperty));
                    }
                }
            };
            ClassMatrixPanel classMatrixPanel = new ClassMatrixPanel(oWLModel, subclassesMatrixFilter, matrixTableModel);
            ResultsPanelManager.addResultsPanel(oWLModel, classMatrixPanel, true);
        }
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return rDFResource instanceof RDFSNamedClass;
    }

    private Collection selectProperties(RDFSNamedClass rDFSNamedClass) {
        Collection collection = ClassMatrixPanel.getPotentialProperties(rDFSNamedClass);
        OWLModel oWLModel = rDFSNamedClass.getOWLModel();
        return ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection(this.getComponent(), oWLModel, collection, "Select properties to show");
    }
}

