/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTree;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultClassFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultIndividualFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindInDialogAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResourceFinder;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class IndividualsTabClassesPanel
extends SelectableContainer
implements ClassTreePanel {
    private ClassTree classTree;
    private OWLModel owlModel;

    public IndividualsTabClassesPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.add(this.createHeaderPanel(), "North");
        this.add(this.createClsesPanel(), "Center");
        this.setSelectable(this.classTree);
    }

    private JComponent createHeaderPanel() {
        JLabel jLabel = ComponentFactory.createLabel((String)this.owlModel.getProject().getName());
        jLabel.setIcon(Icons.getProjectIcon());
        String string = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_TITLE);
        String string2 = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        HeaderComponent headerComponent = new HeaderComponent(string, string2, (JComponent)jLabel);
        headerComponent.setColor(Colors.getClsColor());
        return headerComponent;
    }

    private JComponent createClsesPanel() {
        OWLNamedClass oWLNamedClass = this.owlModel.getOWLThingClass();
        this.classTree = new ClassTree(null, (LazyTreeRoot)new ParentChildRoot((Cls)oWLNamedClass));
        this.classTree.setLargeModel(true);
        FrameRenderer frameRenderer = FrameRenderer.createInstance();
        frameRenderer.setDisplayDirectInstanceCount(true);
        this.classTree.setCellRenderer((TreeCellRenderer)frameRenderer);
        this.classTree.setSelectionRow(0);
        this.classTree.setCellRenderer((TreeCellRenderer)((Object)new InferredInstancesCountRenderer()));
        this.classTree.addMouseListener((MouseListener)new PopupMenuMouseListener((JComponent)((Object)this.classTree)){

            protected JPopupMenu getPopupMenu() {
                Collection collection = IndividualsTabClassesPanel.this.classTree.getSelection();
                if (collection.size() == 1) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    Cls cls = (Cls)collection.iterator().next();
                    if (cls instanceof RDFResource) {
                        ResourceActionManager.addResourceActions(jPopupMenu, (Component)((Object)IndividualsTabClassesPanel.this), (RDFResource)cls);
                        if (jPopupMenu.getComponentCount() > 0) {
                            return jPopupMenu;
                        }
                    }
                }
                return null;
            }

            protected void setSelection(JComponent jComponent, int n, int n2) {
                int n3 = IndividualsTabClassesPanel.this.classTree.getRowForLocation(n, n2);
                if (n3 >= 0) {
                    IndividualsTabClassesPanel.this.classTree.setSelectionRow(n3);
                }
            }
        });
        String string = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_HIERARCHY_LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(string, ComponentFactory.createScrollPane((JComponent)((Object)this.classTree)));
        labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        labeledComponent.addHeaderButton(this.getViewClsAction());
        FindInDialogAction findInDialogAction = new FindInDialogAction(new DefaultClassFind(this.owlModel, 1), Icons.getFindClsIcon(), this.classTree, true);
        ResourceFinder resourceFinder = new ResourceFinder(findInDialogAction);
        FindInDialogAction findInDialogAction2 = new FindInDialogAction(new DefaultIndividualFind(this.owlModel, 1), Icons.getFindIcon(), null, true);
        findInDialogAction2.setTextBox(resourceFinder.getTextComponent());
        resourceFinder.addButton(findInDialogAction2);
        labeledComponent.setFooterComponent((JComponent)resourceFinder);
        return labeledComponent;
    }

    public JTree getDropComponent() {
        return this.classTree;
    }

    private Action getViewClsAction() {
        return new ViewAction(ResourceKey.CLASS_VIEW, (Selectable)this){

            public void onView(Object object) {
                Cls cls = (Cls)object;
                IndividualsTabClassesPanel.this.owlModel.getProject().show((Instance)cls);
            }
        };
    }

    public void setSelectedCls(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            this.setSelectedClass((RDFSNamedClass)cls);
        }
    }

    public void setSelectedClass(RDFSNamedClass rDFSNamedClass) {
        OWLUI.setSelectedNodeInTree(this.classTree, rDFSNamedClass);
    }

    public void setSelectedClass(RDFSClass rDFSClass) {
        OWLUI.setSelectedNodeInTree(this.classTree, rDFSClass);
    }

    public JTree getTree() {
        return this.classTree;
    }

    private class InferredInstancesCountRenderer
    extends FrameRenderer {
        InferredInstancesCountRenderer() {
            this.setDisplayDirectInstanceCount(true);
        }

        protected String getInstanceCountString(Cls cls) {
            RDFSNamedClass rDFSNamedClass;
            int n;
            if (cls instanceof RDFSNamedClass && (n = (rDFSNamedClass = (RDFSNamedClass)cls).getInferredInstanceCount()) > 0) {
                return "  (" + cls.getDirectInstanceCount() + " / " + n + ")";
            }
            return super.getInstanceCountString(cls);
        }
    }
}

