/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.TransferableCollection;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;

public class AssertedTypesListPanel
extends SelectableContainer {
    private Action addAction;
    private SelectableList list;
    private OWLModel owlModel;
    private RDFResource resource;
    private ResourceListener resourceListener = new ResourceAdapter(){

        public void typeAdded(RDFResource rDFResource, RDFSClass rDFSClass) {
            ComponentUtilities.addListValue((JList)AssertedTypesListPanel.this.list, (Object)rDFSClass);
        }

        public void typeRemoved(RDFResource rDFResource, RDFSClass rDFSClass) {
            ComponentUtilities.removeListValue((JList)AssertedTypesListPanel.this.list, (Object)rDFSClass);
        }
    };

    public AssertedTypesListPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.list = ComponentFactory.createSelectableList(null);
        this.list.setCellRenderer((ListCellRenderer)((Object)new ResourceRenderer()));
        this.setSelectable((Selectable)this.list);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Asserted Types", new JScrollPane((Component)this.list));
        oWLLabeledComponent.addHeaderButton(this.createAddTypeAction());
        oWLLabeledComponent.addHeaderButton(this.createRemoveTypeAction());
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)oWLLabeledComponent));
        this.setPreferredSize(new Dimension(0, 100));
        this.list.setDragEnabled(true);
        this.list.setTransferHandler((TransferHandler)new FrameTransferHandler());
    }

    public void setResource(RDFResource rDFResource) {
        if (this.resource != null) {
            this.resource.removeResourceListener(this.resourceListener);
        }
        this.resource = rDFResource;
        if (this.resource != null) {
            this.resource.addResourceListener(this.resourceListener);
        }
        this.updateModel();
        this.updateAddButton();
    }

    public void updateModel() {
        SimpleListModel simpleListModel;
        if (this.resource == null) {
            simpleListModel = new DefaultListModel();
        } else {
            Collection collection = this.resource.getRDFTypes();
            simpleListModel = new SimpleListModel(collection);
        }
        this.list.setModel(simpleListModel);
    }

    public void updateAddButton() {
        this.addAction.setEnabled(this.resource != null);
    }

    private Action createAddTypeAction() {
        this.addAction = new AddAction("Add type...", OWLIcons.getAddIcon("PrimitiveClass")){

            public void onAdd() {
                Set set = ProtegeUI.getSelectionDialogFactory().selectClasses((Component)((Object)AssertedTypesListPanel.this), AssertedTypesListPanel.this.owlModel, "Select type to add");
                for (RDFSClass rDFSClass : set) {
                    AssertedTypesListPanel.this.resource.addProtegeType(rDFSClass);
                }
            }
        };
        return this.addAction;
    }

    private Action createRemoveTypeAction() {
        return new RemoveAction("Remove selected type", (Selectable)this.list, OWLIcons.getRemoveIcon("PrimitiveClass")){

            public void onRemove(Object object) {
                if (object instanceof RDFSClass) {
                    if (AssertedTypesListPanel.this.resource.getRDFTypes().size() > 1) {
                        AssertedTypesListPanel.this.resource.removeProtegeType((RDFSClass)object);
                    } else {
                        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(AssertedTypesListPanel.this.owlModel, "Resources must have at least one remaining type.");
                    }
                }
            }
        };
    }

    private class FrameTransferHandler
    extends TransferHandler {
        private FrameTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            Collection collection = AssertedTypesListPanel.this.getSelection();
            return collection.isEmpty() ? null : new TransferableCollection(collection);
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            return true;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                for (RDFSClass rDFSClass : AssertedTypesListPanel.this.getSelection()) {
                    int n2 = 0;
                    Log.getLogger().info("Move " + rDFSClass + " to: " + n2);
                    AssertedTypesListPanel.this.resource.moveDirectType(rDFSClass, n2);
                    AssertedTypesListPanel.this.updateModel();
                }
            }
        }

        public int getSourceActions(JComponent jComponent) {
            return 2;
        }
    }
}

