/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.action.MakeCopiesAction;
import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ConfigureAction;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ListFinder;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.individuals.InstancesList;
import edu.stanford.smi.protegex.owl.ui.individuals.MultiSlotPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListModel;

public class AssertedInstancesListPanel
extends SelectableContainer
implements Disposable {
    private Collection classes = Collections.EMPTY_LIST;
    private AllowableAction createAction;
    private AllowableAction createAnonymousAction;
    private AllowableAction copyAction;
    private AllowableAction deleteAction;
    private HeaderComponent header;
    private OWLLabeledComponent lc;
    private InstancesList list;
    private Collection listenedToInstances = new ArrayList();
    private OWLModel owlModel;
    private static final int SORT_LIMIT = ApplicationProperties.getIntegerProperty((String)"ui.DirectInstancesList.sort_limit", (int)1000);
    private boolean showSubclassInstances;
    private ClsListener _clsListener = new ClsAdapter(){

        public void directInstanceAdded(ClsEvent clsEvent) {
            Instance instance = clsEvent.getInstance();
            if (!AssertedInstancesListPanel.this.getModel().contains((Object)instance)) {
                ComponentUtilities.addListValue((JList)((Object)AssertedInstancesListPanel.this.list), (Object)instance);
                instance.addFrameListener(AssertedInstancesListPanel.this._instanceFrameListener);
            }
        }

        public void directInstanceRemoved(ClsEvent clsEvent) {
            AssertedInstancesListPanel.this.removeInstance(clsEvent.getInstance());
        }
    };
    private FrameListener _clsFrameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            super.ownSlotValueChanged(frameEvent);
            AssertedInstancesListPanel.this.updateButtons();
        }
    };
    private FrameListener _instanceFrameListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent frameEvent) {
            super.browserTextChanged(frameEvent);
            AssertedInstancesListPanel.this.sort();
            AssertedInstancesListPanel.this.repaint();
        }
    };

    public AssertedInstancesListPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        Action action = this.createViewAction();
        this.list = new InstancesList(action);
        this.lc = new OWLLabeledComponent(null, ComponentFactory.createScrollPane((JComponent)((Object)this.list)));
        this.addButtons(action, this.lc);
        this.lc.setFooterComponent((JComponent)new ListFinder((JList)((Object)this.list), ResourceKey.INSTANCE_SEARCH_FOR));
        this.lc.setBorder(ComponentUtilities.getAlignBorder());
        this.add((Component)((Object)this.lc), "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createHeader(), "North");
        this.add(jPanel, "North");
        this.setSelectable(this.list);
        this.lc.setHeaderLabel("Asserted Instances");
    }

    private void updateLabel() {
        String string;
        BrowserSlotPattern browserSlotPattern;
        Cls cls = this.getSoleAllowedCls();
        BrowserSlotPattern browserSlotPattern2 = browserSlotPattern = cls == null ? null : cls.getBrowserSlotPattern();
        if (browserSlotPattern == null) {
            string = null;
        } else if (browserSlotPattern.isSimple()) {
            string = browserSlotPattern.getFirstSlot().getBrowserText();
            if (":NAME".equals(string)) {
                string = "Asserted Instances";
            }
        } else {
            string = "multiple properties";
        }
        this.lc.setHeaderLabel(string);
    }

    private HeaderComponent createHeader() {
        JLabel jLabel = ComponentFactory.createLabel();
        String string = LocalizedText.getText((ResourceKey)ResourceKey.INSTANCE_BROWSER_TITLE);
        String string2 = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_EDITOR_FOR_CLASS_LABEL);
        this.header = new HeaderComponent(string, string2, (JComponent)jLabel);
        this.header.setColor(Colors.getInstanceColor());
        return this.header;
    }

    private void fixRenderer() {
        FrameRenderer frameRenderer = (FrameRenderer)this.list.getCellRenderer();
        frameRenderer.setDisplayType(this.showSubclassInstances);
    }

    protected void addButtons(Action action, LabeledComponent labeledComponent) {
        labeledComponent.addHeaderButton(this.createConfigureAction());
        labeledComponent.addHeaderButton(this.createCreateAction());
        labeledComponent.addHeaderButton(this.createCopyAction());
        labeledComponent.addHeaderButton(this.createDeleteAction());
        labeledComponent.addHeaderButton(this.createCreateAnonymousAction());
    }

    private void addClsListeners() {
        for (Cls cls : this.classes) {
            cls.addClsListener(this._clsListener);
            cls.addFrameListener(this._clsFrameListener);
        }
    }

    private void addInstanceListeners() {
        ListModel listModel = this.list.getModel();
        int n = this.list.getFirstVisibleIndex();
        int n2 = this.list.getLastVisibleIndex();
        for (int i = n; i < n2; ++i) {
            Instance instance = (Instance)listModel.getElementAt(i);
            this.addInstanceListener(instance);
        }
    }

    private void removeInstanceListeners() {
        for (Instance instance : this.listenedToInstances) {
            instance.removeFrameListener(this._instanceFrameListener);
        }
        this.listenedToInstances.clear();
    }

    private void addInstanceListener(Instance instance) {
        instance.addFrameListener(this._instanceFrameListener);
        this.listenedToInstances.add(instance);
    }

    protected Action createCreateAction() {
        this.createAction = new CreateAction("Create instance", OWLIcons.getCreateIndividualIcon("RDFIndividual")){

            public void onCreate() {
                if (!AssertedInstancesListPanel.this.classes.isEmpty()) {
                    Cls cls;
                    Instance instance = AssertedInstancesListPanel.this.owlModel.createInstance(null, AssertedInstancesListPanel.this.classes);
                    if (instance instanceof Cls && (cls = (Cls)instance).getDirectSuperclassCount() == 0) {
                        cls.addDirectSuperclass((Cls)AssertedInstancesListPanel.this.owlModel.getOWLThingClass());
                    }
                    AssertedInstancesListPanel.this.list.setSelectedValue(instance, true);
                }
            }
        };
        return this.createAction;
    }

    protected Action createCreateAnonymousAction() {
        this.createAnonymousAction = new CreateAction("Create anonymous instance", OWLIcons.getCreateIndividualIcon("RDFAnonIndividual")){

            public void onCreate() {
                if (!AssertedInstancesListPanel.this.classes.isEmpty()) {
                    Cls cls;
                    String string = AssertedInstancesListPanel.this.owlModel.getNextAnonymousResourceName();
                    Instance instance = AssertedInstancesListPanel.this.owlModel.createInstance(string, AssertedInstancesListPanel.this.classes);
                    if (instance instanceof Cls && (cls = (Cls)instance).getDirectSuperclassCount() == 0) {
                        cls.addDirectSuperclass((Cls)AssertedInstancesListPanel.this.owlModel.getOWLThingClass());
                    }
                    AssertedInstancesListPanel.this.list.setSelectedValue(instance, true);
                }
            }
        };
        return this.createAnonymousAction;
    }

    protected Action createConfigureAction() {
        return new ConfigureAction(){

            public void loadPopupMenu(JPopupMenu jPopupMenu) {
                jPopupMenu.add(AssertedInstancesListPanel.this.createSetDisplaySlotAction());
                jPopupMenu.add(AssertedInstancesListPanel.this.createShowAllInstancesAction());
            }
        };
    }

    protected JMenuItem createShowAllInstancesAction() {
        AbstractAction abstractAction = new AbstractAction("Show Subclass Instances"){

            public void actionPerformed(ActionEvent actionEvent) {
                AssertedInstancesListPanel.this.setShowAllInstances(!AssertedInstancesListPanel.this.showSubclassInstances);
            }
        };
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(abstractAction);
        jCheckBoxMenuItem.setSelected(this.showSubclassInstances);
        return jCheckBoxMenuItem;
    }

    private void setShowAllInstances(boolean bl) {
        this.showSubclassInstances = bl;
        this.reload();
        this.fixRenderer();
    }

    protected Cls getSoleAllowedCls() {
        Cls cls = this.classes.size() == 1 ? (Cls)CollectionUtilities.getFirstItem((Collection)this.classes) : null;
        return cls;
    }

    protected JMenu createSetDisplaySlotAction() {
        JMenu jMenu = ComponentFactory.createMenu((String)"Set Display Slot");
        boolean bl = false;
        Cls cls = this.getSoleAllowedCls();
        if (cls != null) {
            Object object2;
            BrowserSlotPattern browserSlotPattern = cls.getBrowserSlotPattern();
            Slot slot = browserSlotPattern != null && browserSlotPattern.isSimple() ? browserSlotPattern.getFirstSlot() : null;
            for (Object object2 : cls.getVisibleTemplateSlots()) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.createSetDisplaySlotAction((Slot)object2));
                if (object2.equals(slot)) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                jMenu.add(jRadioButtonMenuItem);
                bl = true;
            }
            object2 = new JRadioButtonMenuItem(this.createSetDisplaySlotMultipleAction());
            if (slot == null) {
                ((AbstractButton)object2).setSelected(true);
            }
            jMenu.add((JMenuItem)object2);
        }
        jMenu.setEnabled(bl);
        return jMenu;
    }

    protected Action createSetDisplaySlotAction(final Slot slot) {
        return new AbstractAction(slot.getBrowserText(), slot.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                AssertedInstancesListPanel.this.getSoleAllowedCls().setDirectBrowserSlot(slot);
                AssertedInstancesListPanel.this.updateLabel();
                AssertedInstancesListPanel.this.repaint();
            }
        };
    }

    protected Action createSetDisplaySlotMultipleAction() {
        return new AbstractAction("Multiple Slots..."){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserSlotPattern browserSlotPattern;
                Cls cls = AssertedInstancesListPanel.this.getSoleAllowedCls();
                BrowserSlotPattern browserSlotPattern2 = AssertedInstancesListPanel.this.getSoleAllowedCls().getBrowserSlotPattern();
                MultiSlotPanel multiSlotPanel = new MultiSlotPanel(browserSlotPattern2, cls);
                int n = ModalDialog.showDialog((Component)((Object)AssertedInstancesListPanel.this), (Component)multiSlotPanel, (String)"Multislot Display Pattern", (int)11);
                if (n == 1 && (browserSlotPattern = multiSlotPanel.getBrowserTextPattern()) != null) {
                    cls.setDirectBrowserSlotPattern(browserSlotPattern);
                }
                AssertedInstancesListPanel.this.updateLabel();
                AssertedInstancesListPanel.this.repaint();
            }
        };
    }

    protected Action createDeleteAction() {
        this.deleteAction = new DeleteInstancesAction((Selectable)this);
        return this.deleteAction;
    }

    protected Action createCopyAction() {
        this.copyAction = new MakeCopiesAction(ResourceKey.INSTANCE_COPY, (Selectable)this){

            protected Instance copy(Instance instance, boolean bl) {
                Instance instance2 = super.copy(instance, bl);
                AssertedInstancesListPanel.this.setSelectedInstance(instance2);
                return instance2;
            }
        };
        return this.copyAction;
    }

    protected Action createReferencersAction() {
        return new ReferencersAction(ResourceKey.INSTANCE_VIEW_REFERENCES, (Selectable)this);
    }

    protected Action createViewAction() {
        return new ViewAction(ResourceKey.INSTANCE_VIEW, (Selectable)this){

            public void onView(Object object) {
                AssertedInstancesListPanel.this.owlModel.getProject().show((Instance)object);
            }
        };
    }

    public void dispose() {
        this.removeClsListeners();
        this.removeInstanceListeners();
    }

    public JComponent getDragComponent() {
        return this.list;
    }

    private SimpleListModel getModel() {
        return (SimpleListModel)this.list.getModel();
    }

    private boolean isSelectionEditable() {
        boolean bl = true;
        for (Instance instance : this.getSelection()) {
            if (instance.isEditable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void onSelectionChange() {
        boolean bl = this.isSelectionEditable();
        ComponentUtilities.setDragAndDropEnabled((JComponent)((Object)this.list), (boolean)bl);
        this.updateButtons();
    }

    private void removeInstance(Instance instance) {
        ComponentUtilities.removeListValue((JList)((Object)this.list), (Object)instance);
        instance.removeFrameListener(this._instanceFrameListener);
    }

    private void removeClsListeners() {
        for (Cls cls : this.classes) {
            cls.removeClsListener(this._clsListener);
            cls.removeFrameListener(this._clsFrameListener);
        }
    }

    public void setClses(Collection collection) {
        this.removeClsListeners();
        this.classes = new ArrayList(collection);
        this.list.setClasses(collection);
        this.reload();
        this.updateButtons();
        this.addClsListeners();
    }

    public void reload() {
        Object object3;
        this.removeInstanceListeners();
        Object object2 = this.list.getSelectedValue();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object object3 : this.classes) {
            linkedHashSet.addAll(this.getInstances((Cls)object3));
        }
        object3 = new ArrayList(linkedHashSet);
        if (object3.size() <= SORT_LIMIT) {
            Collections.sort(object3, new FrameComparator());
        }
        this.getModel().setValues((Collection)object3);
        if (object3.contains(object2)) {
            this.list.setSelectedValue(object2, true);
        } else if (!object3.isEmpty()) {
            this.list.setSelectedIndex(0);
        }
        this.addInstanceListeners();
        this.reloadHeader(this.classes);
        this.updateLabel();
    }

    private void reloadHeader(Collection collection) {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        Icon icon = null;
        for (Object object2 : collection) {
            if (icon == null) {
                icon = object2.getIcon();
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(object2.getName());
        }
        object2 = (JLabel)this.header.getComponent();
        ((JLabel)object2).setText(stringBuffer.toString());
        ((JLabel)object2).setIcon(icon);
    }

    private Collection getInstances(Cls cls) {
        Collection collection = this.showSubclassInstances ? cls.getInstances() : cls.getDirectInstances();
        if (!this.owlModel.getProject().getDisplayHiddenFrames()) {
            collection = AssertedInstancesListPanel.removeHiddenInstances(collection);
        }
        return collection;
    }

    private static Collection removeHiddenInstances(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            if (instance.isVisible()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public void sort() {
        this.list.setListenerNotificationEnabled(false);
        Object object = this.list.getSelectedValue();
        ArrayList arrayList = new ArrayList(this.getModel().getValues());
        if (arrayList.size() <= SORT_LIMIT) {
            Collections.sort(arrayList, new FrameComparator());
        }
        this.getModel().setValues(arrayList);
        this.list.setSelectedValue(object);
        this.list.setListenerNotificationEnabled(true);
    }

    public void setSelectedInstance(Instance instance) {
        this.list.setSelectedValue(instance, true);
        this.updateButtons();
    }

    private void updateButtons() {
        Cls cls = (Cls)CollectionUtilities.getFirstItem((Collection)this.classes);
        this.createAction.setEnabled(cls == null ? false : cls.isConcrete());
        this.createAnonymousAction.setEnabled(cls == null ? false : cls.isConcrete());
        Instance instance = (Instance)this.getSoleSelection();
        boolean bl = instance != null && instance instanceof SimpleInstance;
        this.copyAction.setAllowed(bl);
    }

    public void setShowDisplaySlotPanel(boolean bl) {
    }
}

