/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.importstree;

import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.swrl.ui.SWRLProjectPlugin;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.importstree.DownloadImportsAction;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTree;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTreeNode;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport.EmptyImportWizard;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AddedPrefixesTable;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportWizard;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class ImportsTreePanel
extends JPanel
implements HostResourceDisplay,
Disposable {
    private ImportsTree tree;
    private OWLOntology rootOntology;
    private AllowableAction createAddImportAction;
    private AllowableAction addEmptyImportAction;
    private AllowableAction removeImportAction;
    private AllowableAction setActiveOntologyAction;
    private Action downloadImportsAction;

    public ImportsTreePanel(OWLOntology oWLOntology) {
        this.rootOntology = oWLOntology;
        this.tree = new ImportsTree(oWLOntology);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Ontologies", new JScrollPane((Component)((Object)this.tree)));
        this.createAddImportAction = this.createAddImportAction();
        oWLLabeledComponent.addHeaderButton((Action)this.createAddImportAction);
        this.addEmptyImportAction = this.createAddEmptyImportAction();
        oWLLabeledComponent.addHeaderButton((Action)this.addEmptyImportAction);
        this.removeImportAction = this.createRemoveImportAction();
        oWLLabeledComponent.addHeaderButton((Action)this.removeImportAction);
        this.setActiveOntologyAction = this.createSetActiveOntologyAction();
        oWLLabeledComponent.addHeaderButton((Action)this.setActiveOntologyAction);
        this.downloadImportsAction = new DownloadImportsAction(this.tree);
        oWLLabeledComponent.addHeaderButton(this.downloadImportsAction);
        this.setLayout(new BorderLayout());
        this.add("North", (Component)this.createOntologyBrowserHeader());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
        this.setPreferredSize(new Dimension(250, 300));
    }

    private AllowableAction createAddEmptyImportAction() {
        return new AllowableAction("Create empty imported ontology...", OWLIcons.getCreateIcon("Import"), (Selectable)this.tree){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportsTreePanel.this.createImportedTripleStore();
            }

            public void onSelectionChange() {
                Collection collection = this.getSelection();
                RDFResource rDFResource = (RDFResource)CollectionUtilities.getFirstItem((Collection)collection);
                this.setAllowed(rDFResource != null && rDFResource instanceof OWLOntology && rDFResource.equals(OWLUtil.getActiveOntology(rDFResource.getOWLModel())) && ImportsTreePanel.this.isEnabled());
            }
        };
    }

    private AllowableAction createAddImportAction() {
        return new AllowableAction("Import ontology...", OWLIcons.getAddIcon("Import"), (Selectable)this.tree){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportsTreePanel.this.addImport();
            }

            public void onSelectionChange() {
                Collection collection = this.getSelection();
                RDFResource rDFResource = (RDFResource)CollectionUtilities.getFirstItem((Collection)collection);
                this.setAllowed(rDFResource != null && rDFResource instanceof OWLOntology && rDFResource.equals(OWLUtil.getActiveOntology(rDFResource.getOWLModel())) && ImportsTreePanel.this.isEnabled());
            }
        };
    }

    private AllowableAction createRemoveImportAction() {
        return new AllowableAction("Remove import", OWLIcons.getRemoveIcon("Import"), (Selectable)this.tree){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportsTreePanel.this.removeSelectedImport();
            }

            public void onSelectionChange() {
                this.setAllowed(ImportsTreePanel.this.tree.getSelectionCount() == 1 && ImportsTreePanel.this.tree.getSelectionRows()[0] != 0 && ImportsTreePanel.this.isEnabled());
            }
        };
    }

    private AllowableAction createSetActiveOntologyAction() {
        return new AllowableAction("Set active ontology", OWLIcons.getImageIcon("SelectActiveTripleStore"), (Selectable)this.tree){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportsTreePanel.this.setActiveOntology();
            }

            public void onSelectionChange() {
                Collection collection = this.getSelection();
                RDFResource rDFResource = (RDFResource)CollectionUtilities.getFirstItem((Collection)collection);
                this.setAllowed(collection.size() == 1 && rDFResource instanceof DefaultOWLOntology && !rDFResource.equals(OWLUtil.getActiveOntology(rDFResource.getOWLModel())) && ((DefaultOWLOntology)rDFResource).isAssociatedTriplestoreEditable() && ImportsTreePanel.this.isEnabled());
            }
        };
    }

    protected HeaderComponent createOntologyBrowserHeader() {
        String string = ProjectManager.getProjectManager().getCurrentProject().getName();
        JLabel jLabel = ComponentFactory.createLabel((String)string, (Icon)Icons.getProjectIcon(), (int)2);
        String string2 = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        String string3 = "Ontology Browser";
        HeaderComponent headerComponent = new HeaderComponent(string3, string2, (JComponent)jLabel);
        headerComponent.setColor(Colors.getFacetColor());
        return headerComponent;
    }

    public static void showDialog(OWLModel oWLModel) {
        OWLOntology oWLOntology = oWLModel.getDefaultOWLOntology();
        ImportsTreePanel importsTreePanel = new ImportsTreePanel(oWLOntology);
        Component component = ProtegeUI.getTopLevelContainer(oWLModel.getProject());
        ProtegeUI.getModalDialogFactory().showDialog(component, importsTreePanel, "owl:imports Between Ontologies", 14);
    }

    public boolean displayHostResource(RDFResource rDFResource) {
        return this.tree.displayHostResource(rDFResource);
    }

    public ImportsTree getImportsTree() {
        return this.tree;
    }

    private void addImport() {
        try {
            OWLModel oWLModel = this.rootOntology.getOWLModel();
            ImportWizard importWizard = new ImportWizard((JComponent)this, oWLModel);
            if (importWizard.execute() == 1) {
                ImportHelper importHelper = new ImportHelper((JenaOWLModel)oWLModel);
                ArrayList arrayList = new ArrayList(oWLModel.getNamespaceManager().getPrefixes());
                for (Object object : importWizard.getImportData().getImportEntries()) {
                    Repository repository = object.getRepositoryToAdd();
                    if (repository != null) {
                        oWLModel.getRepositoryManager().addProjectRepository(object.getRepository());
                    }
                    URI uRI = object.getOntologyURI();
                    importHelper.addImport(uRI);
                }
                importHelper.importOntologies();
                oWLModel.getNamespaceManager().setPrefix(ProtegeNames.NS, ProtegeNames.PROTEGE_PREFIX);
                ArrayList arrayList2 = new ArrayList(oWLModel.getNamespaceManager().getPrefixes());
                arrayList2.removeAll(arrayList);
                if (arrayList2.size() > 0) {
                    Object object;
                    object = ProtegeUI.getTopLevelContainer(oWLModel.getProject());
                    AddedPrefixesTable.showDialog((Component)object, oWLModel, arrayList2);
                }
                if (SWRLProjectPlugin.isSWRLImported(oWLModel)) {
                    SWRLProjectPlugin.adjustGUI(oWLModel.getProject());
                }
                ProtegeUI.reloadUI(oWLModel);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void removeSelectedImport() {
        RDFResource rDFResource = (RDFResource)CollectionUtilities.getFirstItem((Collection)this.tree.getSelectedResources());
        if (rDFResource != null && OWLUtil.confirmSaveAndReload(this.rootOntology.getProject())) {
            String string = rDFResource.getURI();
            TreePath treePath = this.tree.getSelectionModel().getSelectionPath();
            ImportsTreeNode importsTreeNode = (ImportsTreeNode)((Object)treePath.getParentPath().getLastPathComponent());
            OWLOntology oWLOntology = (OWLOntology)importsTreeNode.getUserObject();
            oWLOntology.removeImports(string);
            OWLUtil.saveAndReloadProject();
        }
    }

    private void createImportedTripleStore() {
        EmptyImportWizard emptyImportWizard = new EmptyImportWizard((JComponent)this, this.rootOntology.getOWLModel());
        emptyImportWizard.execute();
    }

    private void setActiveOntology() {
        OWLModel oWLModel;
        Collection collection = this.tree.getSelection();
        OWLOntology oWLOntology = (OWLOntology)CollectionUtilities.getFirstItem((Collection)collection);
        if (oWLOntology != OWLUtil.getActiveOntology(oWLModel = oWLOntology.getOWLModel())) {
            TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
            TripleStore tripleStore = tripleStoreModel.getHomeTripleStore(oWLOntology);
            TripleStoreUtil.switchTripleStore(oWLModel, tripleStore);
        }
    }

    public void dispose() {
        this.tree.dispose();
    }

    public void setEnabled(boolean bl) {
        this.createAddImportAction.setAllowed(bl);
        this.removeImportAction.setAllowed(bl);
        this.addEmptyImportAction.setAllowed(bl);
        this.setActiveOntologyAction.setAllowed(bl);
        this.downloadImportsAction.setEnabled(bl);
        super.setEnabled(bl);
    }
}

