/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.importstree;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFolderRepository;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTree;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class DownloadImportsAction
extends AbstractAction {
    private JFileChooser fileChooser = new JFileChooser();
    private ImportsTree tree;

    public DownloadImportsAction(ImportsTree importsTree) {
        super("Download ontologies to folder...", OWLIcons.getImageIcon("SaveInferred"));
        this.fileChooser.setFileSelectionMode(1);
        this.tree = importsTree;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fileChooser.showDialog((Component)((Object)this.tree), "Download") == 0) {
            File file = this.fileChooser.getSelectedFile();
            Set set = this.tree.getSelectedResources();
            String string = "";
            int n = 0;
            for (Object object : set) {
                String string2 = object.getURI();
                try {
                    String string3 = DownloadImportsAction.download(string2, file);
                    string = string + "Downloaded " + string2 + "  to " + string3 + "\n";
                    ++n;
                }
                catch (Exception exception) {
                    string = string + "Failed " + string2 + "\n  " + exception.toString();
                }
            }
            OWLModel oWLModel = this.tree.getRootOntology().getOWLModel();
            ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, string);
            if (n > 0) {
                string = "Would you like to add a project repository to redirect imports to these local copies?";
                if (ProtegeUI.getModalDialogFactory().showConfirmDialog((Component)((Object)this.tree), string, "Add project repository?")) {
                    Object object;
                    object = new LocalFolderRepository(file);
                    oWLModel.getRepositoryManager().addProjectRepository(0, (Repository)object);
                    ProtegeUI.getModalDialogFactory().showMessageDialog((Component)((Object)this.tree), "You should save and reload your project for the imports redirection to take effect.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String download(String string, File file) throws Exception {
        InputStream inputStream = null;
        try {
            int n;
            URL uRL = new URL(string);
            int n2 = string.lastIndexOf(47);
            if (n2 == string.length() - 1) {
                n2 = string.lastIndexOf(47, string.length() - 2);
            }
            String string2 = string.substring(n2 + 1);
            File file2 = new File(file, string2);
            inputStream = uRL.openStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = bufferedInputStream.read()) >= 0) {
                fileOutputStream.write(n);
            }
            fileOutputStream.close();
            String string3 = file2.toString();
            return string3;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

