/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.icons;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.ui.icons.OverlayIcon;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class OWLIcons {
    public static final String STYLE_DEFAULT = "Default";
    public static final String STYLE_MULTICOLORED = "Multicolored";
    public static final String STYLE_VARIABLE = OWLIcons.class.getName() + ".style";
    public static String style;
    private static int filterAdd;
    private static double filterFactor;
    private static Map inheritedMap;
    static final String OWL = "OWL";
    private static Map readOnlyMap;
    static Map theOWLIcons;
    public static final String ACCEPT = "Accept";
    public static final String ADD_OVERLAY = "AddOverlay";
    public static final String ADD_PROPERTY_TO_CLASS_FORM = "AddPropertyToClassForm";
    public static final String ANNOTATION_PROPERTY = "OWLAnnotationProperty";
    public static final String ANNOTATION = "Annotation";
    public static final String ANNOTATIONS = "Annotations";
    public static final String ANNOTATIONS_TABLE = "AnnotationsTable";
    public static final String ANONYMOUS_OWL_CLASS = "OWLAnonymousClass";
    public static final String ASSERT_FALSE = "AssertFalse";
    public static final String ASSERT_TRUE = "AssertTrue";
    public static final String CHECK_CONSISTENCY = "CheckConsistency";
    public static final String CLASS_FRAME = "ClassFrame";
    public static final String CLASS_MATRIX = "ClassMatrix";
    public static final String CLASSIFY = "Classify";
    public static final String CLASSIFY_INDIVIDUAL = "ClassifyIndividual";
    public static final String CLOSURE_CLOSED = "ClosureClosed";
    public static final String CLOSURE_OPEN = "ClosureOpen";
    public static final String CREATE_OVERLAY = "CreateOverlay";
    public static final String CREATE_IMPORTED_TRIPLESTORE = "CreateImportedTripleStore";
    public static final String DATATYPE_TRIPLE = "DatatypeTriple";
    public static final String DEFINED_OWL_CLASS = "DefinedOWLClass";
    public static final String DELETE = "Delete";
    public static final String DELETE_OVERLAY = "DeleteOverlay";
    public static final String ERROR = "Error";
    public static final String FILE = "File";
    public static final String FIND_ASSERTS = "FindAsserts";
    public static final String GET_INFERRED_SUBCLASSES = "GetInferredSubclasses";
    public static final String GET_INFERRED_SUPERCLASSES = "GetInferredSuperclasses";
    public static final String HELP_LOGO = "OWLHelp.png";
    public static final String IMPORT = "Import";
    public static final String LAYOUT_HORIZONTALLY = "LayoutHorizontally";
    public static final String LAYOUT_VERTICALLY = "LayoutVertically";
    public static final String OWL_ALL_VALUES_FROM = "OWLAllValuesFrom";
    public static final String OWL_ANNOTATION_PROPERTY_FRAME = "OWLAnnotationPropertyFrame";
    public static final String OWL_CARDINALITY = "OWLCardinality";
    public static final String OWL_COMPLEMENT_CLASS = "OWLComplementClass";
    public static final String OWL_DATATYPE_ANNOTATION_PROPERTY = "AnnotationOWLDatatypeProperty";
    public static final String OWL_DATATYPE_PROPERTY = "OWLDatatypeProperty";
    public static final String OWL_DATATYPE_PROPERTY_INHERITED = "OWLDatatypePropertyInherited";
    public static final String OWL_DISJOINT_CLASSES = "OWLDisjointClasses";
    public static final String OWL_ENUMERATED_CLASS = "OWLEnumeratedClass";
    public static final String OWL_EQUIVALENT_CLASS = "OWLEquivalentClass";
    public static final String OWL_HAS_VALUE = "OWLHasValue";
    public static final String OWL_INTERSECTION_CLASS = "OWLIntersectionClass";
    public static final String OWL_MAX_CARDINALITY = "OWLMaxCardinality";
    public static final String OWL_MIN_CARDINALITY = "OWLMinCardinality";
    public static final String OWL_OBJECT_ANNOTATION_PROPERTY = "AnnotationOWLObjectProperty";
    public static final String OWL_OBJECT_PROPERTY = "OWLObjectProperty";
    public static final String OWL_OBJECT_PROPERTY_INHERITED = "OWLObjectPropertyInherited";
    public static final String OWL_RESTRICTION = "OWLRestriction";
    public static final String OWL_SOME_VALUES_FROM = "OWLSomeValuesFrom";
    public static final String OWL_UNION_CLASS = "OWLUnionClass";
    public static final String PREFIX = "Prefix";
    public static final String PRIMITIVE_OWL_CLASS = "PrimitiveClass";
    public static final String PROPERTY_FRAME = "PropertyFrame";
    public static final String PROPERTY_MATRIX = "PropertyMatrix";
    public static final String RDF_DATATYPE = "RDFSDatatype";
    public static final String RDF_INDIVIDUAL = "RDFIndividual";
    public static final String RDF_ANON_INDIVIDUAL = "RDFAnonIndividual";
    public static final String RDF_INDIVIDUAL_FRAME = "RDFIndividualFrame";
    public static final String RDF_INDIVIDUALS = "RDFIndividuals";
    public static final String RDF_PROPERTY = "RDFProperty";
    public static final String RDF_PROPERTY_INHERITED = "RDFPropertyInherited";
    public static final String RDFS_METACLASS = "RDFSMetaclass";
    public static final String RDFS_NAMED_CLASS = "RDFSNamedClass";
    public static final String RDFS_RANGE = "RDFSRange";
    public static final String RDFS_SUBCLASS_OF = "RDFSSubclassOf";
    public static final String REFRESH = "Refresh";
    public static final String REMOVE_OVERLAY = "RemoveOverlay";
    public static final String SAVE_INFERRED = "SaveInferred";
    public static final String SELECT_ACTIVE_TRIPLESTORE = "SelectActiveTripleStore";
    public static final String SELECT_FILE = "SelectFile";
    public static final String SHOW_EXPLORER = "ShowExplorer";
    public static final String SIBLING_CLASS = "SiblingClass";
    public static final String SOURCE_CODE = "SourceCode";
    public static final String SPARQL = "SPARQL";
    public static final String SPARQL_RESULTS_PANEL = "SPARQLResultsPanel";
    public static final String SUB_CLASS = "SubClass";
    public static final String SUPERCLASS_EXPLORER = "SuperclassExplorer";
    public static final String TEST = "Test";
    public static final String TEST_SETTINGS = "TestSettings";
    public static final String TODO = "Todo";
    public static final String TOP = "Top";
    public static final String TRIPLE = "Triple";
    public static final String TRIPLES = "Triples";
    public static final String VIEW = "View";
    public static final String VIEW_OVERLAY = "ViewOverlay";
    public static final String XSD_DATATYPE = "XSDDatatype";
    public static final String XSD_MAX_EXCLUSIVE = "XSDMaxExclusive";
    public static final String XSD_MAX_INCLUSIVE = "XSDMaxInclusive";
    public static final String XSD_MIN_EXCLUSIVE = "XSDMinExclusive";
    public static final String XSD_MIN_INCLUSIVE = "XSDMinInclusive";

    public static Icon getAddIcon() {
        return OWLIcons.getImageIcon("Add");
    }

    public static Icon getAddIcon(String string) {
        return OWLIcons.getAddIcon(string, OWLIcons.class);
    }

    public static Icon getAddIcon(String string, Class clazz) {
        return new OverlayIcon(string, 5, 4, ADD_OVERLAY, 12, 12, clazz);
    }

    public static Icon getAllRestrictionIcon() {
        return OWLIcons.getImageIcon(OWL_ALL_VALUES_FROM);
    }

    public static ImageIcon getArchiveProjectIcon() {
        return OWLIcons.getImageIcon("ArchiveProject");
    }

    public static Icon getAssertChangeIcon() {
        return OWLIcons.getImageIcon("AssertChange");
    }

    public static Icon getBackspaceIcon() {
        return OWLIcons.getImageIcon("Backspace");
    }

    public static Icon getCheckConsistencyIcon() {
        return OWLIcons.getImageIcon(CHECK_CONSISTENCY);
    }

    public static Icon getClassifyIcon() {
        return OWLIcons.getImageIcon(CLASSIFY);
    }

    public static Icon getClassifyIndividualIcon() {
        return OWLIcons.getImageIcon(CLASSIFY_INDIVIDUAL);
    }

    public static Icon getCloseIcon() {
        return OWLIcons.getImageIcon("Close");
    }

    public static Icon getClassesIcon() {
        return OWLIcons.getImageIcon("Classes");
    }

    public static Icon getComputeSingleInferredTypesIcon() {
        return OWLIcons.getImageIcon("ComputeSingleInferredTypes");
    }

    public static Icon getComputeIndividualsBelongingToClassIcon() {
        return OWLIcons.getImageIcon("ComputeIndividualsBelongingToClass");
    }

    public static Icon getCopyIcon() {
        return OWLIcons.getImageIcon("Copy");
    }

    public static Icon getCreateIcon(String string) {
        return OWLIcons.getCreateIcon(string, OWLIcons.class);
    }

    public static Icon getCreateIcon(String string, int n) {
        return OWLIcons.getCreateIcon(string, n, OWLIcons.class);
    }

    public static Icon getCreateIcon(String string, Class clazz) {
        return new OverlayIcon(string, 5, 4, CREATE_OVERLAY, 13, 1, clazz);
    }

    public static Icon getCreateIcon(String string, int n, Class clazz) {
        return new OverlayIcon(string, 5, 4, CREATE_OVERLAY, 13, n, clazz);
    }

    public static Icon getCreateIndividualIcon(String string) {
        if (OWLIcons.isDefaultStyle()) {
            return new OverlayIcon(string, 5, 4, CREATE_OVERLAY, 11, 3, OWLIcons.class);
        }
        return new OverlayIcon(string, 5, 4, CREATE_OVERLAY, 12, 2, OWLIcons.class);
    }

    public static Icon getCreatePropertyIcon(String string) {
        return OWLIcons.getCreateIcon(string, OWLIcons.isDefaultStyle() ? 2 : 1);
    }

    public static Icon getCutIcon() {
        return OWLIcons.getImageIcon("Cut");
    }

    public static Icon getDefinedClsIcon() {
        return OWLIcons.getImageIcon(DEFINED_OWL_CLASS);
    }

    public static Icon getDeleteIcon() {
        return OWLIcons.getImageIcon(DELETE);
    }

    public static Icon getDeleteClsIcon() {
        return OWLIcons.getDeleteIcon(PRIMITIVE_OWL_CLASS);
    }

    public static Icon getDeleteIcon(String string) {
        return OWLIcons.getDeleteIcon(string, OWLIcons.class);
    }

    public static Icon getDeleteIcon(String string, Class clazz) {
        return new OverlayIcon(string, 5, 5, DELETE_OVERLAY, 4, 4, clazz);
    }

    public static Icon getDeprecatedIcon() {
        return OWLIcons.getImageIcon("Deprecated");
    }

    public static Icon getDisplayChangedClassesIcon() {
        return OWLIcons.getImageIcon("DisplayChangedClasses");
    }

    public static ImageIcon getDownIcon() {
        return OWLIcons.getImageIcon("Down");
    }

    public static Icon getEditHTMLIcon() {
        return OWLIcons.getImageIcon("EditHTML");
    }

    public static Icon getEquivalentClassIcon() {
        return OWLIcons.getImageIcon(OWL_EQUIVALENT_CLASS);
    }

    public static ImageIcon getExternalResourceIcon() {
        return OWLIcons.getImageIcon("ExternalResource");
    }

    private static Icon getFilteredIcon(ImageFilter imageFilter, ImageIcon imageIcon, String string) {
        Image image = imageIcon.getImage();
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        Image image3 = OWLIcons.getImageIcon(string).getImage();
        return new OverlayIcon(image2, 0, 0, image3, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
    }

    public static Icon getFindUsageIcon() {
        return OWLIcons.getImageIcon("FindUsage");
    }

    public static ImageIcon getImageIcon(String string) {
        return OWLIcons.getImageIcon(string, OWLIcons.class);
    }

    public static ImageIcon getImageIcon(String string, Class clazz) {
        ImageIcon imageIcon = (ImageIcon)theOWLIcons.get(string);
        if (imageIcon == null || imageIcon.getIconWidth() == -1) {
            String string2 = string;
            if (string.lastIndexOf(46) < 0) {
                string2 = string2 + ".gif";
            }
            if (imageIcon == null) {
                imageIcon = OWLIcons.loadImageIcon(clazz, string2);
            }
            if (imageIcon == null && !string.equals("Ugly")) {
                imageIcon = OWLIcons.getImageIcon("Ugly");
            }
            theOWLIcons.put(string, imageIcon);
        }
        return imageIcon;
    }

    public static Icon getInheritedClsIcon(ImageIcon imageIcon) {
        return OWLIcons.getInheritedIcon(imageIcon, CLASS_FRAME);
    }

    public static Icon getInheritedIcon(ImageIcon imageIcon, String string) {
        Icon icon = (Icon)inheritedMap.get(imageIcon);
        if (icon == null) {
            RGBImageFilter rGBImageFilter = OWLIcons.isMulticoloredStyle() ? new InheritedColorfulFilter() : new DefaultReadOnlyFilter(1.0, 26, 46, 94);
            icon = OWLIcons.getFilteredIcon(rGBImageFilter, imageIcon, string);
            inheritedMap.put(imageIcon, icon);
        }
        return icon;
    }

    public static Icon getInheritedPropertyIcon(ImageIcon imageIcon) {
        return OWLIcons.getInheritedIcon(imageIcon, PROPERTY_FRAME);
    }

    public static URL getImageURL(Class clazz, String string) {
        if (string.lastIndexOf(".") < 0) {
            string = string + ".gif";
        }
        String[] stringArray = new String[]{style + "/" + string, "Multicolored/" + string, string};
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            URL uRL = clazz.getResource(string2);
            if (uRL == null) continue;
            return uRL;
        }
        System.err.println("[OWLIcons] Error: Could not find icon Multicolored" + string);
        return null;
    }

    public static ImageIcon getMetaclassIcon() {
        return OWLIcons.getImageIcon(RDFS_METACLASS);
    }

    public static Icon getNavigateBackIcon() {
        return OWLIcons.getImageIcon("NavigateBack");
    }

    public static Icon getNavigateForwardIcon() {
        return OWLIcons.getImageIcon("NavigateForward");
    }

    public static Icon getNerdErrorIcon() {
        return OWLIcons.getImageIcon(ERROR);
    }

    public static Icon getNerdSmilingIcon() {
        return OWLIcons.getImageIcon(ACCEPT);
    }

    public static Icon getOpenProjectIcon() {
        return OWLIcons.getImageIcon("OpenProject");
    }

    public static Icon getOWLIcon() {
        return OWLIcons.getImageIcon(OWL);
    }

    public static Icon getOWLTestErrorIcon() {
        return OWLIcons.getImageIcon("TestError");
    }

    public static Icon getOWLFullIcon() {
        return OWLIcons.getImageIcon("OWLFull");
    }

    public static Icon getOWLTestWarningIcon() {
        return OWLIcons.getImageIcon("TestWarning");
    }

    public static Icon getPasteIcon() {
        return OWLIcons.getImageIcon("Paste");
    }

    public static Icon getPreferencesIcon() {
        return OWLIcons.getImageIcon("Preferences");
    }

    public static Icon getPrimitiveClsIcon() {
        return OWLIcons.getImageIcon(PRIMITIVE_OWL_CLASS);
    }

    public static Icon getPropertiesIcon() {
        return OWLIcons.getImageIcon("Properties");
    }

    public static Icon getReadOnlyAnnotationPropertyIcon(ImageIcon imageIcon) {
        return OWLIcons.getReadOnlyIcon(imageIcon, OWL_ANNOTATION_PROPERTY_FRAME);
    }

    public static Icon getReadOnlyIcon(ImageIcon imageIcon, String string) {
        Icon icon = (Icon)readOnlyMap.get(imageIcon);
        if (icon == null) {
            MulticoloredReadOnlyFilter multicoloredReadOnlyFilter = new MulticoloredReadOnlyFilter();
            icon = OWLIcons.getFilteredIcon(multicoloredReadOnlyFilter, imageIcon, string);
            readOnlyMap.put(imageIcon, icon);
        }
        return icon;
    }

    public static Icon getDefaultReadOnlyIcon(ImageIcon imageIcon, String string, int n, int n2, int n3) {
        Icon icon = (Icon)readOnlyMap.get(imageIcon);
        if (icon == null) {
            DefaultReadOnlyFilter defaultReadOnlyFilter = new DefaultReadOnlyFilter(1.0, 24, 42, 90);
            icon = OWLIcons.getFilteredIcon(defaultReadOnlyFilter, imageIcon, string);
            readOnlyMap.put(imageIcon, icon);
        }
        return icon;
    }

    public static Icon getReadOnlyClsIcon(ImageIcon imageIcon) {
        return OWLIcons.isDefaultStyle() ? OWLIcons.getDefaultReadOnlyIcon(imageIcon, CLASS_FRAME, 30, 30, 80) : OWLIcons.getReadOnlyIcon(imageIcon, CLASS_FRAME);
    }

    public static Icon getReadOnlyIndividualIcon(ImageIcon imageIcon) {
        return OWLIcons.getReadOnlyIcon(imageIcon, RDF_INDIVIDUAL_FRAME);
    }

    public static Icon getReadOnlyPropertyIcon(ImageIcon imageIcon) {
        return OWLIcons.getReadOnlyIcon(imageIcon, PROPERTY_FRAME);
    }

    public static Icon getRedoIcon() {
        return OWLIcons.getImageIcon("Redo");
    }

    public static Icon getRemoveIcon() {
        return OWLIcons.getImageIcon("Remove");
    }

    public static Icon getRemoveIcon(String string) {
        return new OverlayIcon(string, 5, 4, REMOVE_OVERLAY, 14, 13);
    }

    public static ImageIcon getRevertProjectIcon() {
        return OWLIcons.getImageIcon("RevertProject");
    }

    public static Icon getSaveInferredIcon() {
        return OWLIcons.getImageIcon(SAVE_INFERRED);
    }

    public static Icon getSaveProjectIcon() {
        return OWLIcons.getImageIcon("SaveProject");
    }

    public static Icon getTestIcon() {
        return OWLIcons.getImageIcon(TEST);
    }

    public static Icon getTestSettingsIcon() {
        return OWLIcons.getImageIcon(TEST_SETTINGS);
    }

    public static Icon getTODOIcon() {
        return OWLIcons.getImageIcon(TODO);
    }

    public static ImageIcon getUpIcon() {
        return OWLIcons.getImageIcon("Up");
    }

    public static Icon getUndoIcon() {
        return OWLIcons.getImageIcon("Undo");
    }

    public static Icon getViewIcon() {
        return OWLIcons.getImageIcon(VIEW);
    }

    public static Icon getViewIcon(String string) {
        return OWLIcons.getViewIcon(string, OWLIcons.class);
    }

    public static Icon getViewIcon(String string, Class clazz) {
        return new OverlayIcon(string, 4, 4, VIEW_OVERLAY, 11, 11, clazz);
    }

    public static Icon getSuperclassesIcon() {
        return OWLIcons.getImageIcon(RDFS_SUBCLASS_OF);
    }

    public static boolean isMulticoloredStyle() {
        return STYLE_MULTICOLORED.equals(style);
    }

    public static boolean isDefaultStyle() {
        return STYLE_DEFAULT.equals(style);
    }

    static ImageIcon loadImageIcon(Class clazz, String string) {
        URL uRL = OWLIcons.getImageURL(clazz, string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            if (imageIcon.getIconWidth() == -1) {
                Log.getLogger().severe("[OWLIcons] Failed to load " + string);
            }
            return imageIcon;
        }
        return null;
    }

    public static void setStyle(String string) {
        style = string;
        theOWLIcons.clear();
        inheritedMap.clear();
        readOnlyMap.clear();
        filterFactor = OWLIcons.isDefaultStyle() ? 1.0 : 1.3;
        filterAdd = OWLIcons.isDefaultStyle() ? 50 : 80;
    }

    static {
        filterAdd = 80;
        filterFactor = 1.3;
        inheritedMap = new HashMap();
        readOnlyMap = new HashMap();
        theOWLIcons = new HashMap();
        OWLIcons.setStyle(ApplicationProperties.getString((String)STYLE_VARIABLE, (String)STYLE_DEFAULT));
    }

    public static class DefaultReadOnlyFilter
    extends RGBImageFilter {
        private int ar;
        private int ag;
        private int ab;
        private double factor;

        public DefaultReadOnlyFilter(double d, int n, int n2, int n3) {
            this.factor = d;
            this.ar = n;
            this.ag = n2;
            this.ab = n3;
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = (n3 & 0xFF0000) >> 16;
            int n5 = (n3 & 0xFF00) >> 8;
            int n6 = n3 & 0xFF;
            if ((n4 = (int)((double)n4 * this.factor)) > 255) {
                n4 = 255;
            }
            if ((n5 = (int)((double)n5 * this.factor)) > 255) {
                n5 = 255;
            }
            if ((n6 = (int)((double)n6 * this.factor)) > 255) {
                n6 = 255;
            }
            n4 = Math.min(255, n4 + this.ar);
            n5 = Math.min(255, n5 + this.ag);
            n6 = Math.min(255, n6 + this.ab);
            return n3 & 0xFF000000 | n4 << 16 | n5 << 8 | n6;
        }
    }

    public static class MulticoloredReadOnlyFilter
    extends RGBImageFilter {
        public int filterRGB(int n, int n2, int n3) {
            int n4 = (n3 & 0xFF0000) >> 16;
            int n5 = (n3 & 0xFF00) >> 8;
            int n6 = n3 & 0xFF;
            if ((n4 = (int)((double)n4 * filterFactor)) > 255) {
                n4 = 255;
            }
            if ((n5 = (int)((double)n5 * filterFactor)) > 255) {
                n5 = 255;
            }
            if ((n6 = (int)((double)n6 * filterFactor)) > 255) {
                n6 = 255;
            }
            int n7 = filterAdd;
            n4 = Math.min(255, n4 + n7);
            n5 = Math.min(255, n5 + n7);
            n6 = Math.min(255, n6 + n7);
            return n3 & 0xFF000000 | n4 << 16 | n5 << 8 | n6;
        }
    }

    public static class InheritedColorfulFilter
    extends RGBImageFilter {
        public int filterRGB(int n, int n2, int n3) {
            if ((n3 & 0xFFFFFF) == 0) {
                return n3;
            }
            return n3 & 0xFF000000 | 0xFFFFFF;
        }
    }
}

