/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.forms;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.forms.FormsNames;
import edu.stanford.smi.protegex.owl.ui.forms.ProtegeFormsNames;

public class OWLWidgetPropertyListUtil {
    public static final String GRAPHWIDGET_JAVA_CLASS_NAME = "edu.stanford.smi.protegex.widget.graph.GraphWidget";
    public static final String GRAPHWIDGET_NAME_SEPARATOR = "_";
    public static final String GRAPHWIDGET_REIFIED_RELATIONSHIP_PROPERTY_NAME = "slotForRelations";

    public static Resource createOWLPropertyList(OWLModel oWLModel, Resource resource, PropertyList propertyList) {
        if (propertyList == null || propertyList.getNames().size() == 0) {
            return null;
        }
        Resource resource2 = resource.getModel().createResource(null, (Resource)FormsNames.PropertyList);
        resource.addProperty((Property)FormsNames.property_list, (RDFNode)resource2);
        for (String string : propertyList.getNames()) {
            OWLWidgetPropertyListUtil.createOWLPropertyList(oWLModel, resource, propertyList, string, resource2);
        }
        return resource2;
    }

    private static void createOWLPropertyList(OWLModel oWLModel, Resource resource, PropertyList propertyList, String string, Resource resource2) {
        Statement statement = resource.getProperty((Property)ProtegeFormsNames.javaClassName);
        String string2 = null;
        if (statement != null) {
            string2 = statement.getString();
        }
        String string3 = propertyList.getString(string);
        if (string.equals(GRAPHWIDGET_REIFIED_RELATIONSHIP_PROPERTY_NAME)) {
            Resource resource3 = resource2.getModel().createResource(null, (Resource)FormsNames.String);
            resource3.addProperty((Property)FormsNames.name, string);
            resource3.addProperty((Property)FormsNames.string_value, OWLWidgetPropertyListUtil.getAbsoluteReifiedRelationshipValue(oWLModel, string3));
            resource2.addProperty((Property)FormsNames.properties, (RDFNode)resource3);
            return;
        }
        if (string3 != null) {
            Resource resource4 = resource2.getModel().createResource(null, (Resource)FormsNames.String);
            resource4.addProperty((Property)FormsNames.name, OWLWidgetPropertyListUtil.getAbsoluteWidgetPropertyName(oWLModel, string, string2));
            resource4.addProperty((Property)FormsNames.string_value, string3);
            resource2.addProperty((Property)FormsNames.properties, (RDFNode)resource4);
            return;
        }
        Integer n = propertyList.getInteger(string);
        if (n != null) {
            Resource resource5 = resource2.getModel().createResource(null, (Resource)FormsNames.Integer);
            resource5.addProperty((Property)FormsNames.name, OWLWidgetPropertyListUtil.getAbsoluteWidgetPropertyName(oWLModel, string, string2));
            resource5.addProperty((Property)FormsNames.integer_value, (RDFNode)resource5.getModel().createLiteral((long)n.intValue()));
            resource2.addProperty((Property)FormsNames.properties, (RDFNode)resource5);
            return;
        }
        Boolean bl = propertyList.getBoolean(string);
        if (bl != null) {
            Resource resource6 = resource2.getModel().createResource(null, (Resource)FormsNames.Boolean);
            resource6.addProperty((Property)FormsNames.name, OWLWidgetPropertyListUtil.getAbsoluteWidgetPropertyName(oWLModel, string, string2));
            resource6.addProperty((Property)FormsNames.booleanValue, (RDFNode)resource6.getModel().createLiteral(bl.booleanValue()));
            resource2.addProperty((Property)FormsNames.properties, (RDFNode)resource6);
            return;
        }
        PropertyList propertyList2 = propertyList.getPropertyList(string);
        if (propertyList2 != null) {
            Resource resource7 = resource2.getModel().createResource(null, (Resource)FormsNames.PropertyList);
            resource7.addProperty((Property)FormsNames.name, OWLWidgetPropertyListUtil.getAbsoluteWidgetPropertyName(oWLModel, string, string2));
            Resource resource8 = OWLWidgetPropertyListUtil.createOWLPropertyList(oWLModel, resource7, propertyList2);
            if (resource8 != null) {
                resource7.addProperty((Property)FormsNames.property_list, (RDFNode)resource8);
            }
            resource2.addProperty((Property)FormsNames.properties, (RDFNode)resource7);
            return;
        }
    }

    private static String getAbsoluteWidgetPropertyName(OWLModel oWLModel, String string, String string2) {
        if (string2 == null || !string2.equals(GRAPHWIDGET_JAVA_CLASS_NAME)) {
            return string;
        }
        int n = string.lastIndexOf(GRAPHWIDGET_NAME_SEPARATOR);
        if (n == -1 || n == string.length()) {
            return string;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n);
        String string5 = null;
        try {
            string5 = oWLModel.getURIForResourceName(string3);
        }
        catch (Exception exception) {
            return string;
        }
        return string5 == null ? string : string5 + string4;
    }

    public static void loadFormsProperties(OWLModel oWLModel, SlotWidget slotWidget, Resource resource) {
        Statement statement = resource.getProperty((Property)FormsNames.property_list);
        if (statement == null) {
            return;
        }
        Resource resource2 = statement.getResource();
        if (resource2 == null) {
            return;
        }
        StmtIterator stmtIterator = resource2.listProperties((Property)FormsNames.properties);
        while (stmtIterator.hasNext()) {
            Statement statement2 = stmtIterator.nextStatement();
            OWLWidgetPropertyListUtil.loadFormProperties(oWLModel, slotWidget, resource, statement2.getResource());
        }
    }

    private static void loadFormProperties(OWLModel oWLModel, SlotWidget slotWidget, Resource resource, Resource resource2) {
        Statement statement;
        Statement statement2;
        if (resource2 == null) {
            return;
        }
        Statement statement3 = resource2.getProperty(RDF.type);
        if (statement3 == null) {
            return;
        }
        Resource resource3 = statement3.getResource();
        Statement statement4 = resource.getProperty((Property)ProtegeFormsNames.javaClassName);
        String string = null;
        if (statement4 != null) {
            string = statement4.getString();
        }
        if (resource3.equals(FormsNames.String) && (statement2 = resource2.getProperty((Property)FormsNames.name)) != null && (statement = resource2.getProperty((Property)FormsNames.string_value)) != null) {
            if (statement2.getString().equals(GRAPHWIDGET_REIFIED_RELATIONSHIP_PROPERTY_NAME)) {
                slotWidget.getDescriptor().getPropertyList().setString(statement2.getString(), OWLWidgetPropertyListUtil.getLocalReifiedRelationshipValue(oWLModel, statement.getString()));
            } else {
                slotWidget.getDescriptor().getPropertyList().setString(OWLWidgetPropertyListUtil.getLocalWidgetPropertyName(oWLModel, statement2.getString(), string), statement.getString());
            }
            return;
        }
        if (resource3.equals(FormsNames.Integer) && (statement2 = resource2.getProperty((Property)FormsNames.name)) != null && (statement = resource2.getProperty((Property)FormsNames.integer_value)) != null) {
            slotWidget.getDescriptor().getPropertyList().setInteger(OWLWidgetPropertyListUtil.getLocalWidgetPropertyName(oWLModel, statement2.getString(), string), statement.getInt());
            return;
        }
        if (resource3.equals(FormsNames.Boolean) && (statement2 = resource2.getProperty((Property)FormsNames.name)) != null && (statement = resource2.getProperty((Property)FormsNames.booleanValue)) != null) {
            slotWidget.getDescriptor().getPropertyList().setBoolean(OWLWidgetPropertyListUtil.getLocalWidgetPropertyName(oWLModel, statement2.getString(), string), statement.getBoolean());
            return;
        }
    }

    private static String getLocalWidgetPropertyName(OWLModel oWLModel, String string, String string2) {
        if (string2 == null || !string2.equals(GRAPHWIDGET_JAVA_CLASS_NAME)) {
            return string;
        }
        int n = string.lastIndexOf(GRAPHWIDGET_NAME_SEPARATOR);
        if (n == -1 || n == string.length()) {
            return string;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n);
        String string5 = null;
        try {
            string5 = oWLModel.getResourceNameForURI(string3);
        }
        catch (Exception exception) {
            return string;
        }
        return string5 == null ? string : string5 + string4;
    }

    private static String getAbsoluteReifiedRelationshipValue(OWLModel oWLModel, String string) {
        String string2 = string;
        try {
            string2 = oWLModel.getURIForResourceName(string);
        }
        catch (Exception exception) {
            return string2;
        }
        return string2;
    }

    private static String getLocalReifiedRelationshipValue(OWLModel oWLModel, String string) {
        String string2 = string;
        try {
            string2 = oWLModel.getResourceNameForURI(string);
        }
        catch (Exception exception) {
            return string2;
        }
        return string2;
    }
}

