/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.forms;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFolderRepository;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteFormsGenerator;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteLayoutNames;
import edu.stanford.smi.protegex.owl.ui.forms.FormsNames;
import edu.stanford.smi.protegex.owl.ui.forms.OWLWidgetPropertyListUtil;
import edu.stanford.smi.protegex.owl.ui.forms.ProtegeFormsNames;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public class AbsoluteFormsLoader {
    private OWLModel owlModel;
    private Project project;

    public AbsoluteFormsLoader(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.project = oWLModel.getProject();
    }

    public void load(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        this.load(inputStream);
    }

    public void load(InputStream inputStream) throws IOException {
        OntDocumentManager ontDocumentManager;
        OntModel ontModel = ModelFactory.createOntologyModel();
        String string = null;
        if (ProtegeOWL.getPluginFolder().exists()) {
            try {
                string = ProtegeOWL.getPluginFolder().getAbsoluteFile().toURI().toString();
            }
            catch (Exception exception) {
                Log.getLogger().warning("Error at retrieving Protege OWL plugin folder. Expected to be at: " + ProtegeOWL.getPluginFolder().getAbsoluteFile());
            }
        }
        if (string != null) {
            ontDocumentManager = ontModel.getDocumentManager();
            ontDocumentManager.addAltEntry("http://www.owl-ontologies.com/forms/protege.owl", string + File.separator + "protegeForms.owl");
            ontDocumentManager.addAltEntry("http://www.owl-ontologies.com/forms/absolute.owl", string + File.separator + "absolute.owl");
            ontDocumentManager.addAltEntry("http://www.owl-ontologies.com/forms/forms.owl", string + File.separator + "forms.owl");
        }
        ontModel.read(inputStream, "http://dummy.de/aldi.owl", "RDF/XML-ABBREV");
        inputStream.close();
        ontModel.add((Resource)FormsNames.FormWidget, RDF.type, (RDFNode)OWL.Class);
        ontDocumentManager = ontModel.getOntClass(FormsNames.FormWidget.getURI());
        ExtendedIterator extendedIterator = ontDocumentManager.listInstances();
        while (extendedIterator.hasNext()) {
            Resource resource = (Resource)extendedIterator.next();
            this.addFormWidget(resource);
        }
        this.project.clearCachedWidgets();
    }

    public void loadAll() throws Exception {
        File file = new File(ProtegeOWL.getPluginFolder(), "protege-system.forms");
        if (file.exists()) {
            Log.getLogger().info("Loading system forms from " + file);
            this.load(new FileInputStream(file));
        }
        ArrayList arrayList = new ArrayList();
        this.loadRecursive(this.owlModel.getDefaultOWLOntology(), arrayList);
        if (!arrayList.contains(this.owlModel.getDefaultOWLOntology().getURI())) {
            this.loadForm(this.owlModel.getTripleStoreModel().getTopTripleStore());
        }
    }

    private void loadRecursive(OWLOntology oWLOntology, Collection collection) {
        collection.add(oWLOntology.getURI());
        Collection collection2 = oWLOntology.getImportResources();
        for (Object e : collection2) {
            if (e instanceof OWLOntology) {
                if (collection.contains(((OWLOntology)e).getURI())) continue;
                this.loadRecursive((OWLOntology)e, collection);
                continue;
            }
            Log.getLogger().warning("Imported ontology not found: " + e);
        }
        try {
            TripleStore tripleStore = this.owlModel.getTripleStoreModel().getTripleStore(oWLOntology.getURI());
            this.loadForm(tripleStore);
        }
        catch (Exception exception) {
            Log.getLogger().warning("Absolute forms not found.");
        }
    }

    private void addFormWidget(Resource resource) {
        Cls cls;
        String string;
        String string2;
        Statement statement = resource.getProperty((Property)FormsNames.forClass);
        if (statement != null && (string2 = this.owlModel.getResourceNameForURI(string = statement.getResource().getURI())) != null && (cls = this.project.getKnowledgeBase().getCls(string2)) != null) {
            ClsWidget clsWidget = this.project.getDesignTimeClsWidget(cls);
            this.resetClsWidgetForm(cls);
            WidgetDescriptor widgetDescriptor = clsWidget.getDescriptor();
            widgetDescriptor.setDirectlyCustomizedByUser(true);
            PropertyList propertyList = widgetDescriptor.getPropertyList();
            StmtIterator stmtIterator = resource.listProperties((Property)FormsNames.widgets);
            while (stmtIterator.hasNext()) {
                Statement statement2 = stmtIterator.nextStatement();
                if (statement2.getResource() == null) continue;
                Resource resource2 = statement2.getResource();
                this.addFormWidget(clsWidget, resource2);
            }
        }
    }

    private void addFormWidget(ClsWidget clsWidget, Resource resource) {
        String string;
        String string2;
        Statement statement = resource.getProperty((Property)FormsNames.forProperty);
        String string3 = null;
        if (statement != null) {
            string2 = statement.getResource().getURI();
            string = this.owlModel.getResourceNameForURI(string2);
            if (string != null && this.owlModel.getRDFResource(string) instanceof RDFProperty) {
                string3 = string;
            }
        } else {
            string2 = resource.getProperty(RDFS.comment);
            string3 = string2 != null ? string2.getString() : ProtegeNames.Slot.INFERRED_TYPE;
        }
        if (string3 != null) {
            string2 = this.project.getKnowledgeBase().getSlot(string3);
            string = this.getWidgetClassName(resource);
            if (string != null) {
                clsWidget.replaceWidget((Slot)string2, string);
                SlotWidget slotWidget = clsWidget.getSlotWidget((Slot)string2);
                this.setWidgetBounds(slotWidget.getDescriptor(), resource);
                OWLWidgetPropertyListUtil.loadFormsProperties(this.owlModel, slotWidget, resource);
            }
        }
    }

    private void resetClsWidgetForm(Cls cls) {
        ClsWidget clsWidget = this.project.getDesignTimeClsWidget(cls);
        if (clsWidget == null) {
            return;
        }
        for (Slot slot : cls.getTemplateSlots()) {
            try {
                SlotWidget slotWidget = clsWidget.getSlotWidget(slot);
                if (slotWidget == null) continue;
                clsWidget.replaceWidget(slot, null);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Couldn't remove slot widget for slot " + slot + " from class form " + cls);
            }
        }
    }

    private int getInt(Resource resource, Property property) {
        Statement statement = resource.getProperty(property);
        if (statement != null) {
            return statement.getInt();
        }
        return 0;
    }

    private String getWidgetClassName(Resource resource) {
        Statement statement = resource.getProperty(RDF.type);
        if (statement != null) {
            Resource resource2 = statement.getResource();
            Statement statement2 = resource2.getProperty((Property)ProtegeFormsNames.javaClassName);
            if (statement2 == null) {
                statement2 = resource.getProperty((Property)ProtegeFormsNames.javaClassName);
            }
            if (statement2 != null) {
                return statement2.getString();
            }
        }
        return null;
    }

    private void setWidgetBounds(WidgetDescriptor widgetDescriptor, Resource resource) {
        StmtIterator stmtIterator = resource.listProperties((Property)FormsNames.layoutData);
        while (stmtIterator.hasNext()) {
            Resource resource2;
            Statement statement = (Statement)stmtIterator.next();
            if (statement.getResource() == null || !(resource2 = statement.getResource()).hasProperty(RDF.type, (RDFNode)AbsoluteLayoutNames.AbsoluteLayoutData)) continue;
            int n = this.getInt(resource2, (Property)AbsoluteLayoutNames.x);
            int n2 = this.getInt(resource2, (Property)AbsoluteLayoutNames.y);
            int n3 = this.getInt(resource2, (Property)AbsoluteLayoutNames.width);
            int n4 = this.getInt(resource2, (Property)AbsoluteLayoutNames.height);
            widgetDescriptor.setBounds(new Rectangle(n, n2, n3, n4));
        }
    }

    public static void main(String[] stringArray) throws Exception {
        JenaOWLModel jenaOWLModel = ProtegeOWL.createJenaOWLModelFromInputStream(new FileInputStream("/work/protege/projects/test_forms_owl/imported.owl"));
        AbsoluteFormsLoader absoluteFormsLoader = new AbsoluteFormsLoader(jenaOWLModel);
        absoluteFormsLoader.load(new File("/work/protege/projects/test_forms_owl/imported.owl.forms").toURL());
    }

    public static boolean useNewFormMechanism_DontUseThisMethod() {
        return ApplicationProperties.getBooleanProperty((String)"NewOWLFormsMechanism", (boolean)false);
    }

    private void loadForm(TripleStore tripleStore) throws Exception {
        String string;
        URI uRI;
        File file;
        String string2;
        Object object;
        Comparable<URI> comparable;
        URI uRI2;
        if (tripleStore == null) {
            return;
        }
        if (tripleStore == this.owlModel.getTripleStoreModel().getTopTripleStore() && (uRI2 = OWLUtil.getOWLFileURI(this.owlModel)) != null && ((File)(comparable = new File(new URI((String)(object = uRI2.toString() + ".forms"))))).exists()) {
            Log.getLogger().info("Loading forms from " + comparable);
            this.load(new FileInputStream((File)comparable));
            return;
        }
        uRI2 = new URI(AbsoluteFormsGenerator.getFormsFileURI(tripleStore, this.owlModel));
        object = this.owlModel.getRepositoryManager().getRepository(uRI2);
        if (object != null && object.contains(uRI2)) {
            Log.getLogger().info("Loading forms from " + uRI2);
            this.load(object.getInputStream(uRI2));
            return;
        }
        comparable = new URI(tripleStore.getName());
        Repository repository = this.owlModel.getRepositoryManager().getRepository((URI)comparable);
        if (repository != null && repository instanceof LocalFolderRepository && (string2 = repository.getOntologyLocationDescription((URI)comparable)) != null && (file = new File(uRI = URIUtilities.createURI((String)(string = string2 + ".forms")))).exists()) {
            Log.getLogger().info("Loading forms from " + file);
            this.load(new FileInputStream(file));
            return;
        }
    }
}

