/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.explorer.filter;

import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.explorer.filter.DefaultExplorerFilter;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ValidClassesPanel
extends JPanel {
    private DefaultExplorerFilter filter;
    private JList list;
    public static final int PREFERRED_WIDTH = 260;

    public ValidClassesPanel(DefaultExplorerFilter defaultExplorerFilter) {
        this.filter = defaultExplorerFilter;
        this.list = new JList<ListItem>(new ListItem[]{new ListItem(RDFSNamedClass.class, "Named classes", "PrimitiveClass"), new ListItem(OWLAllValuesFrom.class, "AllValuesFrom restrictions", "OWLAllValuesFrom"), new ListItem(OWLSomeValuesFrom.class, "SomeValuesFrom restrictions", "OWLSomeValuesFrom"), new ListItem(OWLHasValue.class, "HasValue restrictions", "OWLHasValue"), new ListItem(OWLCardinality.class, "Cardinality restrictions", "OWLCardinality"), new ListItem(OWLMinCardinality.class, "MinCardinality restrictions", "OWLMinCardinality"), new ListItem(OWLMaxCardinality.class, "MaxCardinality restrictions", "OWLMaxCardinality"), new ListItem(OWLIntersectionClass.class, "Intersection classes", "OWLIntersectionClass"), new ListItem(OWLUnionClass.class, "Union classes", "OWLUnionClass"), new ListItem(OWLComplementClass.class, "Complement classes", "OWLComplementClass"), new ListItem(OWLEnumeratedClass.class, "Enumerated classes", "OWLEnumeratedClass")});
        this.list.setCellRenderer(new DefaultRenderer(){

            public void load(Object object) {
                ListItem listItem = (ListItem)object;
                this.setMainIcon(listItem.icon);
                this.setMainText(listItem.name);
            }
        });
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ValidClassesPanel.this.updateFilter();
            }
        });
        this.updateListSelection();
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Show only Classes of Types", new JScrollPane(this.list));
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
        this.setPreferredSize(new Dimension(260, 260));
    }

    private int getListIndex(Class clazz) {
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            ListItem listItem = (ListItem)this.list.getModel().getElementAt(i);
            if (listItem.type != clazz) continue;
            return i;
        }
        return -1;
    }

    private void updateFilter() {
        this.filter.removeAllValidClasses();
        int[] nArray = this.list.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            ListItem listItem = (ListItem)this.list.getModel().getElementAt(nArray[i]);
            this.filter.addValidClass(listItem.type);
        }
    }

    private void updateListSelection() {
        ListSelectionModel listSelectionModel = this.list.getSelectionModel();
        listSelectionModel.clearSelection();
        for (Class clazz : this.filter.getValidClasses()) {
            int n = this.getListIndex(clazz);
            listSelectionModel.addSelectionInterval(n, n);
        }
    }

    private class ListItem {
        Class type;
        Icon icon;
        String name;

        ListItem(Class clazz, String string, String string2) {
            this.type = clazz;
            this.icon = OWLIcons.getImageIcon(string2);
            this.name = string;
        }
    }
}

