/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.explorer.filter;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerFilter;
import java.util.HashSet;
import java.util.Set;

public class DefaultExplorerFilter
implements ExplorerFilter {
    private boolean useInferredSuperclasses;
    private Set validClasses = new HashSet();
    private RDFProperty validProperty = null;

    public DefaultExplorerFilter() {
        this.addAllValidClasses();
    }

    public void addAllValidClasses() {
        this.validClasses.add(RDFSNamedClass.class);
        this.validClasses.add(OWLSomeValuesFrom.class);
        this.validClasses.add(OWLAllValuesFrom.class);
        this.validClasses.add(OWLHasValue.class);
        this.validClasses.add(OWLMaxCardinality.class);
        this.validClasses.add(OWLMinCardinality.class);
        this.validClasses.add(OWLCardinality.class);
        this.validClasses.add(OWLIntersectionClass.class);
        this.validClasses.add(OWLUnionClass.class);
        this.validClasses.add(OWLComplementClass.class);
        this.validClasses.add(OWLEnumeratedClass.class);
    }

    public void addValidClass(Class clazz) {
        this.validClasses.add(clazz);
    }

    public Set getValidClasses() {
        return new HashSet(this.validClasses);
    }

    public RDFProperty getValidProperty() {
        return this.validProperty;
    }

    private boolean hasValidType(RDFSClass rDFSClass) {
        Class<?> clazz = rDFSClass.getClass();
        for (Class clazz2 : this.validClasses) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean getUseInferredSuperclasses() {
        return this.useInferredSuperclasses;
    }

    public boolean isValidChild(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
        if (rDFSClass instanceof OWLQuantifierRestriction) {
            return true;
        }
        if (!this.hasValidType(rDFSClass2)) {
            return false;
        }
        if (this.getValidProperty() != null) {
            if (rDFSClass2 instanceof OWLRestriction) {
                RDFProperty rDFProperty = ((OWLRestriction)rDFSClass2).getOnProperty();
                return rDFProperty.equals(this.getValidProperty()) || rDFProperty.isSubpropertyOf(this.getValidProperty(), true);
            }
            return false;
        }
        return true;
    }

    public void removeAllValidClasses() {
        this.validClasses.clear();
    }

    public void removeValidClass(Class clazz) {
        this.validClasses.remove(clazz);
    }

    public void setUseInferredSuperclasses(boolean bl) {
        this.useInferredSuperclasses = bl;
    }

    public void setValidProperty(RDFProperty rDFProperty) {
        this.validProperty = rDFProperty;
    }
}

