/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreeNode;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreeRoot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ExistentialTreePanel
extends SelectableContainer
implements Hierarchy {
    private OWLObjectProperty existentialProperty;
    private HeaderComponent headerComponent;
    private LabeledComponent lc;
    private JPanel mainPanel;
    private OWLModel owlModel;
    private static final int MAX_EXPANSIONS = 100;
    private Cls root;
    private Slot superclassesSlot;
    private Action viewAction;

    public ExistentialTreePanel(Cls cls, Slot slot, OWLObjectProperty oWLObjectProperty) {
        this.root = cls;
        this.superclassesSlot = slot;
        this.existentialProperty = oWLObjectProperty;
        this.setPreferredSize(new Dimension(260, 400));
        this.setMinimumSize(new Dimension(100, 100));
        this.owlModel = (OWLModel)cls.getKnowledgeBase();
        this.viewAction = this.createViewClsAction();
        SelectableTree selectableTree = this.createTree(cls);
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add("Center", new JScrollPane((Component)selectableTree));
        String string = this.getTitle();
        this.lc = new OWLLabeledComponent(string, this.mainPanel, true, false);
        this.viewAction.setEnabled(true);
        JLabel jLabel = ComponentFactory.createLabel((String)cls.getProject().getName(), (Icon)Icons.getProjectIcon(), (int)2);
        this.headerComponent = new HeaderComponent("CLASS BROWSER", "For Project", (JComponent)jLabel);
        this.setLayout(new BorderLayout());
        this.add("North", (Component)this.headerComponent);
        this.add("Center", (Component)this.lc);
    }

    private SelectableTree createTree(Cls cls) {
        SelectableTree selectableTree = this.createSelectableTree(this.viewAction, new ExistentialTreeRoot(cls, this.superclassesSlot, this.existentialProperty));
        selectableTree.setSelectionRow(0);
        selectableTree.setAutoscrolls(true);
        this.setSelectable((Selectable)selectableTree);
        selectableTree.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                ExistentialTreePanel.this.updateActions();
            }
        });
        selectableTree.addMouseListener((MouseListener)new TreePopupMenuMouseListener((JTree)selectableTree){

            public JPopupMenu getPopupMenu() {
                return ExistentialTreePanel.this.getPopupMenu();
            }
        });
        return selectableTree;
    }

    public Hierarchy createClone() {
        return new ExistentialTreePanel(this.root, this.superclassesSlot, this.existentialProperty);
    }

    private Action createCollapseAllAction() {
        return new AbstractAction("Collapse", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                ComponentUtilities.fullSelectionCollapse((JTree)ExistentialTreePanel.this.getTree());
            }
        };
    }

    private Action createExpandAllAction() {
        return new AbstractAction("Expand", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                ComponentUtilities.fullSelectionExpand((JTree)ExistentialTreePanel.this.getTree(), (int)100);
            }
        };
    }

    protected JPopupMenu createPopupMenu(Cls cls) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (cls.isVisible()) {
            Action action = this.getHideClsAction();
            if (cls.equals(this.owlModel.getOWLThingClass())) {
                action.setEnabled(false);
            }
            jPopupMenu.add(action);
        } else {
            jPopupMenu.add(this.getUnhideClsAction());
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.createExpandAllAction());
        jPopupMenu.add(this.createCollapseAllAction());
        if (cls instanceof RDFResource) {
            ResourceActionManager.addResourceActions(jPopupMenu, (Component)((Object)this), (RDFResource)cls);
        }
        return jPopupMenu;
    }

    protected SelectableTree createSelectableTree(Action action, LazyTreeRoot lazyTreeRoot) {
        SelectableTree selectableTree = new SelectableTree(action, lazyTreeRoot);
        selectableTree.setCellRenderer((TreeCellRenderer)FrameRenderer.createInstance());
        return selectableTree;
    }

    protected Action createViewClsAction() {
        return new ViewAction("View selected class", this){

            public void onView(Object object) {
                ExistentialTreePanel.this.owlModel.getProject().show((Instance)((Cls)object));
            }
        };
    }

    public void expandRoot() {
        this.setExpandedCls(this.owlModel.getOWLThingClass(), true);
    }

    public void extendSelection(Cls cls) {
        ComponentUtilities.extendSelection((JTree)this.getTree(), (Object)cls);
    }

    public JTree getClsesTree() {
        return this.getTree();
    }

    public Cls getDisplayParent() {
        TreePath treePath = this.getTree().getSelectionModel().getLeadSelectionPath().getParentPath();
        LazyTreeNode lazyTreeNode = (LazyTreeNode)treePath.getLastPathComponent();
        Object object = lazyTreeNode.getUserObject();
        return object instanceof Cls ? (Cls)object : null;
    }

    protected OWLObjectProperty getExistentialProperty() {
        return this.existentialProperty;
    }

    public HeaderComponent getHeaderComponent() {
        return this.headerComponent;
    }

    private Action getHideClsAction() {
        return new AbstractAction("Hide class", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Cls cls : ExistentialTreePanel.this.getSelection()) {
                    cls.setVisible(false);
                }
            }
        };
    }

    protected LabeledComponent getLabeledComponent() {
        return this.lc;
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = null;
        Collection collection = this.getSelection();
        if (collection.size() == 1) {
            Cls cls = (Cls)CollectionUtilities.getFirstItem((Collection)collection);
            jPopupMenu = this.createPopupMenu(cls);
        }
        return jPopupMenu;
    }

    public RDFSClass getSelectedClass() {
        return this.getSelectedOWLClass();
    }

    public OWLClass getSelectedOWLClass() {
        JTree jTree = this.getTree();
        if (jTree.getSelectionCount() == 1) {
            TreePath treePath = jTree.getSelectionPath();
            ExistentialTreeNode existentialTreeNode = (ExistentialTreeNode)((Object)treePath.getLastPathComponent());
            return existentialTreeNode.getOWLClass();
        }
        return null;
    }

    protected ExistentialTreeNode getSelectedNode() {
        JTree jTree = this.getTree();
        TreePath treePath = jTree.getSelectionPath();
        if (treePath != null) {
            return (ExistentialTreeNode)((Object)treePath.getLastPathComponent());
        }
        return null;
    }

    public OWLClass getSelectedParentClass() {
        TreePath treePath;
        int n;
        JTree jTree = this.getTree();
        if (jTree.getSelectionCount() == 1 && (n = (treePath = jTree.getSelectionPath()).getPathCount()) > 2) {
            ExistentialTreeNode existentialTreeNode = (ExistentialTreeNode)((Object)treePath.getPathComponent(n - 2));
            return existentialTreeNode.getOWLClass();
        }
        return null;
    }

    public String getTitle() {
        return StringUtilities.capitalize((String)this.existentialProperty.getBrowserText());
    }

    public String getType() {
        return "Existential Relationship";
    }

    protected JTree getTree() {
        return (JTree)this.getSelectable();
    }

    private Action getUnhideClsAction() {
        return new AbstractAction("Make class visible", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Cls cls : ExistentialTreePanel.this.getSelection()) {
                    cls.setVisible(true);
                }
            }
        };
    }

    public boolean isDefaultSynchronized() {
        return false;
    }

    public void navigateToResource(RDFResource rDFResource) {
        if (rDFResource instanceof RDFSClass) {
            this.setSelectedClass((RDFSClass)rDFResource);
        }
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection((JTree)this.getTree());
    }

    public void setDisplayParent(Cls cls) {
        SelectableTree selectableTree = this.createTree(cls);
        Component component = this.mainPanel.getComponent(0);
        this.mainPanel.removeAll();
        ComponentUtilities.dispose((Component)component);
        this.mainPanel.add("Center", new JScrollPane((Component)selectableTree));
    }

    public void setExpandedCls(Cls cls, boolean bl) {
        List list = ModelUtilities.getPathToRoot((Cls)cls);
        ComponentUtilities.setExpanded((JTree)this.getTree(), (Collection)list, (boolean)bl);
    }

    public void setFinderComponent(JComponent jComponent) {
        this.add(jComponent, "South");
    }

    public void setRenderer(DefaultRenderer defaultRenderer) {
        this.getTree().setCellRenderer((TreeCellRenderer)defaultRenderer);
    }

    public void setSelectedClass(RDFSClass rDFSClass) {
        this.setDisplayParent(rDFSClass);
    }

    public String toString() {
        return "SubsumptionTreePanel";
    }

    protected void updateActions() {
    }

    public static interface SuperClsesPanel {
        public void setCls(OWLNamedClass var1);
    }
}

