/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreeNode;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreePanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class EditableExistentialTreePanel
extends ExistentialTreePanel {
    private AllowableAction addClassAction = new AllowableAction("Add class", OWLIcons.getAddIcon("PrimitiveClass"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            EditableExistentialTreePanel.this.addClass();
        }

        public void onSelectionChange() {
            OWLClass oWLClass = EditableExistentialTreePanel.this.getSelectedOWLClass();
            this.setAllowed(oWLClass != null && oWLClass.isEditable());
        }
    };
    private AllowableAction createClsAction = new AllowableAction("Create class", OWLIcons.getCreateIcon("PrimitiveClass"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            EditableExistentialTreePanel.this.createClass();
        }

        public void onSelectionChange() {
            OWLClass oWLClass = EditableExistentialTreePanel.this.getSelectedOWLClass();
            this.setAllowed(oWLClass != null && oWLClass.isEditable());
        }
    };
    private AllowableAction deleteClsAction = new AllowableAction("Delete class", OWLIcons.getDeleteIcon("PrimitiveClass"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            EditableExistentialTreePanel.this.deleteCls();
        }

        public void onSelectionChange() {
            OWLClass oWLClass = EditableExistentialTreePanel.this.getSelectedParentClass();
            OWLClass oWLClass2 = EditableExistentialTreePanel.this.getSelectedOWLClass();
            this.setAllowed(oWLClass != null && oWLClass.isEditable() && oWLClass2 != null && oWLClass2.isEditable());
        }
    };
    private Action removeClsAction = new AllowableAction("Remove class", OWLIcons.getRemoveIcon("PrimitiveClass"), this){

        public void actionPerformed(ActionEvent actionEvent) {
            EditableExistentialTreePanel.this.removeCls();
        }

        public void onSelectionChange() {
            OWLClass oWLClass = EditableExistentialTreePanel.this.getSelectedParentClass();
            this.setAllowed(oWLClass != null);
        }
    };

    public EditableExistentialTreePanel(RDFSNamedClass rDFSNamedClass, Slot slot, OWLObjectProperty oWLObjectProperty) {
        super(rDFSNamedClass, slot, oWLObjectProperty);
        this.getLabeledComponent().addHeaderButton((Action)this.createClsAction);
        this.getLabeledComponent().addHeaderButton((Action)this.addClassAction);
        this.getLabeledComponent().addHeaderButton(this.removeClsAction);
        this.getLabeledComponent().addHeaderButton((Action)this.deleteClsAction);
        this.createClsAction.setAllowed(true);
        this.addClassAction.setAllowed(true);
    }

    private void addClass() {
        RDFSNamedClass rDFSNamedClass;
        OWLModel oWLModel = this.getOWLModel();
        OWLObjectProperty oWLObjectProperty = this.getExistentialProperty();
        Set<OWLNamedClass> set = oWLObjectProperty.getUnionRangeClasses();
        if (set.size() == 0) {
            set = Collections.singleton(oWLModel.getOWLThingClass());
        }
        if ((rDFSNamedClass = ProtegeUI.getSelectionDialogFactory().selectClass((Component)((Object)this), oWLModel, set, "Select a class to add")) instanceof OWLNamedClass) {
            OWLClass oWLClass = this.getSelectedOWLClass();
            try {
                oWLModel.beginTransaction("Add existential relationship " + this.getExistentialProperty().getBrowserText() + " between " + oWLClass.getBrowserText() + " and " + rDFSNamedClass.getBrowserText(), oWLClass.getName());
                oWLClass.addSuperclass(oWLModel.createOWLSomeValuesFrom((RDFProperty)this.getExistentialProperty(), (OWLNamedClass)rDFSNamedClass));
                oWLModel.commitTransaction();
            }
            catch (Exception exception) {
                oWLModel.rollbackTransaction();
                OWLUI.handleError(oWLModel, exception);
            }
            this.selectChildNode(rDFSNamedClass);
        }
    }

    private void createClass() {
        OWLModel oWLModel = this.getOWLModel();
        OWLClass oWLClass = this.getSelectedOWLClass();
        OWLNamedClass oWLNamedClass = oWLModel.createOWLNamedClass(null);
        oWLNamedClass.removeSuperclass(oWLModel.getOWLThingClass());
        for (RDFSClass rDFSClass : oWLClass.getSuperclasses(false)) {
            if (!(rDFSClass instanceof OWLNamedClass)) continue;
            oWLNamedClass.addSuperclass(rDFSClass);
        }
        oWLClass.addSuperclass(oWLModel.createOWLSomeValuesFrom((RDFProperty)this.getExistentialProperty(), oWLNamedClass));
        this.selectChildNode(oWLNamedClass);
    }

    private void deleteCls() {
        OWLClass oWLClass = this.getSelectedOWLClass();
        oWLClass.delete();
    }

    private void removeCls() {
        OWLClass oWLClass = this.getSelectedOWLClass();
        OWLClass oWLClass2 = this.getSelectedParentClass();
        System.err.println("The remove mothod has temporarily been disabled.");
    }

    private void selectChildNode(RDFSClass rDFSClass) {
        JTree jTree = this.getTree();
        ExistentialTreeNode existentialTreeNode = this.getSelectedNode();
        if (existentialTreeNode != null) {
            ExistentialTreeNode existentialTreeNode2 = null;
            for (int i = 0; i < existentialTreeNode.getChildObjectCount() && !rDFSClass.equals((existentialTreeNode2 = (ExistentialTreeNode)((Object)existentialTreeNode.getChildAt(i))).getOWLClass()); ++i) {
            }
            TreePath treePath = jTree.getSelectionPath();
            TreePath treePath2 = treePath.pathByAddingChild((Object)existentialTreeNode2);
            jTree.setSelectionPath(treePath2);
        }
    }
}

