/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.editors;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.widget.HTMLEditorPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetUtil;
import java.awt.Component;

public class StringValueEditor
implements PropertyValueEditor {
    public boolean canEdit(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        if (object != null) {
            if (object instanceof RDFSLiteral) {
                RDFSLiteral rDFSLiteral = (RDFSLiteral)object;
                return rDFResource.getOWLModel().getXSDstring().equals(rDFSLiteral.getDatatype());
            }
            return object instanceof String;
        }
        for (RDFSNamedClass rDFSNamedClass : rDFResource.getProtegeTypes()) {
            if (!OWLWidgetUtil.isDatatypeProperty(oWLModel.getXSDstring(), rDFSNamedClass, rDFProperty)) continue;
            return true;
        }
        return false;
    }

    public Object createDefaultValue(RDFResource rDFResource, RDFProperty rDFProperty) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        String string = oWLModel.getDefaultLanguage();
        if (string != null) {
            return oWLModel.createRDFSLiteral("", string);
        }
        return "";
    }

    public Object editValue(Component component, RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        RDFSLiteral rDFSLiteral;
        OWLModel oWLModel = rDFResource.getOWLModel();
        RDFSLiteral rDFSLiteral2 = null;
        rDFSLiteral2 = object instanceof String ? oWLModel.createRDFSLiteral((String)object, oWLModel.getXSDstring()) : (object instanceof RDFSLiteral ? (RDFSLiteral)object : oWLModel.createRDFSLiteral("", oWLModel.getXSDstring()));
        if (component == null) {
            component = ProtegeUI.getTopLevelContainer(rDFProperty.getProject());
        }
        if ((rDFSLiteral = HTMLEditorPanel.show(component, rDFSLiteral2, "Edit " + rDFProperty.getBrowserText() + " at " + rDFResource.getBrowserText(), rDFResource.getOWLModel())) != null && !rDFSLiteral2.equals(rDFSLiteral)) {
            if (rDFSLiteral.getLanguage() == null || rDFSLiteral.getLanguage().length() == 0) {
                return rDFSLiteral.getString();
            }
            return rDFSLiteral;
        }
        return null;
    }

    public boolean mustEdit(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return false;
    }
}

