/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.conditions.AbstractConditionsWidget;
import edu.stanford.smi.protegex.owl.ui.conditions.AddNamedClassAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.DeleteRowAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableAction;
import edu.stanford.smi.protegex.owl.ui.restrictions.RestrictionEditorPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AssertedConditionsWidget
extends AbstractConditionsWidget {
    private AddNamedClassAction addNamedClassAction;
    private Action createExpressionAction = new AbstractAction("Create new expression", OWLIcons.getCreateIcon("OWLAnonymousClass")){

        public void actionPerformed(ActionEvent actionEvent) {
            AssertedConditionsWidget.this.table.selectNecessaryIfNothingSelected();
            AssertedConditionsWidget.this.table.createAndEditRow();
        }
    };
    private Action createRestrictionAction = new AbstractAction("Create restriction...", OWLIcons.getCreateIcon("OWLRestriction")){

        public void actionPerformed(ActionEvent actionEvent) {
            AssertedConditionsWidget.this.createRestriction();
        }
    };
    private DeleteRowAction deleteAction;
    private OWLTableAction deriveRestrictionAction = new AbstractOWLTableAction("Derive similar restriction...", OWLIcons.getAddIcon("OWLRestriction")){

        public void actionPerformed(ActionEvent actionEvent) {
            AssertedConditionsWidget.this.deriveRestriction();
        }

        public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
            return AssertedConditionsWidget.this.tableModel.isAddEnabledAt(n) && AssertedConditionsWidget.this.table.getSelectedCls() instanceof OWLRestriction;
        }
    };
    private OWLTableAction negateAnonymousClsAction = new AbstractOWLTableAction("Negate expression", OWLIcons.getAddIcon("OWLComplementClass")){

        public void actionPerformed(ActionEvent actionEvent) {
            AssertedConditionsWidget.this.negateAnonymousClass();
        }

        public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
            return AssertedConditionsWidget.this.tableModel.isAddEnabledAt(n) && AssertedConditionsWidget.this.table.getSelectedCls() instanceof OWLAnonymousClass;
        }
    };

    private void createRestriction() {
        OWLRestriction oWLRestriction = null;
        OWLClassesTab oWLClassesTab = this.table.getOWLClsesTab();
        this.table.selectNecessaryIfNothingSelected();
        Cls cls = this.getKnowledgeBase().getCls("owl:SomeValuesFromRestriction");
        try {
            this.beginTransaction("Create restriction at " + this.getEditedCls().getBrowserText(), this.getEditedCls().getName());
            oWLRestriction = RestrictionEditorPanel.showCreateDialog((Component)((Object)this.table), this.getEditedCls(), cls);
            if (oWLRestriction != null) {
                this.table.addRestriction(oWLRestriction);
            }
            this.commitTransaction();
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            OWLUI.handleError(this.getOWLModel(), exception);
        }
        try {
            if (oWLRestriction != null) {
                this.table.ensureEditedClassSelectedInExplorer(oWLClassesTab);
            }
        }
        catch (Exception exception) {
            Log.getLogger().warning("Cannot select in class tree: " + this.tableModel.getEditedCls());
        }
    }

    private void deriveRestriction() {
        OWLRestriction oWLRestriction = null;
        OWLRestriction oWLRestriction2 = (OWLRestriction)this.table.getSelectedCls();
        RDFSClass rDFSClass = oWLRestriction2.getProtegeType();
        OWLProperty oWLProperty = (OWLProperty)oWLRestriction2.getOnProperty();
        String string = oWLRestriction2.getFillerText();
        try {
            this.beginTransaction("Derive restriction from " + oWLRestriction2.getBrowserText() + " at " + this.getEditedCls().getBrowserText(), this.getEditedCls().getName());
            oWLRestriction = RestrictionEditorPanel.showCreateDialog((Component)((Object)this.table), this.getEditedCls(), rDFSClass, oWLProperty, string);
            if (oWLRestriction != null) {
                this.table.addRestriction(oWLRestriction);
            }
            this.commitTransaction();
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            OWLUI.handleError(this.getOWLModel(), exception);
        }
        try {
            if (oWLRestriction != null) {
                OWLClassesTab oWLClassesTab = this.table.getOWLClsesTab();
                this.table.ensureEditedClassSelectedInExplorer(oWLClassesTab);
            }
        }
        catch (Exception exception) {
            Log.getLogger().warning("Cannot select in class tree: " + this.tableModel.getEditedCls());
        }
    }

    public void initialize() {
        Slot slot = this.getKnowledgeBase().getSlot(":DIRECT-SUPERCLASSES");
        this.initialize("Asserted Conditions", slot);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AssertedConditionsWidget.this.updateCreateActions();
            }
        });
    }

    protected void initializeButtons(LabeledComponent labeledComponent) {
        super.initializeButtons(labeledComponent);
        this.addNamedClassAction = new AddNamedClassAction(this.table);
        this.deleteAction = new DeleteRowAction(this.table){

            public void actionPerformed(ActionEvent actionEvent) {
                OWLClassesTab oWLClassesTab = AssertedConditionsWidget.this.table.getOWLClsesTab();
                super.actionPerformed(actionEvent);
                AssertedConditionsWidget.this.table.ensureEditedClassSelectedInExplorer(oWLClassesTab);
            }
        };
        labeledComponent.addHeaderSeparator();
        labeledComponent.addHeaderButton(this.createExpressionAction);
        labeledComponent.addHeaderButton(this.createRestrictionAction);
        labeledComponent.addHeaderButton((Action)this.addNamedClassAction);
        labeledComponent.addHeaderButton((Action)this.deleteAction);
        this.table.registerAction(this.deleteAction);
        this.table.registerActionSeparator();
        this.table.registerAction(this.deriveRestrictionAction);
        this.table.registerAction(this.negateAnonymousClsAction);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getKnowledgeBase() instanceof OWLModel && slot.getName().equals(":DIRECT-SUPERCLASSES");
    }

    private void negateAnonymousClass() {
        OWLClassesTab oWLClassesTab = this.table.getOWLClsesTab();
        OWLClassDisplay oWLClassDisplay = this.table.getOWLModel().getOWLClassDisplay();
        int n = this.table.getSelectedRow();
        Cls cls = this.table.getSelectedCls();
        String string = cls.getBrowserText();
        if (cls instanceof OWLComplementClass) {
            int n2 = oWLClassDisplay.getOWLComplementOfSymbol().length();
            string = string.substring(n2);
        } else {
            string = oWLClassDisplay.getOWLComplementOfSymbol() + "(" + string + ")";
        }
        this.table.setValueAt(string, n, 0);
        this.table.ensureEditedClassSelectedInExplorer(oWLClassesTab);
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        if (this.table != null) {
            this.updateCreateActions();
        }
    }

    private void updateCreateActions() {
        if (this.table.getSelectedRow() >= this.tableModel.getRowCount()) {
            this.table.setSelectedRow(-1);
        }
        boolean bl = this.getKnowledgeBase().getRootCls().equals(this.getEditedResource());
        if (this.table.getSelectedRowCount() == 1) {
            int n = this.table.getSelectedRow();
            boolean bl2 = !bl && this.tableModel.isCreateEnabledAt(n);
            this.createExpressionAction.setEnabled(bl2);
            this.createRestrictionAction.setEnabled(bl2);
            this.addNamedClassAction.setEnabled(this.tableModel.isAddEnabledAt(n));
        } else {
            this.createExpressionAction.setEnabled(!bl);
            this.createRestrictionAction.setEnabled(!bl);
            this.addNamedClassAction.setEnabled(!bl);
        }
    }
}

