/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.datarangefield;

import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.components.AbstractPropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class DataRangeFieldComponent
extends AbstractPropertyValuesComponent {
    private JComboBox comboBox;
    private Action deleteAction = new AbstractAction("Delete value", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            DataRangeFieldComponent.this.handleDeleteAction();
        }
    };

    public DataRangeFieldComponent(RDFProperty rDFProperty) {
        this(rDFProperty, null);
    }

    public DataRangeFieldComponent(RDFProperty rDFProperty, String string) {
        this(rDFProperty, string, false);
    }

    public DataRangeFieldComponent(RDFProperty rDFProperty, String string, boolean bl) {
        super(rDFProperty, string, bl);
        this.comboBox = new JComboBox();
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataRangeFieldComponent.this.assignComboBoxValue();
            }
        });
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent(string == null ? this.getLabel() : string, this.comboBox);
        oWLLabeledComponent.addHeaderButton(this.deleteAction);
        this.add("Center", (Component)((Object)oWLLabeledComponent));
    }

    private void assignComboBoxValue() {
        Object object = this.comboBox.getSelectedItem();
        this.getSubject().setPropertyValue(this.getPredicate(), object);
    }

    private OWLDataRange getDataRange() {
        RDFProperty rDFProperty = this.getPredicate();
        OWLDataRange oWLDataRange = null;
        Object object = this.getSubject().getRDFTypes().iterator();
        while (object.hasNext()) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)object.next();
            if (!(rDFSNamedClass instanceof OWLNamedClass)) continue;
            OWLNamedClass oWLNamedClass = (OWLNamedClass)rDFSNamedClass;
            RDFResource rDFResource = oWLNamedClass.getAllValuesFrom(rDFProperty);
            if (rDFResource instanceof OWLDataRange) {
                oWLDataRange = (OWLDataRange)rDFResource;
                break;
            }
            RDFResource rDFResource2 = oWLNamedClass.getSomeValuesFrom(rDFProperty);
            if (!(rDFResource2 instanceof OWLDataRange)) continue;
            oWLDataRange = (OWLDataRange)rDFResource2;
            break;
        }
        if (oWLDataRange == null && (object = rDFProperty.getRange(true)) instanceof OWLDataRange) {
            oWLDataRange = (OWLDataRange)object;
        }
        return oWLDataRange;
    }

    private Collection getDataRangeValues() {
        OWLDataRange oWLDataRange;
        if (this.getSubject() != null && (oWLDataRange = this.getDataRange()) != null) {
            return oWLDataRange.getOneOfValueLiterals();
        }
        return Collections.EMPTY_LIST;
    }

    private void handleDeleteAction() {
        this.getSubject().setPropertyValue(this.getPredicate(), null);
    }

    public void setSubject(RDFResource rDFResource) {
        super.setSubject(rDFResource);
        this.updateActionState();
        Collection collection = this.getDataRangeValues();
        Object[] objectArray = collection.toArray();
        this.comboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
        this.updateComboBoxState();
    }

    private void updateActionState() {
        this.deleteAction.setEnabled(this.getSubject() != null && this.getSubject().getPropertyValue(this.getPredicate()) != null && this.hasOnlyEditableValues());
    }

    private void updateComboBoxState() {
        this.comboBox.setEnabled(this.getSubject() != null && this.hasOnlyEditableValues());
    }

    public void valuesChanged() {
        Object object = this.getObject();
        if (object != null && !(object instanceof RDFSLiteral) && !(object instanceof RDFResource)) {
            object = this.getOWLModel().createRDFSLiteral(object);
        }
        this.comboBox.setSelectedItem(object);
        this.updateActionState();
        this.updateComboBoxState();
    }
}

