/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.ui.ResourceComparator;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;

public class ComponentUtil {
    public static JComboBox createDatatypeComboBox(OWLModel oWLModel) {
        ArrayList arrayList = new ArrayList(oWLModel.getRDFSDatatypes());
        arrayList.remove(oWLModel.getRDFXMLLiteralType());
        Collections.sort(arrayList, new ResourceComparator());
        JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList.toArray());
        jComboBox.setRenderer(new DatatypeCellRenderer());
        jComboBox.setSelectedItem(oWLModel.getXSDstring());
        return jComboBox;
    }

    public static JComboBox createLanguageComboBox(OWLModel oWLModel) {
        return ComponentUtil.createLanguageComboBox(oWLModel, null);
    }

    public static JComboBox createLanguageComboBox(OWLModel oWLModel, String string) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("");
        jComboBox.setEditable(true);
        String[] stringArray = oWLModel.getUsedLanguages();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            jComboBox.addItem(string2);
        }
        if (string != null) {
            jComboBox.setSelectedItem(string);
        }
        return jComboBox;
    }

    public static boolean isRangeDefined(RDFResource rDFResource, RDFProperty rDFProperty) {
        if (rDFProperty.getRange() != null) {
            return true;
        }
        Collection collection = rDFResource.getRDFTypes();
        for (RDFSClass rDFSClass : collection) {
            OWLNamedClass oWLNamedClass;
            RDFResource rDFResource2;
            if (!(rDFSClass instanceof OWLNamedClass) || (rDFResource2 = (oWLNamedClass = (OWLNamedClass)rDFSClass).getAllValuesFrom(rDFProperty)) == null) continue;
            return true;
        }
        return false;
    }

    public static JComboBox createLangCellEditor(OWLModel oWLModel, JTable jTable) {
        JComboBox jComboBox = ComponentUtil.createLanguageComboBox(oWLModel, null);
        jComboBox.setFont(jTable.getFont());
        jComboBox.setBackground(jTable.getBackground());
        return jComboBox;
    }

    public static class DatatypeCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof RDFSDatatype) {
                object = ((RDFSDatatype)object).getLocalName();
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

