/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.ParserUtils;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.code.ResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLResourceNameMatcher
implements ResourceNameMatcher {
    public static final int SCALABLE_FRAME_COUNT = 1000;

    @Override
    public String getInsertString(RDFResource rDFResource) {
        String string = rDFResource.getBrowserText();
        return ParserUtils.quoteIfNeeded(string);
    }

    @Override
    public Set<RDFResource> getMatchingResources(String string, String string2, OWLModel oWLModel) {
        boolean bl = false;
        if (string.startsWith("'")) {
            bl = true;
            string = string.substring(1);
        }
        if (oWLModel instanceof OWLDatabaseModel && string.length() < 3) {
            return Collections.EMPTY_SET;
        }
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        OWLClassParseException oWLClassParseException = OWLClassParseException.getRecentInstance();
        if (oWLClassParseException.nextCouldBeClass || oWLModel.getRDFResource(string) instanceof RDFSNamedClass || bl) {
            OWLResourceNameMatcher.addMatchingRDFSNamedClasses(string, hashSet, oWLModel);
        }
        if (oWLClassParseException.nextCouldBeIndividual || oWLModel.getRDFResource(string) != null || bl) {
            OWLResourceNameMatcher.addMatchingRDFIndividuals(string, hashSet, oWLModel);
        }
        if (oWLClassParseException.nextCouldBeProperty || oWLModel.getRDFResource(string) instanceof RDFProperty || bl) {
            OWLResourceNameMatcher.addMatchingRDFProperties(string, hashSet, oWLModel);
        }
        if (oWLClassParseException.nextCouldBeDatatypeName || oWLModel.getRDFResource(string) instanceof RDFSDatatype) {
            OWLResourceNameMatcher.getMatchingDatatypeNames(string, hashSet, oWLModel);
        }
        return hashSet;
    }

    public static void addMatchingRDFSNamedClasses(String string, Set<RDFResource> set, OWLModel oWLModel) {
        if (string.length() == 0) {
            int n = oWLModel.getRDFSClassCount();
            if (n < 1000) {
                for (RDFSNamedClass rDFSNamedClass : OWLUtil.getSelectableNamedClses(oWLModel)) {
                    if (!rDFSNamedClass.isVisibleFromOWLThing()) continue;
                    set.add(rDFSNamedClass);
                }
            }
        } else {
            ArrayList<Frame> arrayList = new ArrayList<Frame>();
            ArrayList<Slot> arrayList2 = new ArrayList<Slot>();
            OWLResourceNameMatcher.addMatchingFrames(oWLModel, arrayList, oWLModel.getRDFSNamedClassClass(), string, arrayList2);
            OWLResourceNameMatcher.addMatchingFrames(oWLModel, arrayList, oWLModel.getOWLNamedClassClass(), string, arrayList2);
            OWLResourceNameMatcher.addFilteredElements(set, arrayList, RDFSNamedClass.class);
        }
    }

    public static void addMatchingRDFProperties(String string, Set<RDFResource> set, OWLModel oWLModel) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        ArrayList<Slot> arrayList2 = new ArrayList<Slot>();
        OWLResourceNameMatcher.addMatchingFrames(oWLModel, arrayList, oWLModel.getRDFPropertyClass(), string, arrayList2);
        OWLResourceNameMatcher.addMatchingFrames(oWLModel, arrayList, oWLModel.getOWLDatatypePropertyClass(), string, arrayList2);
        OWLResourceNameMatcher.addMatchingFrames(oWLModel, arrayList, oWLModel.getOWLObjectPropertyClass(), string, arrayList2);
        OWLResourceNameMatcher.addFilteredElements(set, arrayList, RDFProperty.class);
    }

    public static void addMatchingRDFIndividuals(String string, Set<RDFResource> set, OWLModel oWLModel) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        ArrayList<Slot> arrayList2 = new ArrayList<Slot>();
        OWLResourceNameMatcher.addMatchingFrames(oWLModel, arrayList, oWLModel.getOWLThingClass(), string, arrayList2);
        OWLResourceNameMatcher.addFilteredElements(set, arrayList, RDFIndividual.class);
    }

    public static void getMatchingDatatypeNames(String string, Set<RDFResource> set, OWLModel oWLModel) {
        Collection collection = oWLModel.getRDFSDatatypes();
        for (RDFSDatatype rDFSDatatype : collection) {
            if (rDFSDatatype.isAnonymous() || !rDFSDatatype.getBrowserText().startsWith(string)) continue;
            set.add(rDFSDatatype);
        }
    }

    private static void addMatchingFrames(OWLModel oWLModel, Collection<Frame> collection, Cls cls, String string, Collection<Slot> collection2) {
        Slot slot = OWLResourceNameMatcher.getBrowserSlotForType(cls);
        if (!collection2.contains(slot)) {
            Collection collection3 = oWLModel.getMatchingFrames(slot, null, false, string + "*", 1000);
            collection.addAll(collection3);
            String string2 = oWLModel.getDefaultLanguage();
            if (string2 != null && slot instanceof RDFProperty && ((RDFProperty)slot).isAnnotationProperty()) {
                collection3 = oWLModel.getMatchingFrames(slot, null, false, "~#" + string2 + ' ' + string + "*", 1000);
                collection.addAll(collection3);
            }
            collection2.add(slot);
        }
    }

    @Override
    public boolean isIdChar(char c) {
        return SymbolTextField.isIdChar(c);
    }

    private static Slot getBrowserSlotForType(Cls cls) {
        BrowserSlotPattern browserSlotPattern = cls.getBrowserSlotPattern();
        List list = browserSlotPattern.getSlots();
        if (list.size() == 1) {
            return (Slot)list.get(0);
        }
        return cls.getKnowledgeBase().getSystemFrames().getNameSlot();
    }

    private static void addFilteredElements(Set<RDFResource> set, Collection<?> collection, Class<? extends RDFResource> clazz) {
        for (Object obj : collection) {
            if (!clazz.isAssignableFrom(obj.getClass()) || !OWLResourceNameMatcher.isVisible((Frame)((RDFResource)obj))) continue;
            set.add((RDFResource)obj);
        }
    }

    private static boolean isVisible(Frame frame) {
        if (frame instanceof RDFSNamedClass) {
            return frame.isVisible() && (OWLResourceNameMatcher.isSlowProject(frame.getKnowledgeBase()) || ((RDFSNamedClass)frame).isVisibleFromOWLThing());
        }
        return frame.isVisible();
    }

    private static boolean isSlowProject(KnowledgeBase knowledgeBase) {
        return knowledgeBase.getProject().isMultiUserClient();
    }
}

