/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.impl.AbstractRDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.clsproperties.NewRestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.clsproperties.OldRestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyRestrictionsTreeRenderer;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyTreeNode;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.code.OWLSymbolPanel;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextField;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorHandler;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.restrictions.RestrictionEditorPanel;
import edu.stanford.smi.protegex.owl.ui.restrictions.RestrictionKindRenderer;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.util.ExpressionInfo;
import edu.stanford.smi.protegex.owl.util.ExpressionInfoUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyRestrictionsTree
extends SelectableTree
implements Disposable {
    private OWLNamedClass cls;
    private ClassListener classListener = new ClassAdapter(){

        public void subclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertyRestrictionsTree.this.refillLater();
        }

        public void subclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertyRestrictionsTree.this.refillLater();
        }

        public void superclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertyRestrictionsTree.this.refillLater();
        }

        public void superclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertyRestrictionsTree.this.refillLater();
        }

        public void addedToUnionDomainOf(RDFSClass rDFSClass, RDFProperty rDFProperty) {
            PropertyRestrictionsTree.this.refillLater();
        }

        public void removedFromUnionDomainOf(RDFSClass rDFSClass, RDFProperty rDFProperty) {
            PropertyRestrictionsTree.this.refillLater();
        }
    };
    private AllowableAction createRestrictionAction = new AllowableAction("Create restriction...", OWLIcons.getCreateIcon("OWLRestriction"), (Selectable)this){

        public void actionPerformed(ActionEvent actionEvent) {
            if (!PropertyRestrictionsTree.this.isMixedClass() && (PropertyRestrictionsTree.this.cls.isEditable() || PropertyRestrictionsTree.this.cls.getDefinition() == null)) {
                PropertyRestrictionsTree.this.createRestrictionFromDialog(null);
            }
        }

        public void onSelectionChange() {
            PropertyRestrictionsTree.this.updateCreateRestrictionActionAllowed();
        }
    };
    private Action deleteRestrictionAction = new AllowableAction("Delete restriction", OWLIcons.getDeleteIcon("OWLRestriction"), (Selectable)this){

        public void actionPerformed(ActionEvent actionEvent) {
            Instance instance = PropertyRestrictionsTree.this.getSelectedInstance();
            OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
            try {
                oWLModel.beginTransaction("Delete restriction " + instance.getBrowserText() + " from class " + PropertyRestrictionsTree.this.cls.getBrowserText(), PropertyRestrictionsTree.this.cls.getName());
                instance.delete();
                oWLModel.commitTransaction();
            }
            catch (Exception exception) {
                oWLModel.rollbackTransaction();
                OWLUI.handleError(oWLModel, exception);
            }
        }

        public void onSelectionChange() {
            Instance instance = PropertyRestrictionsTree.this.getSelectedInstance();
            if (instance instanceof OWLRestriction && instance.isEditable() && PropertyRestrictionsTree.this.cls.equals(PropertyRestrictionsTree.this.getHostCls((OWLRestriction)instance))) {
                this.setAllowed(!PropertyRestrictionsTree.this.isMixedClass() && (PropertyRestrictionsTree.this.cls.isEditable() || PropertyRestrictionsTree.this.cls.getDefinition() == null));
                return;
            }
            this.setAllowed(false);
        }
    };
    private DefaultTreeModel model;
    private RestrictionTreeNode newNode;
    private OWLModel owlModel;
    private OWLTextField owlTextField;
    private DefaultMutableTreeNode rootNode;
    private OWLSymbolPanel symbolPanel;
    private boolean refilling = false;

    public PropertyRestrictionsTree(OWLModel oWLModel) {
        this(oWLModel, null);
    }

    public PropertyRestrictionsTree(OWLModel oWLModel, OWLNamedClass oWLNamedClass) {
        super(null);
        this.cls = oWLNamedClass;
        this.owlModel = oWLModel;
        ComponentFactory.configureTree((JTree)((Object)this), (Action)new AbstractAction("View property/Edit restriction"){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyRestrictionsTree.this.viewSelectedProperty();
            }
        });
        this.setLargeModel(true);
        this.rootNode = new DefaultMutableTreeNode("Root");
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.model = new DefaultTreeModel(this.rootNode);
        this.setModel(this.model);
        final int n = ToolTipManager.sharedInstance().getDismissDelay();
        this.setToolTipText("");
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Instance instance;
                if (mouseEvent.getClickCount() == 2 && (instance = PropertyRestrictionsTree.this.getSelectedInstance()) instanceof OWLRestriction && PropertyRestrictionsTree.this.isEditable()) {
                    PropertyRestrictionsTree.this.startEditing(mouseEvent);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ToolTipManager.sharedInstance().setDismissDelay(n);
            }
        });
        this.addChildNodes();
        this.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                PropertyRestrictionsTree.this.updateEditable();
            }
        });
        MyTreeCellEditor myTreeCellEditor = new MyTreeCellEditor();
        this.setCellEditor(myTreeCellEditor);
        myTreeCellEditor.addCellEditorListener(new CellEditorListener(){

            public void editingCanceled(ChangeEvent changeEvent) {
                PropertyRestrictionsTree.this.hideSymbolPanel();
                if (PropertyRestrictionsTree.this.newNode != null) {
                    PropertyRestrictionsTree.this.refill();
                    PropertyRestrictionsTree.this.newNode = null;
                }
            }

            public void editingStopped(ChangeEvent changeEvent) {
                PropertyRestrictionsTree.this.hideSymbolPanel();
                PropertyRestrictionsTree.this.newNode = null;
            }
        });
        this.symbolPanel = new OWLSymbolPanel(oWLModel, true, true);
        this.owlTextField = new OWLTextField(oWLModel, this.symbolPanel){

            protected void checkExpression(String string) throws Throwable {
                RestrictionTreeNode restrictionTreeNode = (RestrictionTreeNode)PropertyRestrictionsTree.this.getSelectedTreeNode();
                restrictionTreeNode.checkExpression(string);
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                JViewport jViewport = (JViewport)PropertyRestrictionsTree.this.getParent();
                int n = Math.max(150, jViewport.getWidth() - 60);
                return new Dimension(n, dimension.height);
            }

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            protected void stopEditing() {
                PropertyRestrictionsTree.this.stopEditing();
            }
        };
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TreePath treePath;
        int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n >= 0 && (treePath = this.getPathForRow(n)) != null) {
            Object object = treePath.getLastPathComponent();
            RDFResource rDFResource = null;
            if (object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                rDFResource = (RDFResource)defaultMutableTreeNode.getUserObject();
            }
            if (rDFResource != null) {
                ToolTipManager.sharedInstance().setDismissDelay(1000000);
                return OWLUI.getOWLToolTipText(rDFResource);
            }
        }
        return null;
    }

    private void addChildNodes() {
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        if (this.cls != null && !this.cls.equals(this.cls.getOWLModel().getOWLThingClass())) {
            this.addRestrictionChildNodes(hashSet);
            this.addDomainChildNodes(hashSet);
            this.sortPropertyTreeNodes();
        }
    }

    private void addDomainChildNodes(Set<RDFProperty> set) {
        ArrayList<OWLNamedClass> arrayList = new ArrayList<OWLNamedClass>();
        arrayList.add(this.cls);
        HashSet<RDFSNamedClass> hashSet = new HashSet<RDFSNamedClass>();
        boolean bl = false;
        while (!arrayList.isEmpty()) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)arrayList.get(0);
            hashSet.add(rDFSNamedClass);
            arrayList.remove(0);
            this.addNodesForDirectUnionDomainProperty(rDFSNamedClass, set, bl);
            List list = this.getNextSuperclasses(rDFSNamedClass, hashSet);
            arrayList.addAll(list);
            bl = true;
        }
    }

    private void addRestrictionChildNodes(Set<RDFProperty> set) {
        Object object;
        ArrayList<ExpressionInfo<OWLRestriction>> arrayList = new ArrayList<ExpressionInfo<OWLRestriction>>();
        ArrayList<RDFProperty> arrayList2 = new ArrayList<RDFProperty>();
        for (Slot object3 : this.cls.getDirectTemplateSlots()) {
            if (!(object3 instanceof RDFProperty)) continue;
            arrayList2.add((RDFProperty)object3);
        }
        for (RDFSNamedClass rDFSNamedClass : this.getNamedSuperclassesClosure(this.cls)) {
            if (!(rDFSNamedClass instanceof OWLNamedClass)) continue;
            List<ExpressionInfo<OWLRestriction>> list = ExpressionInfoUtils.getDirectContainingRestrictions((OWLNamedClass)rDFSNamedClass);
            arrayList.addAll(list);
            if (!rDFSNamedClass.equals(this.cls)) continue;
            for (Object object2 : list) {
                arrayList2.add(((OWLRestriction)((ExpressionInfo)object2).getExpression()).getOnProperty());
            }
        }
        HashMap hashMap = new HashMap();
        for (ExpressionInfo expressionInfo : arrayList) {
            Object object2;
            object = (OWLRestriction)expressionInfo.getExpression();
            object2 = object.getOnProperty();
            ArrayList<ExpressionInfo> arrayList3 = (ArrayList<ExpressionInfo>)hashMap.get(object2);
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<ExpressionInfo>();
                hashMap.put(object2, arrayList3);
            }
            arrayList3.add(expressionInfo);
        }
        for (RDFProperty rDFProperty : hashMap.keySet()) {
            if (set.contains(rDFProperty)) continue;
            set.add(rDFProperty);
            object = new PropertyTreeNode(this, this.cls, rDFProperty, !arrayList2.contains(rDFProperty), (List)hashMap.get(rDFProperty));
            this.rootNode.add((MutableTreeNode)object);
        }
        this.expandPath(new TreePath(this.rootNode));
    }

    private Set<RDFSNamedClass> getNamedSuperclassesClosure(RDFSNamedClass rDFSNamedClass) {
        HashSet<RDFSNamedClass> hashSet = new HashSet<RDFSNamedClass>();
        this.addNamedSuperclassesClosure(rDFSNamedClass, hashSet);
        return hashSet;
    }

    private void addNamedSuperclassesClosure(RDFSNamedClass rDFSNamedClass, Set<RDFSNamedClass> set) {
        OWLNamedClass oWLNamedClass = rDFSNamedClass.getOWLModel().getOWLThingClass();
        if (rDFSNamedClass.equals(oWLNamedClass)) {
            return;
        }
        set.add(rDFSNamedClass);
        for (Cls cls : rDFSNamedClass.getDirectSuperclasses()) {
            if (!(cls instanceof RDFSNamedClass) || cls.equals(oWLNamedClass) || set.contains(cls)) continue;
            this.addNamedSuperclassesClosure((RDFSNamedClass)cls, set);
        }
    }

    void addCreateRestrictionActions(JPopupMenu jPopupMenu) {
        if (!this.isMixedClass()) {
            OWLModel oWLModel = this.cls.getOWLModel();
            Cls[] clsArray = ProfilesManager.getSupportedRestrictionMetaClses(oWLModel);
            for (int i = 0; i < clsArray.length; ++i) {
                Cls cls = clsArray[i];
                String string = RestrictionKindRenderer.getClsName(cls);
                String string2 = RestrictionKindRenderer.getClsIconName(cls);
                Icon icon = OWLIcons.getCreateIcon(string2);
                jPopupMenu.add(new CreateRestrictionAction(cls, string, icon));
            }
        }
    }

    private void addNavigationMenuItems(JPopupMenu jPopupMenu, Set set) {
        if (!set.isEmpty()) {
            Object[] objectArray = set.toArray(new RDFResource[0]);
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                jPopupMenu.add(new AbstractAction("Navigate to " + object.getBrowserText(), ProtegeUI.getIcon((RDFResource)object), (RDFResource)object){
                    final /* synthetic */ RDFResource val$resource;
                    {
                        this.val$resource = rDFResource;
                        super(string, icon);
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        PropertyRestrictionsTree.this.navigateTo(this.val$resource);
                    }
                });
            }
        }
    }

    private void addNodesForDirectUnionDomainProperty(RDFSNamedClass rDFSNamedClass, Set<RDFProperty> set, boolean bl) {
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        for (RDFProperty rDFProperty : rDFSNamedClass.getUnionDomainProperties()) {
            if (set.contains(rDFProperty) || rDFProperty.isAnnotationProperty()) continue;
            arrayList.add(rDFProperty);
        }
        for (RDFProperty rDFProperty : arrayList) {
            PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this, this.cls, rDFProperty, bl);
            this.rootNode.add(propertyTreeNode);
            set.add(rDFProperty);
        }
    }

    private void addNodesForSubproperties(RDFProperty rDFProperty, Set set, Collection collection) {
        for (RDFProperty rDFProperty2 : rDFProperty.getSubproperties(true)) {
            if (set.contains(rDFProperty2) || !collection.contains(rDFProperty2)) continue;
            PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this, this.cls, rDFProperty2, true);
            this.rootNode.add(propertyTreeNode);
            set.add(rDFProperty2);
        }
    }

    private void addRestrictionToDefinition(OWLRestriction oWLRestriction) {
        OWLModel oWLModel = this.cls.getOWLModel();
        AbstractRDFSClass abstractRDFSClass = (AbstractRDFSClass)this.cls.getDefinition();
        if (abstractRDFSClass instanceof OWLIntersectionClass) {
            OWLIntersectionClass oWLIntersectionClass = (OWLIntersectionClass)((Object)abstractRDFSClass);
            String string = oWLRestriction.getBrowserText();
            if (oWLIntersectionClass.hasOperandWithBrowserText(string)) {
                this.displaySemanticError("The class " + string + " is already in the list.");
                return;
            }
            oWLIntersectionClass.addOperand(oWLRestriction);
        } else {
            OWLIntersectionClass oWLIntersectionClass = oWLModel.createOWLIntersectionClass();
            oWLIntersectionClass.addOperand(abstractRDFSClass.createClone());
            oWLIntersectionClass.addOperand(oWLRestriction);
            if (abstractRDFSClass instanceof OWLAnonymousClass) {
                abstractRDFSClass.delete();
            }
            abstractRDFSClass.delete();
            this.cls.addEquivalentClass(oWLIntersectionClass);
        }
    }

    private void createRestrictionInline(Cls cls) {
        Instance instance = this.getSelectedInstance();
        if (instance != null) {
            RDFProperty rDFProperty = instance instanceof RDFProperty ? (RDFProperty)instance : ((OWLRestriction)instance).getOnProperty();
            PropertyTreeNode propertyTreeNode = this.getPropertyTreeNode(rDFProperty);
            this.expandPath(new TreePath(new Object[]{this.rootNode, propertyTreeNode}));
            this.newNode = new NewRestrictionTreeNode(cls, this);
            int n = -1;
            while (n + 1 < propertyTreeNode.getChildCount() && !propertyTreeNode.getRestrictionTreeNode(n + 1).isInherited()) {
                ++n;
            }
            propertyTreeNode.insert(this.newNode, ++n);
            this.model.nodesWereInserted(propertyTreeNode, new int[]{n});
            TreePath treePath = new TreePath(new Object[]{this.rootNode, propertyTreeNode, this.newNode});
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
            this.updateUI();
            this.startEditingAtPath(treePath);
            this.owlTextField.setCaretPosition(0);
        }
    }

    private void createRestrictionFromDialog(Cls object) {
        Instance instance = this.getSelectedInstance();
        RDFProperty rDFProperty = null;
        if (instance != null) {
            RDFProperty rDFProperty2 = rDFProperty = instance instanceof RDFProperty ? (RDFProperty)instance : ((OWLRestriction)instance).getOnProperty();
        }
        if (object == null) {
            object = rDFProperty != null ? rDFProperty.getOWLModel().getCls("owl:SomeValuesFromRestriction") : this.cls.getOWLModel().getRDFSNamedClass("owl:SomeValuesFromRestriction");
        }
        this.createRestrictionFromDialog((Cls)object, rDFProperty);
    }

    private void createRestrictionFromDialog(Cls cls, RDFProperty rDFProperty) {
        OWLModel oWLModel = this.cls.getOWLModel();
        try {
            oWLModel.beginTransaction("Create restriction at " + this.cls.getBrowserText(), this.cls.getName());
            OWLRestriction oWLRestriction = RestrictionEditorPanel.showCreateDialog((Component)((Object)this), this.cls, cls, rDFProperty);
            if (oWLRestriction != null) {
                String string = oWLRestriction.getBrowserText();
                Slot slot = this.cls.getOWLModel().getSlot(":DIRECT-SUPERCLASSES");
                if (((AbstractRDFSClass)((Object)this.cls)).hasPropertyValueWithBrowserText(slot, string)) {
                    this.displaySemanticError("The restriction " + string + " is already in the list.");
                    oWLRestriction.delete();
                    return;
                }
                RDFSClass rDFSClass = this.cls.getDefinition();
                if (rDFSClass == null) {
                    this.cls.addSuperclass(oWLRestriction);
                } else {
                    this.addRestrictionToDefinition(oWLRestriction);
                }
            }
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            OWLUI.handleError(oWLModel, exception);
        }
    }

    public void displaySemanticError(String string) {
        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, string);
    }

    public void dispose() {
        this.removeListeners();
        this.disposeNodes();
    }

    private void disposeNodes() {
        PropertyTreeNode[] propertyTreeNodeArray = this.getPropertyTreeNodes();
        for (int i = 0; i < propertyTreeNodeArray.length; ++i) {
            PropertyTreeNode propertyTreeNode = propertyTreeNodeArray[i];
            propertyTreeNode.dispose();
        }
        this.rootNode.removeAllChildren();
    }

    private void expandPropertyNodes(Set set) {
        PropertyTreeNode[] propertyTreeNodeArray = this.getPropertyTreeNodes();
        for (int i = 0; i < propertyTreeNodeArray.length; ++i) {
            PropertyTreeNode propertyTreeNode = propertyTreeNodeArray[i];
            if (!set.contains(propertyTreeNode.getRDFProperty())) continue;
            this.expandPath(new TreePath(new Object[]{this.rootNode, propertyTreeNode}));
        }
    }

    public Action getCreateRestrictionAction() {
        return this.createRestrictionAction;
    }

    public Action getDeleteRestrictionAction() {
        return this.deleteRestrictionAction;
    }

    private Set getExpandedProperties() {
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        PropertyTreeNode[] propertyTreeNodeArray = this.getPropertyTreeNodes();
        for (int i = 0; i < propertyTreeNodeArray.length; ++i) {
            PropertyTreeNode propertyTreeNode = propertyTreeNodeArray[i];
            TreePath treePath = new TreePath(new Object[]{this.rootNode, propertyTreeNode});
            if (!this.isExpanded(treePath)) continue;
            hashSet.add(propertyTreeNode.getRDFProperty());
        }
        return hashSet;
    }

    private OWLNamedClass getHostCls(OWLRestriction oWLRestriction) {
        return oWLRestriction.getOwner();
    }

    private List getNextSuperclasses(RDFSNamedClass rDFSNamedClass, Set set) {
        OWLNamedClass oWLNamedClass = rDFSNamedClass.getOWLModel().getOWLThingClass();
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        for (Cls cls : rDFSNamedClass.getSuperclasses(false)) {
            if (!(cls instanceof RDFSNamedClass) || set.contains(cls) || oWLNamedClass.equals(cls)) continue;
            arrayList.add(cls);
        }
        Collections.sort(arrayList, new FrameComparator());
        return arrayList;
    }

    private JLayeredPane getParentLayeredPane() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JLayeredPane); container = container.getParent()) {
        }
        return (JLayeredPane)container;
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        RDFResource rDFResource = (RDFResource)this.getSelectedInstance();
        if (rDFResource instanceof RDFProperty) {
            this.addCreateRestrictionActions(jPopupMenu);
        } else if (rDFResource instanceof OWLRestriction) {
            RDFSClass rDFSClass;
            Object object;
            if (rDFResource instanceof OWLQuantifierRestriction && (object = (OWLQuantifierRestriction)rDFResource).getFiller() instanceof RDFSClass) {
                rDFSClass = (RDFSClass)object.getFiller();
                HashSet hashSet = new HashSet();
                rDFSClass.getNestedNamedClasses(hashSet);
                this.addNavigationMenuItems(jPopupMenu, hashSet);
            }
            object = (RestrictionTreeNode)this.getSelectedTreeNode();
            rDFSClass = ((RestrictionTreeNode)object).getInheritedFromClass();
            if (((RestrictionTreeNode)object).isInherited()) {
                jPopupMenu.add(new AbstractAction("Navigate to defining class (" + rDFSClass.getBrowserText() + ")", ProtegeUI.getIcon(rDFSClass)){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PropertyRestrictionsTree.this.navigateTo(rDFSClass);
                    }
                });
            }
            jPopupMenu.add(this.deleteRestrictionAction);
        }
        ResourceActionManager.addResourceActions(jPopupMenu, (Component)((Object)this), rDFResource);
        if (jPopupMenu.getSubElements().length > 0) {
            return jPopupMenu;
        }
        return null;
    }

    private PropertyTreeNode getPropertyTreeNode(RDFProperty rDFProperty) {
        PropertyTreeNode[] propertyTreeNodeArray = this.getPropertyTreeNodes();
        for (int i = 0; i < propertyTreeNodeArray.length; ++i) {
            PropertyTreeNode propertyTreeNode = propertyTreeNodeArray[i];
            if (!rDFProperty.equals(propertyTreeNode.getRDFProperty())) continue;
            return propertyTreeNode;
        }
        return null;
    }

    public PropertyTreeNode[] getPropertyTreeNodes() {
        int n = this.rootNode.getChildCount();
        PropertyTreeNode[] propertyTreeNodeArray = new PropertyTreeNode[n];
        for (int i = 0; i < n; ++i) {
            propertyTreeNodeArray[i] = (PropertyTreeNode)this.rootNode.getChildAt(i);
        }
        return propertyTreeNodeArray;
    }

    public Instance getSelectedInstance() {
        if (this.getSelectionCount() == 1) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedTreeNode();
            return (Instance)defaultMutableTreeNode.getUserObject();
        }
        return null;
    }

    public Collection getSelectedInstances() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                TreePath treePath = treePathArray[i];
                if (treePath.getPathCount() <= 0) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                arrayList.add(defaultMutableTreeNode.getUserObject());
            }
        }
        return arrayList;
    }

    private DefaultMutableTreeNode getSelectedTreeNode() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null && treePath.getPathCount() > 0) {
            return (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    public Collection getSelection() {
        return this.getSelectedInstances();
    }

    public void hideSymbolPanel() {
        Container container;
        if (this.symbolPanel != null && (container = this.symbolPanel.getParent()) != null) {
            container.remove(this.symbolPanel);
            Container container2 = this.getTopLevelAncestor();
            if (container2 == null) {
                Container container3 = container;
                while (container3.getParent() != null) {
                    container3 = container3.getParent();
                    container3.repaint();
                }
            } else if (container2 instanceof JFrame) {
                ((JFrame)container2).getContentPane().repaint();
            } else if (container2 instanceof JWindow) {
                ((JWindow)container2).getContentPane().repaint();
            } else if (container2 instanceof JDialog) {
                ((JDialog)container2).getContentPane().repaint();
            } else {
                container2.repaint();
            }
        }
    }

    public void init(boolean bl, boolean bl2) {
        this.setCellRenderer((TreeCellRenderer)((Object)new PropertyRestrictionsTreeRenderer(bl, bl2)));
    }

    public boolean isEditable() {
        return super.isEditable() && !this.isMixedClass();
    }

    public boolean isMixedClass() {
        RDFSClass rDFSClass = this.cls.getDefinition();
        return rDFSClass != null;
    }

    protected void navigateTo(RDFResource rDFResource) {
        OWLClassesTab oWLClassesTab = OWLClassesTab.getOWLClassesTab((Component)((Object)this));
        if (oWLClassesTab != null && rDFResource instanceof RDFSNamedClass) {
            oWLClassesTab.setSelectedCls((RDFSNamedClass)rDFResource);
        } else {
            ResultsPanelManager.showHostResource(rDFResource);
        }
    }

    public void openNodesIfPossible() {
        if (this.getParent() instanceof JViewport) {
            Serializable serializable;
            JViewport jViewport = (JViewport)this.getParent();
            int n = this.getRowHeight();
            Serializable serializable2 = null;
            for (int i = this.rootNode.getChildCount() - 1; i >= 0 && this.getRowCount() * n < jViewport.getExtentSize().height; --i) {
                serializable = (PropertyTreeNode)this.rootNode.getChildAt(i);
                if (serializable.getChildCount() <= 0) continue;
                TreePath treePath = new TreePath(new Object[]{this.rootNode, serializable});
                this.expandPath(treePath);
                serializable2 = serializable;
            }
            if (serializable2 != null && this.getRowCount() * n > jViewport.getExtentSize().height) {
                serializable = new TreePath(new Object[]{this.rootNode, serializable2});
                this.collapsePath((TreePath)serializable);
            }
        }
    }

    void refill() {
        Set set = this.getExpandedProperties();
        this.disposeNodes();
        this.addChildNodes();
        this.model.nodeStructureChanged(this.rootNode);
        this.expandPropertyNodes(set);
    }

    void refillLater() {
        if (!this.refilling) {
            this.refilling = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PropertyRestrictionsTree.this.refill();
                    PropertyRestrictionsTree.this.refilling = false;
                }
            });
        }
    }

    private void removeListeners() {
        if (this.cls != null) {
            this.cls.removeClassListener(this.classListener);
        }
    }

    public void setCls(OWLNamedClass oWLNamedClass) {
        if (oWLNamedClass != this.cls) {
            this.removeListeners();
            this.disposeNodes();
            this.cls = oWLNamedClass;
            this.addChildNodes();
            this.model.nodeStructureChanged(this.rootNode);
            if (oWLNamedClass != null) {
                oWLNamedClass.addClassListener(this.classListener);
            }
        }
    }

    public void setSelectedRestriction(OWLRestriction oWLRestriction) {
        OldRestrictionTreeNode oldRestrictionTreeNode;
        RDFProperty rDFProperty = oWLRestriction.getOnProperty();
        PropertyTreeNode propertyTreeNode = this.getPropertyTreeNode(rDFProperty);
        if (propertyTreeNode != null && (oldRestrictionTreeNode = propertyTreeNode.getRestrictionTreeNode(oWLRestriction.getBrowserText())) != null) {
            TreePath treePath = new TreePath(new Object[]{this.rootNode, propertyTreeNode, oldRestrictionTreeNode});
            this.expandPath(treePath);
            this.setSelectionPath(treePath);
        }
    }

    private void showSymbolPanel(RDFProperty rDFProperty, Cls cls, boolean bl) {
        int n;
        JLayeredPane jLayeredPane = this.getParentLayeredPane();
        Rectangle rectangle = this.getRowBounds(this.getSelectionRows()[0]);
        Point point = this.getLocationOnScreen();
        Point point2 = jLayeredPane.getLocationOnScreen();
        rectangle.translate(point.x - point2.x, point.y - point2.y);
        Dimension dimension = this.symbolPanel.getPreferredSize();
        int n2 = this.getX() + rectangle.x;
        if (dimension.width > rectangle.width) {
            n2 = Math.max(0, this.getX() + rectangle.x - (dimension.width - rectangle.width));
        }
        if ((n = rectangle.y + rectangle.height + 4) + this.symbolPanel.getHeight() >= jLayeredPane.getHeight()) {
            n = rectangle.y - this.symbolPanel.getHeight();
        }
        this.symbolPanel.setLocation(n2, n);
        this.symbolPanel.displayError((Throwable)null);
        this.symbolPanel.setErrorFlag(bl);
        this.symbolPanel.enableActions(rDFProperty, cls);
        jLayeredPane.setLayer(this.symbolPanel, JLayeredPane.POPUP_LAYER);
        jLayeredPane.add(this.symbolPanel);
    }

    private void sortPropertyTreeNodes() {
        int n;
        int n2 = this.rootNode.getChildCount();
        Object[] objectArray = new PropertyTreeNode[n2];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = (PropertyTreeNode)this.rootNode.getChildAt(n);
        }
        Arrays.sort(objectArray);
        this.rootNode.removeAllChildren();
        for (n = 0; n < objectArray.length; ++n) {
            Object object = objectArray[n];
            this.rootNode.add((MutableTreeNode)object);
        }
    }

    private void startEditing(MouseEvent mouseEvent) {
        this.startEditingAtPath(this.getSelectionPath());
        int n = mouseEvent.getX() - this.getRowBounds((int)this.getSelectionRows()[0]).x;
        n -= this.owlTextField.getX();
        String string = this.owlTextField.getText();
        FontMetrics fontMetrics = this.owlTextField.getFontMetrics(this.owlTextField.getFont());
        for (int i = 1; i < string.length(); ++i) {
            if (fontMetrics.stringWidth(string.substring(0, i)) < n) continue;
            this.owlTextField.setCaretPosition(i - 1);
            break;
        }
    }

    public void startEditingAtPath(TreePath treePath) {
        RestrictionTreeNode restrictionTreeNode = (RestrictionTreeNode)this.getSelectedTreeNode();
        Cls cls = restrictionTreeNode.getRestrictionMetaCls();
        super.startEditingAtPath(treePath);
        String string = cls.getName();
        OWLModel oWLModel = (OWLModel)cls.getKnowledgeBase();
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.Qualified_Cardinality_Restrictions) || "owl:AllValuesFromRestriction".equals(string) || "owl:SomeValuesFromRestriction".equals(string) || "owl:HasValueRestriction".equals(string)) {
            this.showSymbolPanel(restrictionTreeNode.getParentNode().getRDFProperty(), cls, false);
        }
    }

    private void updateCreateRestrictionActionAllowed() {
        boolean bl = !this.isMixedClass() && (this.cls.isEditable() || this.cls.getDefinition() == null);
        this.createRestrictionAction.setAllowed(bl);
    }

    private void updateEditable() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedTreeNode();
        boolean bl = false;
        if (defaultMutableTreeNode instanceof RestrictionTreeNode) {
            RestrictionTreeNode restrictionTreeNode = (RestrictionTreeNode)defaultMutableTreeNode;
            bl = !restrictionTreeNode.isInherited();
        }
        this.setEditable(bl);
    }

    private void viewSelectedProperty() {
        Instance instance = this.getSelectedInstance();
        if (instance instanceof RDFProperty) {
            ProtegeUI.show((RDFProperty)instance);
        }
    }

    private class MyTreeCellEditor
    extends DefaultTreeCellEditor {
        MyTreeCellEditor() {
            super((JTree)((Object)PropertyRestrictionsTree.this), new DefaultTreeCellRenderer());
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            OWLTextField oWLTextField = PropertyRestrictionsTree.this.owlTextField;
            PropertyRestrictionsTree.this.owlTextField.setSymbolEditorHandler(new SymbolEditorHandler(){

                public void stopEditing() {
                    MyTreeCellEditor.this.stopCellEditing();
                }

                public void cancelEditing() {
                    MyTreeCellEditor.this.cancelCellEditing();
                }
            });
            PropertyRestrictionsTree.this.symbolPanel.setSymbolEditor(PropertyRestrictionsTree.this.owlTextField);
            RestrictionTreeNode restrictionTreeNode = (RestrictionTreeNode)object;
            PropertyRestrictionsTree.this.owlTextField.setText(restrictionTreeNode.getFillerText());
            JPanel jPanel = new JPanel(new BorderLayout(1, 0));
            jPanel.setOpaque(false);
            jPanel.add("Center", oWLTextField);
            Icon icon = restrictionTreeNode.getIcon();
            jPanel.add("West", new JLabel(icon));
            Dimension dimension = jPanel.getPreferredSize();
            jPanel.setSize(new Dimension(dimension.width + 100, dimension.height));
            return jPanel;
        }

        public Object getCellEditorValue() {
            return PropertyRestrictionsTree.this.owlTextField.getText();
        }
    }

    private class CreateRestrictionAction
    extends AbstractAction {
        private Cls metaCls;

        CreateRestrictionAction(Cls cls, String string, Icon icon) {
            super("Create " + string + " restriction", icon);
            this.metaCls = cls;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyRestrictionsTree.this.createRestrictionInline(this.metaCls);
        }
    }
}

