/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class HierarchyPanel
extends JPanel
implements Disposable {
    private Action spawnAction = new AbstractAction("Spawn off cloned window", OWLIcons.getImageIcon("SpawnHierarchy")){

        public void actionPerformed(ActionEvent actionEvent) {
            HierarchyPanel.this.spawn();
        }
    };
    protected Hierarchy hierarchy;
    protected HierarchyManager hierarchyManager;
    private NavigationHistoryManager navigationHistoryManager;
    private Hierarchy nestedHierarchy;
    private JSplitPane nestedSplitPane;
    protected JToolBar toolBar;

    public HierarchyPanel(Hierarchy hierarchy, HierarchyManager hierarchyManager, boolean bl, OWLModel oWLModel) {
        Container container;
        this.hierarchy = hierarchy;
        this.hierarchyManager = hierarchyManager;
        if (bl) {
            this.navigationHistoryManager = new NavigationHistoryManager(hierarchy, oWLModel);
            this.navigationHistoryManager.add(oWLModel.getOWLThingClass());
        }
        this.setLayout(new BorderLayout(0, 1));
        this.toolBar = OWLUI.createToolBar();
        HeaderComponent headerComponent = hierarchy.getHeaderComponent();
        if (bl) {
            container = ComponentFactory.addToolBarButton((JToolBar)this.toolBar, (Action)this.navigationHistoryManager.getBackAction(), (int)15);
            ((JComponent)container).setOpaque(false);
            this.navigationHistoryManager.getBackAction().activateComboBox((JButton)container);
            JButton jButton = ComponentFactory.addToolBarButton((JToolBar)this.toolBar, (Action)this.navigationHistoryManager.getForwardAction(), (int)15);
            jButton.setOpaque(false);
            this.navigationHistoryManager.getForwardAction().activateComboBox(jButton);
            this.toolBar.addSeparator();
        }
        ComponentFactory.addToolBarButton((JToolBar)this.toolBar, (Action)this.spawnAction, (int)15).setOpaque(false);
        container = (Container)headerComponent.getComponent(0);
        this.toolBar.setBackground(container.getBackground());
        container.add("East", this.toolBar);
        headerComponent.setTitle(hierarchy.getType());
        this.add("Center", (Component)((Object)hierarchy));
        this.setMinimumSize(new Dimension(40, 40));
    }

    public void dispose() {
        if (this.navigationHistoryManager != null) {
            this.navigationHistoryManager.dispose();
        }
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Hierarchy getNestedHierarchy() {
        return this.nestedHierarchy;
    }

    public String getTitle() {
        return this.hierarchy.getTitle();
    }

    public boolean isSynchronized() {
        return true;
    }

    public void setNestedHierarchy(Hierarchy hierarchy) {
        if (hierarchy != null) {
            Component component = (Component)((Object)this.hierarchy);
            int n = component.getHeight();
            Component component2 = (Component)((Object)hierarchy);
            this.nestedSplitPane = new JSplitPane(0, component, component2);
            this.removeAll();
            this.add("Center", this.nestedSplitPane);
            this.revalidate();
            this.nestedSplitPane.setDividerLocation(n - 150);
            this.nestedSplitPane.setResizeWeight(1.0);
            this.revalidate();
            hierarchy.addSelectionListener(new SelectionListener(){

                public void selectionChanged(SelectionEvent selectionEvent) {
                    RDFSClass rDFSClass = HierarchyPanel.this.nestedHierarchy.getSelectedClass();
                    if (rDFSClass != null) {
                        HierarchyPanel.this.hierarchy.setSelectedClass(rDFSClass);
                    }
                }
            });
        } else if (this.nestedSplitPane != null) {
            ComponentUtilities.dispose((Component)this.nestedSplitPane.getBottomComponent());
            this.removeAll();
            this.add("Center", (Component)((Object)this.hierarchy));
            this.nestedSplitPane = null;
            this.revalidate();
        }
        this.nestedHierarchy = hierarchy;
    }

    private void spawn() {
        Hierarchy hierarchy = this.hierarchy.createClone();
        this.hierarchyManager.spawnHierarchy(hierarchy);
    }
}

