/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;

public class ConvertToPrimitiveClassAction
extends ResourceAction {
    public ConvertToPrimitiveClassAction() {
        super("Convert to primitive class", OWLIcons.getImageIcon("PrimitiveClass"), "Edit", true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLClassesTab oWLClassesTab = OWLClassesTab.getOWLClassesTab(this.getComponent());
        try {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)this.getResource();
            this.getOWLModel().beginTransaction("Convert " + oWLNamedClass.getBrowserText() + " to primitive class", oWLNamedClass == null ? null : oWLNamedClass.getName());
            ConvertToPrimitiveClassAction.performAction(oWLNamedClass);
            this.getOWLModel().commitTransaction();
        }
        catch (Exception exception) {
            this.getOWLModel().rollbackTransaction();
            OWLUI.handleError(this.getOWLModel(), exception);
        }
        if (oWLClassesTab != null) {
            oWLClassesTab.ensureClassSelected((OWLNamedClass)this.getResource(), -1);
        }
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return component instanceof ResourceDisplay && rDFResource instanceof OWLNamedClass && rDFResource.isEditable() && ((OWLNamedClass)rDFResource).getDefinition() != null;
    }

    public static void performAction(OWLNamedClass oWLNamedClass) {
        ArrayList arrayList = new ArrayList(oWLNamedClass.getEquivalentClasses());
        for (RDFSClass rDFSClass : arrayList) {
            if (rDFSClass instanceof OWLIntersectionClass) {
                OWLIntersectionClass oWLIntersectionClass = (OWLIntersectionClass)rDFSClass;
                Collection collection = oWLIntersectionClass.getOperands();
                for (RDFSClass rDFSClass2 : collection) {
                    oWLNamedClass.addSuperclass(rDFSClass2.createClone());
                }
                oWLIntersectionClass.delete();
                for (RDFSClass rDFSClass2 : collection) {
                    if (!(rDFSClass2 instanceof RDFSNamedClass)) continue;
                    oWLNamedClass.addSuperclass(rDFSClass2);
                }
                continue;
            }
            if (rDFSClass == null) continue;
            rDFSClass.removeSuperclass(oWLNamedClass);
            if (!(rDFSClass instanceof RDFSNamedClass) || rDFSClass.getSuperclassCount() != 0) continue;
            rDFSClass.addSuperclass(rDFSClass.getOWLModel().getOWLThingClass());
        }
    }
}

