/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class ConvertToDefinedClassAction
extends ResourceAction {
    public ConvertToDefinedClassAction() {
        super("Convert to defined class", OWLIcons.getImageIcon("DefinedOWLClass"), "Edit", true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)this.getResource();
            this.getOWLModel().beginTransaction("Convert " + oWLNamedClass.getBrowserText() + " to defined class", oWLNamedClass == null ? null : oWLNamedClass.getName());
            ConvertToDefinedClassAction.performAction(oWLNamedClass);
            this.getOWLModel().commitTransaction();
        }
        catch (Exception exception) {
            this.getOWLModel().rollbackTransaction();
            OWLUI.handleError(this.getOWLModel(), exception);
        }
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return component instanceof ResourceDisplay && rDFResource instanceof OWLNamedClass && rDFResource.isEditable() && ((OWLNamedClass)rDFResource).getDefinition() == null;
    }

    public static void performAction(OWLNamedClass oWLNamedClass) {
        OWLModel oWLModel = oWLNamedClass.getOWLModel();
        ArrayList arrayList = new ArrayList(oWLNamedClass.getSuperclasses(false));
        arrayList.remove(oWLNamedClass.getOWLModel().getOWLThingClass());
        if (arrayList.size() == 1) {
            RDFSClass rDFSClass = (RDFSClass)arrayList.iterator().next();
            rDFSClass.addSuperclass(oWLNamedClass);
        } else if (arrayList.size() > 1) {
            OWLIntersectionClass oWLIntersectionClass = oWLModel.createOWLIntersectionClass();
            for (RDFSClass rDFSClass : arrayList) {
                oWLIntersectionClass.addOperand(rDFSClass.createClone());
            }
            oWLNamedClass.setDefinition(oWLIntersectionClass);
            for (RDFSClass rDFSClass : arrayList) {
                if (!(rDFSClass instanceof OWLAnonymousClass)) continue;
                rDFSClass.delete();
            }
        }
    }
}

