/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.component.property;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLExistentialRestriction;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.util.ClosureAxiomFactory;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.PropertyFormTableModel;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.OWLSymbolPanel;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextAreaPanel;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTable;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class PropertyFormTable
extends SymbolTable
implements Disposable {
    private PropertyFormTableModel tableModel;

    public PropertyFormTable(PropertyFormTableModel propertyFormTableModel, OWLNamedClass oWLNamedClass, RDFProperty rDFProperty) {
        super(propertyFormTableModel, oWLNamedClass.getOWLModel(), true, new OWLSymbolPanel(oWLNamedClass.getOWLModel(), true, true));
        this.tableModel = propertyFormTableModel;
    }

    protected SymbolEditorComponent createSymbolEditorComponent(OWLModel oWLModel, SymbolErrorDisplay symbolErrorDisplay) {
        return new ClassDescriptionEditorComponent(oWLModel, symbolErrorDisplay, true);
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    protected String editMultiLine(RDFResource rDFResource) {
        if (rDFResource instanceof RDFSClass) {
            return OWLTextAreaPanel.showEditDialog((Component)((Object)this), this.getOWLModel(), (RDFSClass)rDFResource);
        }
        return null;
    }

    protected Collection getNavigationMenuItems(RDFResource rDFResource) {
        if (rDFResource instanceof RDFSClass) {
            HashSet hashSet = new HashSet();
            ((RDFSClass)rDFResource).getNestedNamedClasses(hashSet);
            return hashSet;
        }
        return Collections.EMPTY_LIST;
    }

    public PropertyFormTableModel getTableModel() {
        return this.tableModel;
    }

    protected String getToolTipText(RDFResource rDFResource) {
        String string;
        if (rDFResource instanceof RDFSClass && (string = OWLUI.getOWLToolTipText((RDFSClass)rDFResource)) != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    public boolean isClosed() {
        if (this.tableModel.getRowCount() > 0) {
            OWLExistentialRestriction oWLExistentialRestriction = this.tableModel.getRestriction(0);
            return ClosureAxiomFactory.getClosureAxiom(this.tableModel.getNamedClass(), oWLExistentialRestriction) != null;
        }
        return false;
    }

    protected void navigateTo(RDFResource rDFResource) {
        OWLClassesTab oWLClassesTab = OWLClassesTab.getOWLClassesTab((Component)((Object)this));
        if (oWLClassesTab != null && rDFResource instanceof RDFSNamedClass) {
            oWLClassesTab.setSelectedCls((RDFSNamedClass)rDFResource);
        }
    }

    public void setClosed(boolean bl) {
    }
}

