/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class ResourceActionManager {
    private static Map map = new HashMap();
    private static Set userDefinedClasses = new HashSet();

    public static void addResourceActionClass(Class clazz) {
        userDefinedClasses.add(clazz);
    }

    public static void addResourceActions(JPopupMenu jPopupMenu, Component component, RDFResource rDFResource) {
        List list = ResourceActionManager.getResourceActions(component, rDFResource);
        if (list.size() > 0) {
            if (jPopupMenu.getSubElements().length > 0) {
                jPopupMenu.addSeparator();
            }
            Collections.sort(list);
            String string = null;
            JMenu jMenu = null;
            for (ResourceAction resourceAction : list) {
                String string2 = resourceAction.getGroup();
                if (string2 != null && !string2.equals(string)) {
                    boolean bl = string2.endsWith("/");
                    if (string != null && !string.endsWith("/") || !bl) {
                        jPopupMenu.addSeparator();
                    }
                    if (bl) {
                        jMenu = new JMenu(string2.substring(0, string2.length() - 1));
                        jPopupMenu.add(jMenu);
                    } else {
                        jMenu = null;
                    }
                }
                if (jMenu == null) {
                    jPopupMenu.add(resourceAction);
                } else {
                    jMenu.add(resourceAction);
                }
                string = string2;
            }
        }
    }

    public static void addResourceActions(JToolBar jToolBar, Component component, RDFResource rDFResource) {
        List list = ResourceActionManager.getResourceActions(component, rDFResource);
        if (list.size() > 0) {
            jToolBar.addSeparator();
            Collections.sort(list);
            String string = null;
            for (ResourceAction resourceAction : list) {
                if (!resourceAction.isInToolBar()) continue;
                String string2 = resourceAction.getGroup();
                if (string2 != null && !string2.equals(string)) {
                    jToolBar.addSeparator();
                }
                ResourceAction resourceAction2 = ResourceActionManager.createClone(resourceAction);
                ComponentFactory.addToolBarButton((JToolBar)jToolBar, (Action)resourceAction2);
                string = string2;
            }
        }
    }

    private static List getResourceActions(Component component, RDFResource rDFResource) {
        ArrayList<ResourceAction> arrayList = new ArrayList<ResourceAction>();
        if (rDFResource != null) {
            Class[] classArray = ResourceActionManager.getResourceActionClasses();
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz = classArray[i];
                ResourceAction resourceAction = ResourceActionManager.getResourceAction(clazz);
                if (!resourceAction.isSuitable(component, rDFResource)) continue;
                resourceAction.initialize(component, rDFResource);
                arrayList.add(resourceAction);
            }
        }
        return arrayList;
    }

    public static ResourceAction createClone(ResourceAction resourceAction) {
        Class<?> clazz = resourceAction.getClass();
        try {
            ResourceAction resourceAction2 = (ResourceAction)clazz.newInstance();
            resourceAction2.initialize(resourceAction.getComponent(), resourceAction.getResource());
            return resourceAction2;
        }
        catch (Exception exception) {
            System.err.println("[ResourceActionManager] Fatal Error: Could not create ResourceAction for " + clazz);
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            return null;
        }
    }

    public static ResourceAction getResourceAction(Class clazz) {
        ResourceAction resourceAction = (ResourceAction)map.get(clazz);
        if (resourceAction == null) {
            try {
                resourceAction = (ResourceAction)clazz.newInstance();
                map.put(clazz, resourceAction);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "[ResourceActionManager] Fatal Error: Could not create ResourceAction for " + clazz, exception);
            }
        }
        return resourceAction;
    }

    public static Class[] getResourceActionClasses() {
        ArrayList arrayList = new ArrayList(PluginUtilities.getClassesWithAttribute((String)"ResourceAction", (String)"True"));
        arrayList.addAll(userDefinedClasses);
        return arrayList.toArray(new Class[0]);
    }

    public static void setResourceActionsEnabled(JPopupMenu jPopupMenu, boolean bl) {
        for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
            Component component = jPopupMenu.getComponent(i);
            if (!(component instanceof Component)) continue;
            component.setEnabled(bl);
        }
    }
}

