/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class DeleteAllPropertyValuesAction
extends AbstractAction {
    private RDFProperty property;
    private Collection targetFrames;
    private String type;

    public DeleteAllPropertyValuesAction(String string, RDFProperty rDFProperty, Collection collection, String string2) {
        this(string, rDFProperty, collection, Icons.getBlankIcon());
    }

    public DeleteAllPropertyValuesAction(String string, RDFProperty rDFProperty, Collection collection, Icon icon) {
        super("Delete all values of selected property in " + string, icon);
        this.property = rDFProperty;
        this.targetFrames = collection;
        this.type = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLModel oWLModel = this.property.getOWLModel();
        try {
            oWLModel.beginTransaction((String)this.getValue("Name"), this.property == null ? null : this.property.getName());
            for (RDFResource rDFResource : this.targetFrames) {
                Collection collection = rDFResource.getPropertyValues(this.property);
                for (Object e : collection) {
                    rDFResource.removePropertyValue(this.property, e);
                }
            }
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            OWLUI.handleError(oWLModel, exception);
        }
    }
}

