/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.todo;

import edu.stanford.smi.protegex.owl.model.Deprecatable;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import java.util.Collections;
import java.util.List;

public class DeprecationOWLTest
extends AbstractOWLTest
implements RDFSClassTest,
RDFPropertyTest {
    public String getDocumentation() {
        return "<HTML>Finds all classes and properties that are marked as deprecated using owl:DeprecatedClass or owl:DeprecatedProperty.</HTML>";
    }

    public String getGroup() {
        return "Maintenance Tests";
    }

    public String getName() {
        return "List deprecated classes and properties";
    }

    public List test(RDFProperty rDFProperty) {
        if (rDFProperty instanceof Deprecatable && rDFProperty.isDeprecated()) {
            return Collections.singletonList(new DefaultOWLTestResult("Property " + rDFProperty.getBrowserText() + " has been deprecated.", rDFProperty, 2, this));
        }
        return Collections.EMPTY_LIST;
    }

    public List test(RDFSClass rDFSClass) {
        if (rDFSClass instanceof Deprecatable && ((Deprecatable)((Object)rDFSClass)).isDeprecated()) {
            return Collections.singletonList(new DefaultOWLTestResult("Class " + rDFSClass.getBrowserText() + " has been deprecated.", rDFSClass, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

