/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SubpropertyDomainMustNarrowTest
extends AbstractOWLTest
implements RDFPropertyTest {
    public SubpropertyDomainMustNarrowTest() {
        super("Sanity Tests", "Domain of a subproperty can only narrow superproperty");
    }

    public static OWLObjectProperty fails(OWLObjectProperty oWLObjectProperty) {
        Collection collection = oWLObjectProperty.getUnionDomain();
        for (RDFProperty rDFProperty : oWLObjectProperty.getSuperproperties(true)) {
            Collection collection2;
            if (!(rDFProperty instanceof OWLObjectProperty) || (collection2 = rDFProperty.getUnionDomain()).isEmpty() && rDFProperty.getSuperpropertyCount() != 0 || SubpropertyDomainMustNarrowTest.isSubClasses(collection2, collection)) continue;
            return (OWLObjectProperty)rDFProperty;
        }
        return null;
    }

    private static boolean isSubClasses(Collection collection, Collection collection2) {
        for (RDFSClass rDFSClass : collection2) {
            if (!(rDFSClass instanceof RDFSNamedClass)) continue;
            boolean bl = false;
            for (RDFSClass rDFSClass2 : collection) {
                if (!(rDFSClass2 instanceof RDFSNamedClass) || !rDFSClass.equals(rDFSClass2) && !rDFSClass.getSuperclasses(true).contains(rDFSClass2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public List test(RDFProperty rDFProperty) {
        OWLObjectProperty oWLObjectProperty;
        if (rDFProperty instanceof OWLObjectProperty && (oWLObjectProperty = SubpropertyDomainMustNarrowTest.fails((OWLObjectProperty)rDFProperty)) != null) {
            return Collections.singletonList(new DefaultOWLTestResult("The domain of " + rDFProperty.getBrowserText() + " is not a subset of the domain of its superproperty " + oWLObjectProperty.getBrowserText() + ".", rDFProperty, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

